/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.mlm;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.mlm.MLMData;
import com.Crowdsourcing.mlm.PaydirtMineData;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingMLM {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingMLM.class);
    @Inject
    private CrowdsourcingManager manager;
    @Inject
    private Client client;
    private static final String CHAT_MESSAGE_PAYDIRT = "You manage to mine some pay-dirt.";
    private static final String COLLECT_ORE_FROM_SACK = "You collect your ore from the sack.";
    private static final int MOTHERLODE_MINE_REGION_ID = 14936;
    private static final int SACK_ID = 26688;
    private Multiset<Integer> prevInventorySnapshot;
    private final EvictingQueue<PaydirtMineData> paydirtMineData = EvictingQueue.create((int)217);
    private boolean waitingForOre = false;

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.client.getLocalPlayer().getWorldLocation().getRegionID() != 14936) {
            return;
        }
        if (!this.waitingForOre) {
            return;
        }
        Widget widgetSpriteText = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_TEXT);
        if (widgetSpriteText == null) {
            return;
        }
        if (widgetSpriteText.getText().startsWith(COLLECT_ORE_FROM_SACK)) {
            this.waitingForOre = false;
            Multiset<Integer> currentInventorySnapshot = this.getInventorySnapshot();
            Multiset rewards = Multisets.difference(currentInventorySnapshot, this.prevInventorySnapshot);
            int currentSackCount = this.client.getVarbitValue(5558);
            MLMData event = new MLMData(new ArrayList<PaydirtMineData>((Collection<PaydirtMineData>)this.paydirtMineData), (Multiset<Integer>)rewards, currentSackCount, currentInventorySnapshot.count((Object)12011));
            this.manager.storeEvent(event);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        MenuAction menuAction = menuOptionClicked.getMenuAction();
        if (menuOptionClicked.getId() == 26688 && menuAction == MenuAction.GAME_OBJECT_FIRST_OPTION) {
            this.prevInventorySnapshot = this.getInventorySnapshot();
            this.waitingForOre = true;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (event.getMessage().equals(CHAT_MESSAGE_PAYDIRT)) {
            this.paydirtMineData.add((Object)new PaydirtMineData(this.client.getRealSkillLevel(Skill.MINING), this.client.getBoostedSkillLevel(Skill.MINING), this.getRingId(), this.getDiaryCompletions(), Instant.now().getEpochSecond()));
        }
    }

    private Multiset<Integer> getInventorySnapshot() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        HashMultiset inventorySnapshot = HashMultiset.create();
        if (inventory != null) {
            Arrays.stream(inventory.getItems()).forEach(arg_0 -> CrowdsourcingMLM.lambda$getInventorySnapshot$0((Multiset)inventorySnapshot, arg_0));
        }
        return inventorySnapshot;
    }

    private int getRingId() {
        ItemContainer equipContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipContainer != null) {
            Item[] items = equipContainer.getItems();
            int idx = EquipmentInventorySlot.RING.getSlotIdx();
            if (idx < items.length) {
                return equipContainer.getItems()[idx].getId();
            }
        }
        return -1;
    }

    private int getDiaryCompletions() {
        int easy = this.client.getVarbitValue(4462);
        int medium = this.client.getVarbitValue(4463);
        int hard = this.client.getVarbitValue(4464);
        int elite = this.client.getVarbitValue(4465);
        return easy + 2 * medium + 4 * hard + 8 * elite;
    }

    private static /* synthetic */ void lambda$getInventorySnapshot$0(Multiset inventorySnapshot, Item item) {
        inventorySnapshot.add((Object)item.getId(), item.getQuantity());
    }
}

