/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.inventory;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.inventory.InventoryData;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingInventory {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingInventory.class);
    @Inject
    public CrowdsourcingManager manager;
    @Inject
    public Client client;
    private static final ImmutableSet<Integer> blacklist = ImmutableSet.of((Object)InventoryID.INVENTORY.getId(), (Object)InventoryID.BANK.getId(), (Object)InventoryID.EQUIPMENT.getId(), (Object)InventoryID.TRADE.getId(), (Object)InventoryID.TRADEOTHER.getId());
    private static HashSet<Integer> seenInventories = new HashSet();

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        int id = itemContainerChanged.getContainerId();
        if (blacklist.contains((Object)id) || seenInventories.contains(id)) {
            return;
        }
        seenInventories.add(id);
        Item[] items = (Item[])itemContainerChanged.getItemContainer().getItems().clone();
        if (this.client == null || this.client.getLocalPlayer() == null) {
            return;
        }
        LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
        if (local == null) {
            return;
        }
        WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
        this.manager.storeEvent(new InventoryData(id, items, location, this.client.getAccountType().isIronman()));
    }
}

