/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.impling;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.impling.ImplingData;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;

public class CrowdsourcingImpling {
    private static final int MAX_ACTOR_VIEW_RANGE = 15;
    private WorldPoint lastPlayerLocation;
    private static final Set<Integer> INVISIBLE_IDS = ImmutableSet.of((Object)9389, (Object)9390, (Object)9391, (Object)9392, (Object)9393, (Object)9394, (Object[])new Integer[]{9395, 9396, 9397});
    @Inject
    private Client client;
    @Inject
    public CrowdsourcingManager manager;

    private static boolean isInViewRange(WorldPoint wp1, WorldPoint wp2) {
        int distance = wp1.distanceTo(wp2);
        return distance < 15;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.lastPlayerLocation = this.client.getLocalPlayer().getWorldLocation();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        int id = npc.getComposition().getId();
        if (!INVISIBLE_IDS.contains(id)) {
            return;
        }
        WorldPoint npcLocation = npc.getWorldLocation();
        if (this.lastPlayerLocation != null && CrowdsourcingImpling.isInViewRange(this.lastPlayerLocation, npcLocation)) {
            ImplingData data = new ImplingData(id, -1, npcLocation);
            this.manager.storeEvent(data);
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        NPC npc = npcChanged.getNpc();
        int id = npc.getComposition().getId();
        int oldId = npcChanged.getOld().getId();
        if (!INVISIBLE_IDS.contains(id) && !INVISIBLE_IDS.contains(oldId)) {
            return;
        }
        WorldPoint npcLocation = npc.getWorldLocation();
        ImplingData data = new ImplingData(id, oldId, npcLocation);
        this.manager.storeEvent(data);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.lastPlayerLocation = null;
        }
    }
}

