/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.experience;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.experience.ExperienceData;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingExperience {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingExperience.class);
    @Inject
    Client client;
    @Inject
    CrowdsourcingManager manager;
    private long lastAccountHash;
    private RuneScapeProfileType lastWorldType;
    private boolean initializeExperience;
    private MenuAction menuAction;
    private int id;
    private String menuOption;
    private String menuTarget;
    private int param0;
    private int param1;
    private HashMap<String, Integer> skillExperience = new HashMap();

    public void startUp() {
        this.initializeExperience = true;
    }

    @Subscribe
    private void onStatChanged(StatChanged event) {
        if (event.getSkill() == Skill.OVERALL) {
            return;
        }
        int lastExperience = this.skillExperience.get(event.getSkill().getName());
        this.skillExperience.put(event.getSkill().getName(), event.getXp());
        if (this.initializeExperience) {
            return;
        }
        if (this.client == null || this.client.getLocalPlayer() == null) {
            return;
        }
        int experienceDiff = event.getXp() - lastExperience;
        if (experienceDiff == 0) {
            return;
        }
        log.trace("Stat change " + event.getSkill().getName() + " " + (event.getXp() - lastExperience));
        int currentLevel = this.client.getRealSkillLevel(event.getSkill());
        LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
        if (local == null) {
            return;
        }
        WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
        boolean isInInstance = this.client.isInInstancedRegion();
        ExperienceData data = new ExperienceData(event.getSkill(), experienceDiff, currentLevel, location, isInInstance, this.menuAction, this.id, this.menuOption, this.menuTarget, this.param0, this.param1);
        this.manager.storeEvent(data);
    }

    private void resetState() {
        log.debug("Resetting state");
        this.skillExperience.clear();
        for (Skill s : Skill.values()) {
            if (s == Skill.OVERALL) continue;
            if (this.client != null) {
                log.debug("Putting skill exp " + s.getName() + " " + this.client.getSkillExperience(s));
                this.skillExperience.put(s.getName(), this.client.getSkillExperience(s));
                continue;
            }
            this.skillExperience.put(s.getName(), 0);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState state = event.getGameState();
        if (state == GameState.LOGGED_IN) {
            RuneScapeProfileType type = RuneScapeProfileType.getCurrent((Client)this.client);
            if (this.client.getAccountHash() != this.lastAccountHash || this.lastWorldType != type) {
                log.debug("World change: {} -> {}, {} -> {}", new Object[]{this.lastAccountHash, this.client.getAccountHash(), MoreObjects.firstNonNull((Object)this.lastWorldType, (Object)"<unknown>"), MoreObjects.firstNonNull((Object)type, (Object)"<unknown>")});
                this.lastAccountHash = this.client.getAccountHash();
                this.lastWorldType = type;
                this.resetState();
                assert (this.initializeExperience);
            }
        } else if (state == GameState.LOGGING_IN || state == GameState.HOPPING) {
            this.initializeExperience = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.initializeExperience) {
            this.initializeExperience = false;
            this.resetState();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        if (menuOptionClicked.getMenuAction() != MenuAction.WALK && !menuOptionClicked.getMenuOption().equals("Message")) {
            this.menuAction = menuOptionClicked.getMenuAction();
            this.menuOption = menuOptionClicked.getMenuOption();
            this.id = menuOptionClicked.getId();
            this.param0 = menuOptionClicked.getParam0();
            this.param1 = menuOptionClicked.getParam1();
            this.menuTarget = menuOptionClicked.getMenuTarget();
        }
    }
}

