/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.dialogue;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.dialogue.DoubleSpriteTextData;
import com.Crowdsourcing.dialogue.SpriteTextData;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingDialogue {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingDialogue.class);
    @Inject
    private Client client;
    @Inject
    private CrowdsourcingManager manager;
    private String lastSpriteText = null;
    private int lastItemId;
    private String lastDoubleSpriteText = null;
    private int lastDoubleItemId1;
    private int lastDoubleItemId2;

    @Subscribe
    public void onGameTick(GameTick tick) {
        Widget spriteWidget = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_SPRITE);
        Widget textWidget = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_TEXT);
        if (!(spriteWidget == null || textWidget == null || textWidget.getText().equals(this.lastSpriteText) && spriteWidget.getItemId() == this.lastItemId)) {
            this.lastItemId = spriteWidget.getItemId();
            this.lastSpriteText = textWidget.getText();
            log.debug(String.format("%d: %s", this.lastItemId, this.lastSpriteText));
            if (this.client == null || this.client.getLocalPlayer() == null) {
                return;
            }
            LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
            if (local == null) {
                return;
            }
            WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
            boolean isInInstance = this.client.isInInstancedRegion();
            SpriteTextData data = new SpriteTextData(this.lastSpriteText, this.lastItemId, isInInstance, location);
            this.manager.storeEvent(data);
        } else if (spriteWidget == null || textWidget == null) {
            this.lastSpriteText = null;
            this.lastItemId = -1;
        }
        Widget doubleSprite1Widget = this.client.getWidget(11, 1);
        Widget doubleSprite2Widget = this.client.getWidget(11, 3);
        Widget doubleTextWidget = this.client.getWidget(11, 2);
        if (!(doubleSprite1Widget == null || doubleTextWidget == null || doubleTextWidget.getText().equals(this.lastDoubleSpriteText) && doubleSprite1Widget.getItemId() == this.lastDoubleItemId1 && doubleSprite2Widget.getItemId() == this.lastDoubleItemId2)) {
            this.lastDoubleItemId1 = doubleSprite1Widget.getItemId();
            this.lastDoubleItemId2 = doubleSprite2Widget.getItemId();
            this.lastDoubleSpriteText = doubleTextWidget.getText();
            log.debug(String.format("%d, %d: %s", this.lastDoubleItemId1, this.lastDoubleItemId2, this.lastDoubleSpriteText));
            if (this.client == null || this.client.getLocalPlayer() == null) {
                return;
            }
            LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
            if (local == null) {
                return;
            }
            WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
            boolean isInInstance = this.client.isInInstancedRegion();
            DoubleSpriteTextData data = new DoubleSpriteTextData(this.lastDoubleSpriteText, this.lastDoubleItemId1, this.lastDoubleItemId2, isInInstance, location);
            this.manager.storeEvent(data);
        } else if (doubleSprite1Widget == null || doubleSprite2Widget == null || doubleTextWidget == null) {
            this.lastDoubleSpriteText = null;
            this.lastDoubleItemId1 = -1;
            this.lastDoubleItemId2 = -1;
        }
    }
}

