/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.clues;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.clues.ClueData;
import com.Crowdsourcing.clues.MapClueWidgetPart;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingClues {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingClues.class);
    @Inject
    private Client client;
    @Inject
    private CrowdsourcingManager manager;
    @Inject
    private ItemManager itemManager;
    private HashSet<Integer> seenClues = new HashSet();
    private Widget mapClueWidgetParent;
    private Integer clueId = -1;
    private String clueText;
    private List<MapClueWidgetPart> parts;

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        ItemComposition itemComposition;
        if ("Read".equals(event.getMenuOption()) && event.getMenuAction() == MenuAction.CC_OP && event.getMenuEntry().getItemId() != -1 && ((itemComposition = this.itemManager.getItemComposition(event.getMenuEntry().getItemId())).getName().startsWith("Clue scroll") || itemComposition.getName().startsWith("Challenge scroll")) && !this.seenClues.contains(itemComposition.getId())) {
            this.clueId = itemComposition.getId();
            if (this.clueId != 19835 && this.clueId != 23182) {
                this.seenClues.add(this.clueId);
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        Widget w;
        int groupId = event.getGroupId();
        for (int childId = 0; childId < 100 && (w = this.client.getWidget(groupId, childId)) != null; ++childId) {
            if (w.getModelId() != 3388) continue;
            this.mapClueWidgetParent = w.getParent();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.clueId == -1) {
            return;
        }
        Widget clueTextWidget = this.client.getWidget(WidgetInfo.CLUE_SCROLL_TEXT);
        if (clueTextWidget != null) {
            String candidateClueText = clueTextWidget.getText();
            if (this.clueId == 19835 && candidateClueText.equals(this.clueText)) {
                this.clueId = -1;
                return;
            }
            this.clueText = candidateClueText;
            this.submitClue();
            return;
        }
        if (this.mapClueWidgetParent != null) {
            this.parts = new ArrayList<MapClueWidgetPart>();
            for (Widget child : this.mapClueWidgetParent.getNestedChildren()) {
                this.parts.add(new MapClueWidgetPart(child.getRelativeX(), child.getRelativeY(), child.getRotationX(), child.getRotationY(), child.getRotationZ(), child.getModelId(), child.getModelZoom()));
            }
            this.clueText = "";
            this.submitClue();
        }
    }

    private void submitClue() {
        this.manager.storeEvent(new ClueData(this.clueId, this.clueText, this.parts));
        log.info("{}, {}, {}", new Object[]{this.clueId, this.clueText, this.parts});
        this.clueId = -1;
        this.parts = null;
        this.mapClueWidgetParent = null;
    }
}

