/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing.animation;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.animation.AnimationData;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsourcingAnimation {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingAnimation.class);
    @Inject
    public CrowdsourcingManager manager;
    @Inject
    public Client client;
    @Inject
    public ClientThread clientThread;
    private static HashSet<Integer> seenPlayerAnims = new HashSet();
    private static HashSet<Integer> seenNpcAnims = new HashSet();

    @Subscribe
    private void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() instanceof Player) {
            Player p = (Player)event.getActor();
            if (seenPlayerAnims.contains(p.getAnimation())) {
                return;
            }
            seenPlayerAnims.add(p.getAnimation());
            this.clientThread.invokeLater(() -> {
                LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)p.getWorldLocation());
                if (local == null) {
                    return;
                }
                WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
                boolean isInInstance = this.client.isInInstancedRegion();
                AnimationData data = new AnimationData(p.getAnimation(), -1, true, isInInstance, location);
                log.trace("Player anim id: {} stored", (Object)p.getAnimation());
                this.manager.storeEvent(data);
            });
        } else if (event.getActor() instanceof NPC) {
            NPC seenNpc = (NPC)event.getActor();
            NPCComposition seenNpcComposition = seenNpc.getTransformedComposition();
            if (seenNpcComposition == null || seenNpcComposition.getId() == -1 || seenNpc.getAnimation() == -1) {
                return;
            }
            int key = (seenNpcComposition.getId() << 16) + seenNpc.getAnimation();
            if (seenNpcAnims.contains(key)) {
                return;
            }
            seenNpcAnims.add(key);
            this.clientThread.invokeLater(() -> {
                LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)seenNpc.getWorldLocation());
                if (local == null) {
                    return;
                }
                WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local);
                boolean isInInstance = this.client.isInInstancedRegion();
                AnimationData data = new AnimationData(seenNpc.getAnimation(), seenNpcComposition.getId(), false, isInInstance, location);
                log.trace("NPC id {}: anim id {} stored", (Object)seenNpcComposition.getId(), (Object)seenNpc.getAnimation());
                this.manager.storeEvent(data);
            });
        }
    }
}

