/*
 * Decompiled with CFR 0.152.
 */
package com.Crowdsourcing;

import com.Crowdsourcing.CrowdsourcingManager;
import com.Crowdsourcing.animation.CrowdsourcingAnimation;
import com.Crowdsourcing.clues.CrowdsourcingClues;
import com.Crowdsourcing.dialogue.CrowdsourcingDialogue;
import com.Crowdsourcing.experience.CrowdsourcingExperience;
import com.Crowdsourcing.impling.CrowdsourcingImpling;
import com.Crowdsourcing.inventory.CrowdsourcingInventory;
import com.Crowdsourcing.item_sighting.CrowdsourcingItemSighting;
import com.Crowdsourcing.messages.CrowdsourcingMessages;
import com.Crowdsourcing.mlm.CrowdsourcingMLM;
import com.Crowdsourcing.monster_examine.MonsterExamine;
import com.Crowdsourcing.npc_respawn.CrowdsourcingNpcRespawn;
import com.Crowdsourcing.npc_sighting.CrowdsourcingNpcSighting;
import com.Crowdsourcing.overhead_dialogue.CrowdsourcingOverheadDialogue;
import com.Crowdsourcing.playerkit.CrowdsourcingPlayerkit;
import com.Crowdsourcing.pottery.CrowdsourcingPottery;
import com.Crowdsourcing.pyramid_plunder.CrowdsourcingPyramidPlunder;
import com.Crowdsourcing.quest_log.CrowdsourcingQuestLog;
import com.Crowdsourcing.respawns.Respawns;
import com.Crowdsourcing.scenery.CrowdsourcingScenery;
import com.Crowdsourcing.shootingstars.CrowdsourcingStars;
import com.Crowdsourcing.toa.CrowdsourcingTombs;
import com.Crowdsourcing.varbits.CrowdsourcingVarbits;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.api.events.CommandExecuted;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="OSRS Wiki Crowdsourcing (advanced)", description="Help figure out varbits, quest states, and more. See osrs.wiki/RS:CROWD")
public class AdvancedCrowdsourcingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AdvancedCrowdsourcingPlugin.class);
    private static final int SECONDS_BETWEEN_UPLOADS = 300;
    @Inject
    private EventBus eventBus;
    @Inject
    CrowdsourcingManager manager;
    @Inject
    private CrowdsourcingDialogue dialogue;
    @Inject
    private CrowdsourcingVarbits varbits;
    @Inject
    private CrowdsourcingMLM mlm;
    @Inject
    private CrowdsourcingScenery scenery;
    @Inject
    private CrowdsourcingMessages messages;
    @Inject
    private CrowdsourcingPlayerkit playerkit;
    @Inject
    private CrowdsourcingNpcSighting npcSighting;
    @Inject
    private CrowdsourcingItemSighting itemSighting;
    @Inject
    private CrowdsourcingInventory inventory;
    @Inject
    private CrowdsourcingClues clues;
    @Inject
    private CrowdsourcingAnimation animation;
    @Inject
    private CrowdsourcingNpcRespawn npcRespawn;
    @Inject
    private Respawns respawns;
    @Inject
    private MonsterExamine monsterExamine;
    @Inject
    private CrowdsourcingQuestLog questLog;
    @Inject
    private CrowdsourcingOverheadDialogue overheadDialogue;
    @Inject
    private CrowdsourcingPottery pottery;
    @Inject
    private CrowdsourcingExperience experience;
    @Inject
    private CrowdsourcingImpling impling;
    @Inject
    private CrowdsourcingPyramidPlunder pyramidPlunder;
    @Inject
    private CrowdsourcingTombs toa;
    @Inject
    private CrowdsourcingStars stars;

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this.dialogue);
        this.eventBus.register((Object)this.varbits);
        this.eventBus.register((Object)this.mlm);
        this.eventBus.register((Object)this.scenery);
        this.eventBus.register((Object)this.messages);
        this.eventBus.register((Object)this.playerkit);
        this.eventBus.register((Object)this.npcSighting);
        this.eventBus.register((Object)this.itemSighting);
        this.eventBus.register((Object)this.inventory);
        this.eventBus.register((Object)this.clues);
        this.eventBus.register((Object)this.animation);
        this.eventBus.register((Object)this.npcRespawn);
        this.eventBus.register((Object)this.questLog);
        this.eventBus.register((Object)this.overheadDialogue);
        this.eventBus.register((Object)this.pottery);
        this.eventBus.register((Object)this.experience);
        this.eventBus.register((Object)this.pyramidPlunder);
        this.eventBus.register((Object)this.toa);
        this.eventBus.register((Object)this.impling);
        this.eventBus.register((Object)this.stars);
        this.varbits.startUp();
        this.experience.startUp();
        this.pyramidPlunder.startUp();
        this.stars.reset();
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this.dialogue);
        this.eventBus.unregister((Object)this.varbits);
        this.eventBus.unregister((Object)this.mlm);
        this.eventBus.unregister((Object)this.scenery);
        this.eventBus.unregister((Object)this.messages);
        this.eventBus.unregister((Object)this.playerkit);
        this.eventBus.unregister((Object)this.npcSighting);
        this.eventBus.unregister((Object)this.itemSighting);
        this.eventBus.unregister((Object)this.inventory);
        this.eventBus.unregister((Object)this.clues);
        this.eventBus.unregister((Object)this.animation);
        this.eventBus.unregister((Object)this.npcRespawn);
        this.eventBus.unregister((Object)this.questLog);
        this.eventBus.unregister((Object)this.overheadDialogue);
        this.eventBus.unregister((Object)this.pottery);
        this.eventBus.unregister((Object)this.experience);
        this.eventBus.unregister((Object)this.pyramidPlunder);
        this.eventBus.unregister((Object)this.toa);
        this.eventBus.unregister((Object)this.impling);
        this.eventBus.unregister((Object)this.stars);
        this.varbits.shutDown();
        this.stars.reset();
    }

    @Schedule(period=300L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void submitToAPI() {
        this.manager.submitToAPI();
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        String cmd;
        switch (cmd = commandExecuted.getCommand()) {
            case "respawnon": {
                this.eventBus.register((Object)this.respawns);
                this.manager.sendMessage("Turned on respawns logger.");
                this.npcRespawn.setLogging(true);
                break;
            }
            case "respawnoff": {
                this.eventBus.unregister((Object)this.respawns);
                this.manager.sendMessage("Turned off respawns logger.");
                this.npcRespawn.setLogging(false);
                break;
            }
            case "monsteron": {
                this.eventBus.register((Object)this.monsterExamine);
                this.monsterExamine.startUp();
                this.manager.sendMessage("Turned on monster examine logger.");
                break;
            }
            case "monsteroff": {
                this.eventBus.unregister((Object)this.monsterExamine);
                this.monsterExamine.shutDown();
                this.manager.sendMessage("Turned off monster examine logger.");
            }
        }
    }
}

