/*
 * Decompiled with CFR 0.152.
 */
package com.suppliestracker.ui;

import com.suppliestracker.ItemType;
import com.suppliestracker.SuppliesTrackerItem;
import com.suppliestracker.SuppliesTrackerPlugin;
import com.suppliestracker.ui.SuppliesBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.QuantityFormatter;

@Singleton
public class SuppliesTrackerPanel
extends PluginPanel {
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    public final JPanel logsContainer = new JPanel();
    private final List<SuppliesBox> boxList = new ArrayList<SuppliesBox>();
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    public final JPanel overallPanel = new JPanel();
    private final JLabel overallSuppliesUsedLabel = new JLabel();
    private final JLabel overallCostLabel = new JLabel();
    private final JLabel overallIcon = new JLabel();
    private int overallSuppliesUsed;
    private int overallCost;
    private final SuppliesTrackerPlugin plugin;
    public JButton switchTrack;

    public SuppliesTrackerPanel(ItemManager itemManager, SuppliesTrackerPlugin plugin) {
        this.plugin = plugin;
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 1));
        this.add(layoutPanel, "North");
        this.overallPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.overallPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.overallPanel.setLayout(new BorderLayout());
        this.overallPanel.setVisible(true);
        JPanel overallInfo = new JPanel();
        overallInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        overallInfo.setLayout(new GridLayout(2, 1));
        overallInfo.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.overallSuppliesUsedLabel.setFont(FontManager.getRunescapeSmallFont());
        this.overallCostLabel.setFont(FontManager.getRunescapeSmallFont());
        overallInfo.add(this.overallSuppliesUsedLabel);
        overallInfo.add(this.overallCostLabel);
        this.overallPanel.add((Component)this.overallIcon, "West");
        this.overallPanel.add((Component)overallInfo, "Center");
        for (ItemType type : ItemType.values()) {
            SuppliesBox newBox = SuppliesBox.of(itemManager, type.getLabel(), plugin, this, type);
            this.logsContainer.add(newBox);
            this.boxList.add(newBox);
        }
        JMenuItem reset = new JMenuItem("Reset All");
        reset.addActionListener(e -> {
            this.plugin.clearSupplies();
            this.resetAll();
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(reset);
        this.overallPanel.setComponentPopupMenu(popupMenu);
        this.switchTrack = new JButton("Switch Tracking");
        this.switchTrack.setAlignmentX(0.5f);
        this.switchTrack.addActionListener(e -> plugin.switchTracking());
        layoutPanel.add(this.switchTrack);
        this.logsContainer.setLayout(new BoxLayout(this.logsContainer, 1));
        layoutPanel.add(this.overallPanel);
        layoutPanel.add(this.logsContainer);
        this.overallPanel.setVisible(false);
        this.logsContainer.setVisible(true);
        this.errorPanel.setContent("Supply trackers", "You have not used any supplies yet.\nCheck Configs for options.");
        this.add((Component)this.errorPanel);
    }

    private static String htmlLabel(String key, long value) {
        String valueStr = QuantityFormatter.quantityToStackSize((long)value);
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), key, valueStr);
    }

    public void loadHeaderIcon(BufferedImage img) {
        this.overallIcon.setIcon(new ImageIcon(img));
    }

    public void addItem(SuppliesTrackerItem item) {
        ItemType category = ItemType.categorize(item);
        for (SuppliesBox box : this.boxList) {
            if (box.getType() != category) continue;
            box.update(item);
            box.rebuild();
            break;
        }
        this.updateOverall();
    }

    public void resetAll() {
        this.overallSuppliesUsed = 0;
        this.overallCost = 0;
        for (SuppliesBox box : this.boxList) {
            box.clearAll();
        }
        this.updateOverall();
        this.logsContainer.repaint();
    }

    public void updateOverall() {
        this.overallSuppliesUsed = 0;
        for (SuppliesBox box : this.boxList) {
            this.overallSuppliesUsed = (int)((long)this.overallSuppliesUsed + box.getTotalSupplies());
        }
        this.overallCost = 0;
        for (SuppliesBox box : this.boxList) {
            this.overallCost = (int)((long)this.overallCost + box.getTotalPrice());
        }
        this.overallSuppliesUsedLabel.setText(SuppliesTrackerPanel.htmlLabel("Total Supplies: ", this.overallSuppliesUsed));
        this.overallCostLabel.setText(SuppliesTrackerPanel.htmlLabel("Total Cost: ", this.overallCost));
        if (this.overallSuppliesUsed <= 0) {
            this.add((Component)this.errorPanel);
            this.overallPanel.setVisible(false);
        } else {
            this.remove((Component)this.errorPanel);
            this.overallPanel.setVisible(true);
        }
    }

    public List<SuppliesBox> getBoxList() {
        return this.boxList;
    }
}

