/*
 * Decompiled with CFR 0.152.
 */
package com.suppliestracker.ui;

import com.suppliestracker.ItemType;
import com.suppliestracker.SuppliesTrackerItem;
import com.suppliestracker.SuppliesTrackerPlugin;
import com.suppliestracker.ui.SuppliesTrackerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;
import net.runelite.http.api.item.ItemPrice;

@Singleton
public abstract class SuppliesBox
extends JPanel {
    private static final int ITEMS_PER_ROW = 5;
    protected final SuppliesTrackerPlugin plugin;
    private final JPanel itemContainer = new JPanel();
    private final JLabel priceLabel = new JLabel();
    private final JLabel subTitleLabel = new JLabel();
    private final SuppliesTrackerPanel panel;
    ItemManager itemManager;
    static final String POTION_PATTERN = "[(]\\d[)]";
    private final String id;
    private final ItemType type;
    private final List<SuppliesTrackerItem> trackedItems = new ArrayList<SuppliesTrackerItem>();
    private long totalPrice;

    protected SuppliesBox(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
        this.itemManager = itemManager;
        this.id = id;
        this.plugin = plugin;
        this.panel = panel;
        this.type = type;
        this.render();
    }

    abstract String buildTooltip(int var1, int var2, SuppliesTrackerItem var3);

    public static SuppliesBox of(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
        switch (type) {
            case JEWELLERY: {
                return new JewellerySuppliesBox(itemManager, id, plugin, panel, type);
            }
            case CHARGES: {
                return new ChargesSuppliesBox(itemManager, id, plugin, panel, type);
            }
            case FOOD: {
                return new FoodSuppliesBox(itemManager, id, plugin, panel, type);
            }
            case POTION: {
                return new PotionSuppliesBox(itemManager, id, plugin, panel, type);
            }
            case DEATH: {
                return new DeathSuppliesBox(itemManager, id, plugin, panel, type);
            }
        }
        return new DefaultSuppliesBox(itemManager, id, plugin, panel, type);
    }

    private void render() {
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel logTitle = new JPanel(new BorderLayout(5, 0));
        logTitle.setBorder(new EmptyBorder(7, 7, 7, 7));
        logTitle.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel titleLabel = new JLabel(Text.removeTags((String)this.id));
        titleLabel.setFont(FontManager.getRunescapeSmallFont());
        titleLabel.setForeground(Color.WHITE);
        logTitle.add((Component)titleLabel, "West");
        this.subTitleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.subTitleLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        logTitle.add((Component)this.subTitleLabel, "Center");
        this.priceLabel.setFont(FontManager.getRunescapeSmallFont());
        this.priceLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        logTitle.add((Component)this.priceLabel, "East");
        this.add((Component)logTitle, "North");
        this.add((Component)this.itemContainer, "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setComponentPopupMenu(popupMenu);
        JMenuItem reset = new JMenuItem("Reset Category");
        reset.addActionListener(e -> {
            for (SuppliesTrackerItem item : this.trackedItems) {
                this.plugin.clearItem(item.getId());
            }
            this.clearAll();
            this.rebuild();
            this.panel.updateOverall();
        });
        popupMenu.add(reset);
        this.setVisible(false);
    }

    public void update(SuppliesTrackerItem item) {
        this.trackedItems.removeIf(r -> r.getId() == item.getId());
        if (item.getName() == null || item.getId() == 0 || item.getName().equalsIgnoreCase("null")) {
            this.plugin.clearItem(item.getId());
            return;
        }
        this.trackedItems.add(item);
        this.setVisible(true);
    }

    private void remove(SuppliesTrackerItem item) {
        this.trackedItems.removeIf(r -> r.getId() == item.getId());
        this.plugin.clearItem(item.getId());
        this.setVisible(this.trackedItems.size() > 0);
    }

    public void removeOne(int itemId) {
        SuppliesTrackerItem item = new SuppliesTrackerItem(0, "null", 1, 0L);
        for (SuppliesTrackerItem tItem : this.trackedItems) {
            if (tItem.getId() != itemId) continue;
            item = this.trackedItems.get(this.trackedItems.lastIndexOf(tItem));
            break;
        }
        if (item.getId() == 0) {
            return;
        }
        this.trackedItems.removeIf(r -> r.getId() == itemId);
        if (item.getQuantity() == 1) {
            this.plugin.clearItem(item.getId());
        } else {
            this.plugin.removeOneItem(item.getId());
            this.trackedItems.add(item);
        }
        this.rebuild();
        this.setVisible(this.trackedItems.size() > 0);
    }

    public void clearAll() {
        this.trackedItems.clear();
        this.totalPrice = 0L;
        this.setVisible(false);
    }

    public long getTotalSupplies() {
        long totalSupplies = 0L;
        for (SuppliesTrackerItem item : this.trackedItems) {
            totalSupplies += (long)item.getQuantity();
        }
        return totalSupplies;
    }

    public long getTotalPrice() {
        return this.totalPrice;
    }

    public void rebuild() {
        this.buildItems();
        this.priceLabel.setText(QuantityFormatter.quantityToStackSize((long)this.totalPrice) + " gp");
        this.priceLabel.setToolTipText(QuantityFormatter.formatNumber((long)this.totalPrice) + " gp");
        long supplies = this.getTotalSupplies();
        if (supplies > 0L) {
            this.subTitleLabel.setText("x " + supplies);
        } else {
            this.subTitleLabel.setText("");
        }
        this.validate();
        this.repaint();
    }

    abstract int getModifiedItemId(String var1, int var2);

    void buildItems() {
        ArrayList<SuppliesTrackerItem> items = new ArrayList<SuppliesTrackerItem>(this.trackedItems);
        this.totalPrice = 0L;
        for (SuppliesTrackerItem item : items) {
            if (item.getId() == 20802 || item.getId() == 22308) {
                this.totalPrice += (long)item.getQuantity() * 100000L;
                continue;
            }
            this.totalPrice += item.getPrice();
        }
        items.sort((i1, i2) -> Long.compare(i2.getPrice(), i1.getPrice()));
        int rowSize = (items.size() % 5 == 0 ? 0 : 1) + items.size() / 5;
        this.itemContainer.removeAll();
        this.itemContainer.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (int i = 0; i < rowSize * 5; ++i) {
            JPanel slotContainer = new JPanel();
            slotContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (i < items.size()) {
                SuppliesTrackerItem item = (SuppliesTrackerItem)items.get(i);
                JLabel imageLabel = new JLabel();
                imageLabel.setToolTipText(this.buildTooltip(this.getModifiedItemId(item.getName(), item.getId()), item.getQuantity(), item));
                imageLabel.setVerticalAlignment(0);
                imageLabel.setHorizontalAlignment(0);
                AsyncBufferedImage itemImage = this.itemManager.getImage(this.getModifiedItemId(item.getName(), item.getId()), item.getQuantity(), item.getQuantity() > 1);
                if (item.getId() == 20802) {
                    itemImage = this.itemManager.getImage(22473, item.getQuantity(), item.getQuantity() > 1);
                }
                if (item.getId() == 22308) {
                    itemImage = this.itemManager.getImage(21992, item.getQuantity(), item.getQuantity() > 1);
                }
                itemImage.addTo(imageLabel);
                slotContainer.add(imageLabel);
                if (item.getName() == null || item.getId() == 0 || item.getName().equalsIgnoreCase("null") || this.getModifiedItemId(item.getName(), item.getId()) == 0 || this.itemManager.getImage(this.getModifiedItemId(item.getName(), item.getId()), item.getQuantity(), item.getQuantity() > 1) == null) continue;
                JPopupMenu popupMenu = new JPopupMenu();
                popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
                slotContainer.setComponentPopupMenu(popupMenu);
                JMenuItem reset = new JMenuItem("Reset");
                reset.addActionListener(e -> {
                    this.remove(item);
                    this.rebuild();
                    this.panel.updateOverall();
                });
                popupMenu.add(reset);
            }
            this.itemContainer.add(slotContainer);
        }
        this.itemContainer.repaint();
    }

    public String getId() {
        return this.id;
    }

    public ItemType getType() {
        return this.type;
    }

    public List<SuppliesTrackerItem> getTrackedItems() {
        return this.trackedItems;
    }

    private static class DefaultSuppliesBox
    extends SuppliesBox {
        protected DefaultSuppliesBox(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
            super(itemManager, id, plugin, panel, type);
        }

        @Override
        final String buildTooltip(int itemId, int qty, SuppliesTrackerItem item) {
            long price = item.getPrice();
            return item.getName() + " x " + qty + " (" + QuantityFormatter.quantityToStackSize((long)price) + "gp) ";
        }

        @Override
        int getModifiedItemId(String name, int itemId) {
            return itemId;
        }
    }

    private static class DeathSuppliesBox
    extends SuppliesBox {
        protected DeathSuppliesBox(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
            super(itemManager, id, plugin, panel, type);
        }

        @Override
        final String buildTooltip(int itemId, int qty, SuppliesTrackerItem item) {
            if (itemId == 20802) {
                long price = 100000L * (long)qty;
                return "ToB Deaths x " + qty + " (" + QuantityFormatter.quantityToStackSize((long)price) + "gp) ";
            }
            if (itemId == 22308) {
                long price = 100000L * (long)qty;
                return "Vorkath Deaths x " + qty + " (" + QuantityFormatter.quantityToStackSize((long)price) + "gp) ";
            }
            return "";
        }

        @Override
        int getModifiedItemId(String name, int itemId) {
            return itemId;
        }
    }

    private static class PotionSuppliesBox
    extends SuppliesBox {
        protected PotionSuppliesBox(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
            super(itemManager, id, plugin, panel, type);
        }

        @Override
        final String buildTooltip(int itemId, int qty, SuppliesTrackerItem item) {
            long price = item.getPrice();
            return item.getName() + " x " + qty + "/4 (" + QuantityFormatter.quantityToStackSize((long)price) + "gp) ";
        }

        @Override
        int getModifiedItemId(String name, int itemId) {
            if (itemId == 24598) {
                return 24605;
            }
            if (name.endsWith("(4)") || name.endsWith("(3)") || name.endsWith("(2)") || name.endsWith("(1)")) {
                return this.getSingleDose(name);
            }
            return itemId;
        }

        private int getSingleDose(String name) {
            String nameModified = name.replace("(4)", "(1)");
            List prices = this.itemManager.search(nameModified);
            if (!prices.isEmpty()) {
                return ((ItemPrice)prices.get(0)).getId();
            }
            return 0;
        }
    }

    private static class FoodSuppliesBox
    extends SuppliesBox {
        protected FoodSuppliesBox(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
            super(itemManager, id, plugin, panel, type);
        }

        @Override
        final String buildTooltip(int itemId, int qty, SuppliesTrackerItem item) {
            long price = item.getPrice();
            return item.getName() + " x " + qty + " (" + QuantityFormatter.quantityToStackSize((long)price) + "gp) ";
        }

        @Override
        int getModifiedItemId(String name, int itemId) {
            if (SuppliesTrackerPlugin.isCake(name, itemId)) {
                return FoodSuppliesBox.getSlice(itemId);
            }
            if (SuppliesTrackerPlugin.isPizzaPie(name)) {
                return FoodSuppliesBox.getHalf(itemId);
            }
            return itemId;
        }

        private static int getSlice(int itemId) {
            switch (itemId) {
                case 1891: {
                    itemId = 1895;
                    break;
                }
                case 1897: {
                    itemId = 1901;
                }
            }
            return itemId;
        }

        private static int getHalf(int itemId) {
            switch (itemId) {
                case 2297: {
                    itemId = 2299;
                    break;
                }
                case 2293: {
                    itemId = 2295;
                    break;
                }
                case 2301: {
                    itemId = 2303;
                    break;
                }
                case 2289: {
                    itemId = 2291;
                    break;
                }
                case 2325: {
                    itemId = 2333;
                    break;
                }
                case 7178: {
                    itemId = 7180;
                    break;
                }
                case 7218: {
                    itemId = 7220;
                    break;
                }
                case 7188: {
                    itemId = 7190;
                    break;
                }
                case 19662: {
                    itemId = 19659;
                    break;
                }
                case 21690: {
                    itemId = 21687;
                    break;
                }
                case 7198: {
                    itemId = 7200;
                    break;
                }
                case 7208: {
                    itemId = 7210;
                    break;
                }
                case 2323: {
                    itemId = 2335;
                    break;
                }
                case 2327: {
                    itemId = 2331;
                }
            }
            return itemId;
        }
    }

    private static class ChargesSuppliesBox
    extends SuppliesBox {
        protected ChargesSuppliesBox(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
            super(itemManager, id, plugin, panel, type);
        }

        @Override
        final String buildTooltip(int itemId, int qty, SuppliesTrackerItem item) {
            StringBuilder tooltip = new StringBuilder();
            switch (itemId) {
                case 22325: {
                    tooltip.append("<html>").append("Blood Rune x ").append(qty * 3).append("<br>").append("Vial of Blood x ").append(qty).append("/100").append("</br>").append("<br>").append("Total: ").append(QuantityFormatter.quantityToStackSize((long)item.getPrice())).append("gp").append("</html>");
                    return tooltip.toString();
                }
                case 22323: {
                    tooltip.append("Blood Rune x ").append(qty * 3).append(" (").append(QuantityFormatter.quantityToStackSize((long)item.getPrice())).append("gp)");
                    return tooltip.toString();
                }
                case 23995: {
                    tooltip.append("Crystal Shard x ").append(qty).append(" / 100");
                    return tooltip.toString();
                }
                case 11907: {
                    tooltip.append("<html>").append("Chaos Rune x ").append(qty).append("<br>").append("Death Rune x ").append(qty).append("</br>").append("<br>").append("Fire Rune x ").append(qty * 5).append("</br>").append("<br>").append("Coins x ").append(qty * 10).append("</br>").append("<br>").append("Total: ").append(QuantityFormatter.quantityToStackSize((long)item.getPrice())).append("gp").append("</html>");
                    return tooltip.toString();
                }
                case 12899: {
                    tooltip.append("<html>").append("Chaos Rune x ").append(qty).append("<br>").append("Death Rune x ").append(qty).append("</br>").append("<br>").append("Fire Rune x ").append(qty * 5).append("</br>").append("<br>").append("Zulrah's Scales x ").append(qty).append("</br>").append("<br>").append("Total: ").append(QuantityFormatter.quantityToStackSize((long)item.getPrice())).append("gp").append("</html>");
                    return tooltip.toString();
                }
                case 27610: {
                    tooltip.append("Ancient Essence x ").append(qty);
                    return tooltip.toString();
                }
                case 27275: {
                    tooltip.append("<html>").append("Soul Rune x ").append(qty * 2).append("<br>").append("Chaos Rune x ").append(qty * 5).append("</br>").append("<br>").append("Total: ").append(QuantityFormatter.quantityToStackSize((long)item.getPrice())).append("gp").append("</html>");
                    return tooltip.toString();
                }
                case 22545: 
                case 22550: 
                case 22555: {
                    tooltip.append("<html>").append("Revenant ether x ").append(qty).append(" (").append(QuantityFormatter.quantityToStackSize((long)item.getPrice())).append("gp)").append("</html>");
                    return tooltip.toString();
                }
            }
            return tooltip.toString();
        }

        @Override
        int getModifiedItemId(String name, int itemId) {
            return itemId;
        }
    }

    private static class JewellerySuppliesBox
    extends SuppliesBox {
        protected JewellerySuppliesBox(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
            super(itemManager, id, plugin, panel, type);
        }

        @Override
        final String buildTooltip(int itemId, int qty, SuppliesTrackerItem item) {
            String name = item.getName();
            StringBuilder tooltip = new StringBuilder();
            long price = item.getPrice();
            if (name.toLowerCase().contains("glory")) {
                tooltip.append("Amulet of Glory(6) x ").append(qty).append("/6 (").append(QuantityFormatter.quantityToStackSize((long)price)).append("gp)");
            } else if (name.toLowerCase().contains("dueling")) {
                tooltip.append("Ring of Dueling(8) x ").append(qty).append("/8 (").append(QuantityFormatter.quantityToStackSize((long)price)).append("gp)");
            } else if (name.toLowerCase().contains("wealth")) {
                tooltip.append("Ring of Wealth(5) x ").append(qty).append("/5 (").append(QuantityFormatter.quantityToStackSize((long)price)).append("gp)");
            } else if (name.toLowerCase().contains("combat")) {
                tooltip.append("Combat Bracelet(6) x ").append(qty).append("/6 (").append(QuantityFormatter.quantityToStackSize((long)price)).append("gp)");
            } else if (name.toLowerCase().contains("games")) {
                tooltip.append("Games Necklace(8) x ").append(qty).append("/8 (").append(QuantityFormatter.quantityToStackSize((long)price)).append("gp)");
            } else if (name.toLowerCase().contains("skills")) {
                tooltip.append("Skills Necklace(6) x ").append(qty).append("/6 (").append(QuantityFormatter.quantityToStackSize((long)price)).append("gp)");
            } else if (name.toLowerCase().contains("passage")) {
                tooltip.append("Necklace of Passage(5) x ").append(qty).append("/5 (").append(QuantityFormatter.quantityToStackSize((long)price)).append("gp)");
            } else if (name.toLowerCase().contains("burning")) {
                tooltip.append("Burning Amulet(5) x ").append(qty).append("/5 (").append(QuantityFormatter.quantityToStackSize((long)price)).append("gp)");
            }
            return tooltip.toString();
        }

        @Override
        int getModifiedItemId(String name, int itemId) {
            return itemId;
        }
    }
}

