/*
 * Decompiled with CFR 0.152.
 */
package com.suppliestracker;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.suppliestracker.ActionType;
import com.suppliestracker.Bait;
import com.suppliestracker.BlowpipeDart;
import com.suppliestracker.ItemMenuAction;
import com.suppliestracker.RuneManager;
import com.suppliestracker.Runes;
import com.suppliestracker.Skills.Farming;
import com.suppliestracker.Skills.SkillTracker;
import com.suppliestracker.Skills.XpDropTracker;
import com.suppliestracker.SuppliesTrackerConfig;
import com.suppliestracker.SuppliesTrackerItem;
import com.suppliestracker.session.SessionHandler;
import com.suppliestracker.ui.SuppliesTrackerPanel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.Projectile;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.kit.KitType;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.item.ItemPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Supplies Used Tracker", description="Tracks supplies used during the session", tags={"cost"})
@Singleton
public class SuppliesTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SuppliesTrackerPlugin.class);
    private static final String POTION_PATTERN = "[(]\\d[)]";
    private static final Pattern eatPattern = Pattern.compile("^eat");
    private static final Pattern drinkPattern = Pattern.compile("^drink");
    private static final Pattern teleportPattern = Pattern.compile("^teleport");
    private static final Pattern teletabPattern = Pattern.compile("^break|^troll stronghold|^weiss");
    private static final Pattern spellPattern = Pattern.compile("^cast|^grand\\sexchange|^outside|^seers|^yanille");
    private static final Pattern bpDartsPattern = Pattern.compile("Darts: <col=007f00>(.*) dart x (.*)</col>\\. Scales: <col=007f00>(.*) \\((.*)%\\)</col>\\.");
    private static final int EQUIPMENT_MAINHAND_SLOT = EquipmentInventorySlot.WEAPON.getSlotIdx();
    private static final int EQUIPMENT_AMMO_SLOT = EquipmentInventorySlot.AMMO.getSlotIdx();
    private static final int EQUIPMENT_CAPE_SLOT = EquipmentInventorySlot.CAPE.getSlotIdx();
    private static final double NO_AVAS_PERCENT = 1.0;
    private static final double ASSEMBLER_PERCENT = 0.2;
    private static final double ACCUMULATOR_PERCENT = 0.28;
    private static final double ATTRACTOR_PERCENT = 0.4;
    private static final double SCALES_PERCENT = 0.6666666666666666;
    private static final int POTION_DOSES = 4;
    private static final int CAKE_DOSES = 3;
    private static final int PIZZA_PIE_DOSES = 2;
    private static final Random random = new Random();
    private Map<Integer, Integer> itemAmounts;
    public final Map<Integer, Integer> changedItems = new HashMap<Integer, Integer>(4);
    private static final Set<Integer> thrownWeaponIds = ImmutableSet.of((Object)806, (Object)812, (Object)5628, (Object)5635, (Object)807, (Object)5629, (Object[])new Integer[]{813, 5636, 808, 814, 5630, 5637, 3093, 3094, 5631, 5638, 809, 815, 5632, 5639, 810, 816, 5633, 5640, 811, 817, 5634, 5641, 25849, 25851, 25855, 25857, 11230, 11231, 11233, 11234, 864, 870, 5654, 5661, 863, 871, 5655, 5662, 865, 872, 5656, 5663, 869, 874, 5658, 5665, 866, 873, 5657, 5664, 867, 875, 5659, 5666, 868, 876, 5660, 5667, 800, 801, 802, 803, 804, 805, 22804, 22812, 22814, 22808, 22810, 22806, 20849, 10033, 10034, 11959});
    static final Set<Integer> runeIds = ImmutableSet.of((Object)554, (Object)556, (Object)555, (Object)557, (Object)558, (Object)559, (Object[])new Integer[]{564, 562, 561, 563, 560, 9075, 565, 566, 21880, 4695, 4696, 4698, 4697, 4694, 4699, 24607, 24621, 24615, 24613, 26705});
    private static final Map<Integer, SuppliesTrackerItem> suppliesEntry = new HashMap<Integer, SuppliesTrackerItem>();
    private final Map<Integer, SuppliesTrackerItem> currentSuppliesEntry = new HashMap<Integer, SuppliesTrackerItem>();
    public boolean showSession = false;
    private static final int BLOWPIPE_ATTACK = 5061;
    private static final int HIGH_LEVEL_MAGIC_ATTACK = 1167;
    private static final int LOW_LEVEL_MAGIC_ATTACK = 1162;
    private static final int BARRAGE_ANIMATION = 1979;
    private static final int BLITZ_ANIMATION = 1978;
    private static final int SCYTHE_OF_VITUR_ANIMATION = 8056;
    private static final int TUMEKENS_SHADOW_ANIMATION = 9493;
    private static final int VENATOR_BOW_ANIMATION = 9858;
    private static final int ONEHAND_SLASH_SWORD = 390;
    private static final int ONEHAND_STAB_SWORD = 386;
    private static final int GAUNTLET_PADDLEFISH = 23874;
    private static final int LOW_LEVEL_STANDARD_SPELLS = 711;
    private static final int WAVE_SPELL_ANIMATION = 727;
    private static final int SURGE_SPELL_ANIMATION = 7855;
    private static final int HIGH_ALCH_ANIMATION = 713;
    private static final int LUNAR_HUMIDIFY = 6294;
    private static final int ENSOULED_HEADS_ANIMATION = 7198;
    private static final int IBANS_STAFF_ANIMATION = 708;
    private static final int SLAYERS_STAFF_ANIMATION = 1576;
    private static final int ENTANGLE_ANIMATION = 1161;
    private static final int VULNERABILITY_ANIMATION = 1165;
    private static final int CRUMBLE_UNDEAD_ANIMATION = 1166;
    private static final int ENFEEBLE_ANIMATION = 1168;
    private static final int STUN_ANIMATION = 1169;
    private static final int BOW_SHOOT_ANIMATION = 426;
    private static final int WEBWEAVER_SPEC_ANIMATION = 9964;
    private static final int ACCURSED_SPEC_ANIMATION = 9961;
    private static final int CHAINMACE_ANIMATION = 245;
    private static final int CHAINMACE_SPEC_ANIMATION = 9963;
    private final Deque<ItemMenuAction> actionStack = new ArrayDeque<ItemMenuAction>();
    private final String[] RAIDS_CONSUMABLES = new String[]{"xeric's", "elder", "twisted", "revitalisation", "overload", "prayer enhance", "pysk", "suphi", "leckish", "brawk", "mycil", "roqed", "kyren", "guanic", "prael", "giral", "phluxia", "kryket", "murng", "psykk", "egniol"};
    private final Set<Integer> TRIDENT_OF_THE_SEAS_IDS = ImmutableSet.of((Object)11907, (Object)22288, (Object)11905);
    private final Set<Integer> TRIDENT_OF_THE_SWAMP_IDS = ImmutableSet.of((Object)22292, (Object)12899, (Object)22294, (Object)12900);
    private final Set<Integer> IBANS_STAFF_IDS = ImmutableSet.of((Object)1409, (Object)12658);
    private final Set<Integer> TUMEKENS_SHADOW_IDS = ImmutableSet.of((Object)27277, (Object)27275);
    private int ammoId = 0;
    private int ammoAmount = 0;
    private int thrownId = 0;
    private int thrownAmount = 0;
    private boolean ammoLoaded = false;
    private boolean throwingAmmoLoaded = false;
    private int mainHandId = 0;
    private SuppliesTrackerPanel panel;
    private NavigationButton navButton;
    private int attackStyleVarbit = -1;
    private boolean sessionLoading = false;
    private SessionHandler sessionHandler;
    private long sessionHash = -1L;
    private Projectile lastBlowpipeProj = null;
    private BlowpipeDart blowpipeDart = BlowpipeDart.ADAMANT;
    @Inject
    private Bait bait;
    private static final int[] AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
    private static final int[] RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};
    private static final int[] OLD_AMOUNT_VARBITS = new int[]{0, 0, 0, 0};
    private static final int[] OLD_RUNE_VARBITS = new int[]{0, 0, 0, 0};
    private static int rune1 = 0;
    private static int rune2 = 0;
    private static int rune3 = 0;
    private static int rune4 = 0;
    private int amountused1 = 0;
    private int amountused2 = 0;
    private int amountused3 = 0;
    private int amountused4 = 0;
    private boolean noXpCast = false;
    private Farming farming;
    private WorldPoint cannonPosition;
    private boolean cannonPlaced;
    private boolean skipProjectileCheckThisTick;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SuppliesTrackerConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Client client;
    @Inject
    private RuneManager runeManager;
    private int ensouledHeadId = -1;
    @Inject
    public XpDropTracker xpDropTracker;
    @Inject
    public SkillTracker skillTracker;

    static boolean isPotion(String name) {
        return name.endsWith("(4)") || name.endsWith("(3)") || name.endsWith("(2)") || name.endsWith("(1)");
    }

    public static boolean isPizzaPie(String name) {
        return name.toLowerCase().contains("pizza") || name.toLowerCase().contains(" pie");
    }

    public static boolean isCake(String name, int itemId) {
        return name.toLowerCase().contains("cake") || itemId == 1901;
    }

    protected void startUp() {
        this.panel = new SuppliesTrackerPanel(this.itemManager, this);
        this.farming = new Farming(this, this.itemManager);
        BufferedImage header = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel_icon.png");
        this.panel.loadHeaderIcon(header);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel_icon.png");
        this.sessionHandler = new SessionHandler(this.client);
        this.navButton = NavigationButton.builder().tooltip("Supplies Tracker").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.cannonPlaced = false;
        this.cannonPosition = null;
        this.skipProjectileCheckThisTick = false;
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Provides
    SuppliesTrackerConfig provideConfig(ConfigManager configManager) {
        return (SuppliesTrackerConfig)configManager.getConfig(SuppliesTrackerConfig.class);
    }

    @Subscribe
    void onStatChanged(StatChanged event) {
        int oldXp = this.skillTracker.skillXp.getOrDefault(event.getSkill(), 0);
        if (event.getXp() != oldXp) {
            this.onXpDrop(event.getSkill(), event.getXp() - oldXp);
            this.skillTracker.skillXp.put(event.getSkill(), event.getXp());
        }
    }

    private void onXpDrop(Skill skill, int xpDrop) {
        this.xpDropTracker.update(skill, xpDrop);
    }

    @Subscribe
    private void onGameTick(GameTick tick) {
        if (this.mainHandId == 12926 && this.client.getLocalPlayer().getAnimation() == 5061 && this.client.getLocalPlayer().getAnimationFrame() == 0) {
            this.blowpipeShot();
        }
        this.skipProjectileCheckThisTick = false;
        if (this.xpDropTracker.hadXpThisTick(Skill.MAGIC)) {
            this.checkUsedRunePouch();
            this.noXpCast = false;
        } else if (this.noXpCast) {
            this.checkUsedRunePouch();
            this.noXpCast = false;
        }
        this.amountused1 = 0;
        this.amountused2 = 0;
        this.amountused3 = 0;
        this.amountused4 = 0;
    }

    private void blowpipeShot() {
        double ava_percent = this.getAccumulatorPercent();
        if (random.nextDouble() <= ava_percent) {
            this.buildEntries(this.blowpipeDart.dartID);
        }
        if (random.nextDouble() <= 0.6666666666666666) {
            this.buildEntries(12934);
        }
    }

    private double getAccumulatorPercent() {
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment == null || EQUIPMENT_CAPE_SLOT >= equipment.getItems().length) {
            return 1.0;
        }
        int capeID = equipment.getItems()[EQUIPMENT_CAPE_SLOT].getId();
        switch (capeID) {
            case 9756: 
            case 9757: 
            case 13342: {
                return this.config.vorkathsHead() ? 0.2 : 0.28;
            }
            case 21898: 
            case 22109: 
            case 24135: 
            case 24222: 
            case 27363: 
            case 27365: 
            case 27374: 
            case 27376: {
                return 0.2;
            }
            case 10499: 
            case 13337: {
                return 0.28;
            }
            case 10498: {
                return 0.4;
            }
        }
        return 1.0;
    }

    @Subscribe
    private void onVarbitChanged(VarbitChanged event) {
        this.updateRunePouch();
        if (this.attackStyleVarbit != -1 && this.attackStyleVarbit == this.client.getVarpValue(43)) {
            return;
        }
        this.attackStyleVarbit = this.client.getVarpValue(43);
        if (this.attackStyleVarbit == 0 || this.attackStyleVarbit == 3 ? this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getInteracting() instanceof Player : this.attackStyleVarbit != 1 || this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getInteracting() instanceof Player) {
            // empty if block
        }
    }

    private void checkUsedRunes(ItemContainer itemContainer, Item[] oldInv) {
        try {
            for (int i = 0; i < itemContainer.getItems().length; ++i) {
                Item newItem = itemContainer.getItems()[i];
                Item oldItem = oldInv[i];
                if (!runeIds.contains(oldItem.getId()) || newItem.getId() == oldItem.getId() && newItem.getQuantity() == oldItem.getQuantity()) continue;
                int quantity = oldItem.getQuantity();
                if (newItem.getId() == oldItem.getId()) {
                    quantity -= newItem.getQuantity();
                }
                if (quantity <= 0 || quantity >= 35) continue;
                this.buildEntries(oldItem.getId(), quantity);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Subscribe
    private void onAnimationChanged(AnimationChanged animationChanged) {
        if (animationChanged.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        int playerAniId = animationChanged.getActor().getAnimation();
        switch (playerAniId) {
            case 1167: {
                if (this.TRIDENT_OF_THE_SEAS_IDS.contains(this.mainHandId)) {
                    if (this.config.chargesBox()) {
                        this.buildChargesEntries(11907);
                        break;
                    }
                    this.buildEntries(562);
                    this.buildEntries(560);
                    this.buildEntries(554, 5);
                    this.buildEntries(995, 10);
                    break;
                }
                if (this.TRIDENT_OF_THE_SWAMP_IDS.contains(this.mainHandId)) {
                    if (this.config.chargesBox()) {
                        this.buildChargesEntries(12899);
                        break;
                    }
                    this.buildEntries(562);
                    this.buildEntries(560);
                    this.buildEntries(554, 5);
                    this.buildEntries(12934);
                    break;
                }
                if (this.mainHandId == 22323 || this.mainHandId == 25731) {
                    if (this.config.chargesBox()) {
                        this.buildChargesEntries(22323);
                        break;
                    }
                    this.buildEntries(565, 3);
                    break;
                }
                if (this.mainHandId != 22555 && this.mainHandId != 27665 && this.mainHandId != 27679) break;
                if (this.config.chargesBox()) {
                    this.buildChargesEntries(22555);
                    break;
                }
                this.buildEntries(21820, 1);
                break;
            }
            case 708: {
                if (this.IBANS_STAFF_IDS.contains(this.mainHandId) && this.config.chargesBox()) {
                    this.buildChargesEntries(1409);
                }
            }
            case 711: 
            case 727: 
            case 1161: 
            case 1162: 
            case 1165: 
            case 1166: 
            case 1168: 
            case 1169: 
            case 1978: 
            case 1979: 
            case 7855: 
            case 9961: {
                if (this.mainHandId == 22555 || this.mainHandId == 27665 || this.mainHandId == 27679) {
                    if (this.config.chargesBox()) {
                        this.buildChargesEntries(22555);
                    } else {
                        this.buildEntries(21820, 1);
                    }
                }
            }
            case 713: 
            case 1576: 
            case 6294: {
                ItemContainer oldInv = this.client.getItemContainer(InventoryID.INVENTORY);
                if (oldInv != null && this.actionStack.stream().noneMatch(a -> a.getType() == ActionType.CAST)) {
                    ItemMenuAction newAction = new ItemMenuAction(ActionType.CAST, oldInv.getItems());
                    this.actionStack.push(newAction);
                }
                if (this.xpDropTracker.hadXpThisTick(Skill.MAGIC)) break;
                this.noXpCast = true;
                break;
            }
            case 426: 
            case 9964: {
                if (this.mainHandId != 22550 && this.mainHandId != 27655) break;
                if (this.config.chargesBox()) {
                    this.buildChargesEntries(22550);
                    break;
                }
                this.buildEntries(21820, 1);
                break;
            }
            case 245: 
            case 9963: {
                if (this.mainHandId != 22545 && this.mainHandId != 27660) break;
                if (this.config.chargesBox()) {
                    this.buildChargesEntries(22545);
                    break;
                }
                this.buildEntries(21820, 1);
                break;
            }
            case 8056: {
                if (this.mainHandId != 22325 && this.mainHandId != 25736 && this.mainHandId != 25739) break;
                if (this.config.chargesBox()) {
                    this.buildChargesEntries(22325);
                    break;
                }
                this.buildEntries(565, 3);
                this.buildEntries(995, this.itemManager.getItemPrice(22446) / 100);
                break;
            }
            case 9858: {
                if (this.mainHandId != 27610) break;
                this.buildChargesEntries(27610);
                break;
            }
            case 9493: {
                if (!this.TUMEKENS_SHADOW_IDS.contains(this.mainHandId)) break;
                if (this.config.chargesBox()) {
                    this.buildChargesEntries(27275);
                    break;
                }
                this.buildEntries(566, 2);
                this.buildEntries(562, 5);
                break;
            }
            case 386: 
            case 390: {
                if (this.mainHandId != 23995) break;
                this.buildChargesEntries(23995);
                break;
            }
            case 7198: {
                if (this.ensouledHeadId > 0) {
                    this.buildEntries(this.ensouledHeadId);
                }
                this.ensouledHeadId = -1;
            }
        }
    }

    @Subscribe
    private void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        ItemContainer itemContainer = itemContainerChanged.getItemContainer();
        int containerId = itemContainer.getId();
        if (containerId == InventoryID.INVENTORY.getId()) {
            this.loadInvChanges(itemContainer);
            this.xpDropLinkedSupplies();
            this.processInvChange(itemContainer);
        }
        if (containerId == InventoryID.EQUIPMENT.getId()) {
            this.processEquipChange(itemContainer);
        }
    }

    private void xpDropLinkedSupplies() {
        if (this.xpDropTracker.hadXpThisTick(Skill.FISHING)) {
            this.bait.onXpDrop();
        }
        if (this.xpDropTracker.hadXpThisTick(Skill.PRAYER)) {
            for (Map.Entry<Integer, Integer> entry : this.changedItems.entrySet()) {
                int itemId = entry.getKey();
                String itemName = this.itemManager.getItemComposition(itemId).getName().toLowerCase();
                if (!itemName.endsWith(" bones") && !itemName.endsWith("ashes")) continue;
                this.buildEntries(itemId, -entry.getValue().intValue());
            }
        }
    }

    private void loadInvChanges(ItemContainer itemContainer) {
        if (this.itemAmounts == null) {
            this.itemAmounts = new HashMap<Integer, Integer>(37);
            for (Item item : this.client.getItemContainer(InventoryID.INVENTORY).getItems()) {
                if (item.getId() < 0) continue;
                this.itemAmounts.merge(item.getId(), item.getQuantity(), Integer::sum);
            }
            return;
        }
        HashMap<Integer, Integer> newItemAmounts = new HashMap<Integer, Integer>(37);
        this.changedItems.clear();
        for (Item item : itemContainer.getItems()) {
            if (item.getId() < 0) continue;
            newItemAmounts.merge(item.getId(), item.getQuantity(), Integer::sum);
        }
        newItemAmounts.forEach((key, value) -> {
            int dif = value - this.itemAmounts.getOrDefault(key, 0);
            if (dif != 0) {
                this.changedItems.put((Integer)key, dif);
            }
        });
        this.itemAmounts.forEach((key, value) -> {
            int dif;
            if (!newItemAmounts.containsKey(key) && (dif = newItemAmounts.getOrDefault(key, 0) - value) != 0) {
                this.changedItems.put((Integer)key, dif);
            }
        });
        this.itemAmounts = newItemAmounts;
    }

    private void processEquipChange(ItemContainer itemContainer) {
        Item ammoSlot;
        if (itemContainer.getItems().length > EQUIPMENT_MAINHAND_SLOT) {
            Item mainHandItem = itemContainer.getItems()[EQUIPMENT_MAINHAND_SLOT];
            this.mainHandId = mainHandItem.getId();
            if (thrownWeaponIds.contains(this.mainHandId)) {
                if (this.throwingAmmoLoaded) {
                    if (this.thrownId == this.mainHandId) {
                        if (this.thrownAmount - 1 == mainHandItem.getQuantity()) {
                            this.buildEntries(this.mainHandId);
                        }
                    } else {
                        this.thrownId = this.mainHandId;
                    }
                    this.thrownAmount = mainHandItem.getQuantity();
                } else {
                    this.thrownId = this.mainHandId;
                    this.thrownAmount = mainHandItem.getQuantity();
                    this.throwingAmmoLoaded = true;
                }
            } else {
                this.throwingAmmoLoaded = false;
            }
        }
        if (itemContainer.getItems().length > EQUIPMENT_AMMO_SLOT && (ammoSlot = itemContainer.getItems()[EQUIPMENT_AMMO_SLOT]) != null) {
            if (this.ammoLoaded) {
                if (this.ammoId == ammoSlot.getId()) {
                    if (this.ammoAmount - 1 == ammoSlot.getQuantity()) {
                        this.buildEntries(ammoSlot.getId());
                    }
                } else {
                    this.ammoId = ammoSlot.getId();
                }
                this.ammoAmount = ammoSlot.getQuantity();
            } else {
                this.ammoId = ammoSlot.getId();
                this.ammoAmount = ammoSlot.getQuantity();
                this.ammoLoaded = true;
            }
        }
    }

    private void processInvChange(ItemContainer itemContainer) {
        while (!this.actionStack.isEmpty()) {
            ItemMenuAction frame = this.actionStack.pop();
            ActionType type = frame.getType();
            Item[] oldInv = frame.getOldInventory();
            switch (type) {
                case CONSUMABLE: {
                    ItemMenuAction.ItemAction itemFrame = (ItemMenuAction.ItemAction)frame;
                    int nextItem = itemFrame.getItemID();
                    int nextSlot = itemFrame.getSlot();
                    if (itemContainer.getItems()[nextSlot].getId() == oldInv[nextSlot].getId()) break;
                    this.buildEntries(nextItem);
                    break;
                }
                case TELEPORT: {
                    ItemMenuAction.ItemAction itemFrame = (ItemMenuAction.ItemAction)frame;
                    int teleid = itemFrame.getItemID();
                    int slot = itemFrame.getSlot();
                    if (itemContainer.getItems()[slot].getId() == oldInv[slot].getId() && itemContainer.getItems()[slot].getQuantity() == oldInv[slot].getQuantity()) break;
                    this.buildEntries(teleid);
                    break;
                }
                case CAST: {
                    this.checkUsedRunes(itemContainer, oldInv);
                }
            }
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        Item item;
        ItemContainer inv;
        ItemContainer oldInv;
        String target = Text.removeTags((String)event.getMenuTarget()).toLowerCase();
        String menuOption = Text.removeTags((String)event.getMenuOption()).toLowerCase();
        if ((eatPattern.matcher(menuOption).find() || drinkPattern.matcher(menuOption).find()) && this.actionStack.stream().noneMatch(a -> {
            if (a instanceof ItemMenuAction.ItemAction) {
                ItemMenuAction.ItemAction i = (ItemMenuAction.ItemAction)a;
                return i.getItemID() == event.getItemId();
            }
            return false;
        })) {
            oldInv = this.client.getItemContainer(InventoryID.INVENTORY);
            int slot = event.getMenuEntry().getParam0();
            int pushItem = oldInv.getItems()[event.getMenuEntry().getParam0()].getId();
            if (pushItem == 4561 || pushItem == 10476) {
                return;
            }
            ItemMenuAction.ItemAction newAction = new ItemMenuAction.ItemAction(ActionType.CONSUMABLE, oldInv.getItems(), pushItem, slot);
            this.actionStack.push(newAction);
        }
        if ((teleportPattern.matcher(menuOption).find() || teletabPattern.matcher(menuOption).find()) && (oldInv = this.client.getItemContainer(InventoryID.INVENTORY)) != null && this.actionStack.stream().noneMatch(a -> a.getType() == ActionType.TELEPORT)) {
            int teleid = event.getItemId();
            ItemMenuAction.ItemAction newAction = new ItemMenuAction.ItemAction(ActionType.TELEPORT, oldInv.getItems(), teleid, event.getMenuEntry().getParam0());
            this.actionStack.push(newAction);
        }
        if (spellPattern.matcher(menuOption).find() && (oldInv = this.client.getItemContainer(InventoryID.INVENTORY)) != null && this.actionStack.stream().noneMatch(a -> a.getType() == ActionType.CAST)) {
            ItemMenuAction newAction = new ItemMenuAction(ActionType.CAST, oldInv.getItems());
            this.actionStack.push(newAction);
        }
        if (menuOption.equals("use")) {
            if (this.itemManager.getItemComposition(event.getItemId()).getName().toLowerCase().contains("compost")) {
                this.farming.setBucketId(event.getItemId());
            } else if (!target.contains("->")) {
                this.farming.setPlantId(event.getItemId());
            }
        }
        if (target.contains(" reanimation ->") && event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET && (inv = this.client.getItemContainer(InventoryID.INVENTORY)) != null && (item = inv.getItem(event.getParam0())) != null) {
            this.ensouledHeadId = item.getId();
        }
        if (menuOption.equalsIgnoreCase("activate") && target.endsWith(" teleport scroll")) {
            switch (target) {
                case "watson teleport scroll": {
                    this.buildEntries(23387);
                    break;
                }
                case "zul-andra teleport scroll": {
                    this.buildEntries(12938);
                    break;
                }
                case "nardah teleport scroll": {
                    this.buildEntries(12402);
                    break;
                }
                case "digsite teleport scroll": {
                    this.buildEntries(12403);
                    break;
                }
                case "feldip hills teleport scroll": {
                    this.buildEntries(12404);
                    break;
                }
                case "lunar isle teleport scroll": {
                    this.buildEntries(12405);
                    break;
                }
                case "mort'ton teleport scroll": {
                    this.buildEntries(12406);
                    break;
                }
                case "pest control teleport scroll": {
                    this.buildEntries(12407);
                    break;
                }
                case "piscatoris teleport scroll": {
                    this.buildEntries(12408);
                    break;
                }
                case "iorwerth camp teleport scroll": {
                    this.buildEntries(12410);
                    break;
                }
                case "mos le'harmless teleport scroll": {
                    this.buildEntries(12411);
                    break;
                }
                case "lumberyard teleport scroll": {
                    this.buildEntries(12642);
                    break;
                }
                case "revenant cave teleport scroll": {
                    this.buildEntries(21802);
                    break;
                }
                case "tai bwo wannai teleport scroll": {
                    this.buildEntries(12409);
                    break;
                }
                case "key master teleport": {
                    this.buildEntries(13249);
                }
            }
        }
    }

    @Subscribe
    private void onChatMessage(ChatMessage event) {
        String message = event.getMessage();
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (message.toLowerCase().contains("you plant ")) {
            this.farming.onChatPlant(message.toLowerCase());
        } else if (message.toLowerCase().contains("you treat ")) {
            this.farming.setEndlessBucket(message);
            this.farming.onChatTreat(message.toLowerCase());
        } else if (message.toLowerCase().contains("you eat the sweets.")) {
            this.buildEntries(10476);
        } else if (message.toLowerCase().contains("your amulet has") || message.toLowerCase().contains("your amulet's last charge")) {
            this.buildChargesEntries(11978);
        } else if (message.toLowerCase().contains("your ring of dueling has") || message.toLowerCase().contains("your ring of dueling crumbles")) {
            this.buildChargesEntries(2552);
        } else if (message.toLowerCase().contains("your ring of wealth has")) {
            this.buildChargesEntries(11980);
        } else if (message.toLowerCase().contains("your combat bracelet has") || message.toLowerCase().contains("your combat bracelet's last charge")) {
            this.buildChargesEntries(11972);
        } else if (message.toLowerCase().contains("your games necklace has") || message.toLowerCase().contains("your games necklace crumbles")) {
            this.buildChargesEntries(3853);
        } else if (message.toLowerCase().contains("your skills necklace has") || message.toLowerCase().contains("your skills necklace's last charge")) {
            this.buildChargesEntries(11968);
        } else if (message.toLowerCase().contains("your necklace of passage has") || message.toLowerCase().contains("your necklace of passage crumbles")) {
            this.buildChargesEntries(21146);
        } else if (message.toLowerCase().contains("your burning amulet has") || message.toLowerCase().contains("your burning amulet crumbles")) {
            this.buildChargesEntries(21166);
        } else if (message.equals("You add the furnace.")) {
            this.cannonPlaced = true;
        } else if (message.contains("You pick up the cannon") || message.contains("Your cannon has decayed. Speak to Nulodion to get a new one!")) {
            this.cannonPlaced = false;
        } else if (message.startsWith("You unload your cannon and receive Cannonball") || message.startsWith("You unload your cannon and receive Granite cannonball")) {
            this.skipProjectileCheckThisTick = true;
        } else if (message.contains("A magical chest") && message.contains("outside the Theatre of Blood")) {
            this.buildEntries(20802);
        } else if (message.contains("Torfinn has retrieved some of your items.")) {
            this.buildEntries(22308);
        }
        Matcher bpMatcher = bpDartsPattern.matcher(message);
        if (bpMatcher.matches()) {
            String dartName = bpMatcher.group(1);
            this.blowpipeDart = BlowpipeDart.forName(dartName);
        }
    }

    @Subscribe
    private void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        Player localPlayer = this.client.getLocalPlayer();
        if (gameObject.getId() != 7 && gameObject.getId() != 43029 || this.cannonPlaced) {
            return;
        }
        if (localPlayer.getWorldLocation().distanceTo(gameObject.getWorldLocation()) <= 2 && localPlayer.getAnimation() == 827) {
            this.cannonPosition = gameObject.getWorldLocation();
        }
    }

    @Subscribe
    private void onProjectileMoved(ProjectileMoved event) {
        this.cannonball(event);
        this.blowpipeDartCheck(event);
    }

    private void blowpipeDartCheck(ProjectileMoved event) {
        if (this.mainHandId != 12926 || this.client.getLocalPlayer().getAnimation() != 5061) {
            return;
        }
        Projectile projectile = event.getProjectile();
        if (projectile.equals(this.lastBlowpipeProj)) {
            return;
        }
        BlowpipeDart dart = BlowpipeDart.forProjID(projectile.getId());
        if (dart == null) {
            return;
        }
        LocalPoint localPoint = new LocalPoint(projectile.getX1(), projectile.getY1());
        WorldPoint point = WorldPoint.fromLocal((Client)this.client, (LocalPoint)localPoint);
        if (!this.client.getLocalPlayer().getWorldLocation().equals((Object)point)) {
            return;
        }
        for (Player player : this.client.getPlayers()) {
            if (player == this.client.getLocalPlayer() || !player.getWorldLocation().equals((Object)this.client.getLocalPlayer().getWorldLocation()) || player.getPlayerComposition().getEquipmentId(KitType.WEAPON) != 12926 || player.getAnimation() != 5061) continue;
            return;
        }
        this.blowpipeDart = dart;
        this.lastBlowpipeProj = projectile;
    }

    private void cannonball(ProjectileMoved event) {
        boolean graniteCball;
        if (this.cannonPosition == null) {
            return;
        }
        Projectile projectile = event.getProjectile();
        int pId = projectile.getId();
        boolean regCball = pId == 53 || pId == 2018;
        boolean bl = graniteCball = pId == 1443 || pId == 2019;
        if (!regCball && !graniteCball) {
            return;
        }
        WorldPoint projectileLoc = WorldPoint.fromLocal((Client)this.client, (int)projectile.getX1(), (int)projectile.getY1(), (int)this.client.getPlane());
        if (projectileLoc.distanceTo2D(this.cannonPosition) > 1 || projectile.getX() != 0.0 || projectile.getY() != 0.0) {
            return;
        }
        if (!this.skipProjectileCheckThisTick) {
            this.buildEntries(graniteCball ? 21728 : 2);
        }
    }

    private long scalePriceByDoses(String name, int itemId, long price) {
        if (SuppliesTrackerPlugin.isPotion(name)) {
            return price / 4L;
        }
        if (SuppliesTrackerPlugin.isPizzaPie(name)) {
            return price / 2L;
        }
        if (SuppliesTrackerPlugin.isCake(name, itemId)) {
            return price / 3L;
        }
        return price;
    }

    public void buildEntries(int itemId) {
        this.buildEntries(itemId, 1);
    }

    public void buildEntries(int itemId, int count) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        String name = itemComposition.getName();
        if (itemId == 23874) {
            return;
        }
        for (String raidsConsumables : this.RAIDS_CONSUMABLES) {
            if (!name.toLowerCase().contains(raidsConsumables)) continue;
            return;
        }
        if (SuppliesTrackerPlugin.isPotion(name)) {
            name = name.replaceAll(POTION_PATTERN, "(4)");
            itemId = this.getPotionID(name);
        } else if (SuppliesTrackerPlugin.isPizzaPie(name)) {
            itemId = this.getFullVersionItemID(itemId);
            name = this.itemManager.getItemComposition(itemId).getName();
        } else if (SuppliesTrackerPlugin.isCake(name, itemId)) {
            itemId = this.getFullVersionItemID(itemId);
            name = this.itemManager.getItemComposition(itemId).getName();
        }
        int newQuantity = suppliesEntry.containsKey(itemId) ? suppliesEntry.get(itemId).getQuantity() + count : count;
        int newQuantityC = this.currentSuppliesEntry.containsKey(itemId) ? this.currentSuppliesEntry.get(itemId).getQuantity() + count : count;
        long calculatedPrice = this.itemManager.getItemPrice(itemId);
        calculatedPrice = this.scalePriceByDoses(name, itemId, calculatedPrice);
        SuppliesTrackerItem newEntry = new SuppliesTrackerItem(itemId, name, newQuantity, calculatedPrice * (long)newQuantity);
        suppliesEntry.put(itemId, newEntry);
        SuppliesTrackerItem newEntryC = new SuppliesTrackerItem(itemId, name, newQuantityC, calculatedPrice * (long)newQuantityC);
        if (!this.sessionLoading) {
            this.sessionHandler.addToSession(itemId, count, false);
            this.currentSuppliesEntry.put(itemId, newEntryC);
        }
        SwingUtilities.invokeLater(() -> this.panel.addItem(this.showSession ? newEntryC : newEntry));
    }

    private void buildChargesEntries(int itemId) {
        this.buildChargesEntries(itemId, 1);
    }

    private void buildChargesEntries(int itemId, int count) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        String name = itemComposition.getName();
        long calculatedPrice = 0L;
        int newQuantity = suppliesEntry.containsKey(itemId) ? suppliesEntry.get(itemId).getQuantity() + count : count;
        int newQuantityC = this.currentSuppliesEntry.containsKey(itemId) ? this.currentSuppliesEntry.get(itemId).getQuantity() + count : count;
        switch (itemId) {
            case 11978: {
                calculatedPrice = (this.itemManager.getItemPrice(11978) - this.itemManager.getItemPrice(1704)) / 6;
                break;
            }
            case 2552: {
                calculatedPrice = this.itemManager.getItemPrice(2552) / 8;
                break;
            }
            case 11980: {
                calculatedPrice = (this.itemManager.getItemPrice(11980) - this.itemManager.getItemPrice(2572)) / 5;
                break;
            }
            case 11972: {
                calculatedPrice = (this.itemManager.getItemPrice(11972) - this.itemManager.getItemPrice(11126)) / 6;
                break;
            }
            case 3853: {
                calculatedPrice = this.itemManager.getItemPrice(3853) / 8;
                break;
            }
            case 11968: {
                calculatedPrice = (this.itemManager.getItemPrice(11968) - this.itemManager.getItemPrice(11113)) / 6;
                break;
            }
            case 21146: {
                calculatedPrice = this.itemManager.getItemPrice(21146) / 5;
                break;
            }
            case 21166: {
                calculatedPrice = this.itemManager.getItemPrice(21166) / 5;
                break;
            }
            case 22325: {
                calculatedPrice = (long)this.itemManager.getItemPrice(565) * 3L + (long)(this.itemManager.getItemPrice(22446) / 100);
                break;
            }
            case 27610: {
                calculatedPrice = this.itemManager.getItemPrice(27616);
                break;
            }
            case 27275: {
                calculatedPrice = (long)this.itemManager.getItemPrice(566) * 2L + (long)this.itemManager.getItemPrice(562) * 5L;
                break;
            }
            case 12899: {
                calculatedPrice = (long)(this.itemManager.getItemPrice(562) + this.itemManager.getItemPrice(560)) + (long)this.itemManager.getItemPrice(554) * 5L + (long)this.itemManager.getItemPrice(12934);
                break;
            }
            case 11907: {
                calculatedPrice = (long)(this.itemManager.getItemPrice(562) + this.itemManager.getItemPrice(560)) + (long)this.itemManager.getItemPrice(554) * 5L + (long)this.itemManager.getItemPrice(995) * 10L;
                break;
            }
            case 22323: {
                calculatedPrice = (long)this.itemManager.getItemPrice(565) * 3L;
                break;
            }
            case 1409: {
                calculatedPrice = (long)this.itemManager.getItemPrice(560) + (long)this.itemManager.getItemPrice(554) * 5L;
                break;
            }
            case 23995: {
                calculatedPrice = 0L;
                break;
            }
            case 22545: 
            case 22550: 
            case 22555: {
                calculatedPrice = this.itemManager.getItemPrice(21820);
            }
        }
        SuppliesTrackerItem newEntry = new SuppliesTrackerItem(itemId, name, newQuantity, calculatedPrice * (long)newQuantity);
        suppliesEntry.put(itemId, newEntry);
        SuppliesTrackerItem newEntryC = new SuppliesTrackerItem(itemId, name, newQuantityC, calculatedPrice * (long)newQuantityC);
        if (!this.sessionLoading) {
            this.sessionHandler.addToSession(itemId, count, true);
            this.currentSuppliesEntry.put(itemId, newEntryC);
        }
        SwingUtilities.invokeLater(() -> this.panel.addItem(this.showSession ? newEntryC : newEntry));
    }

    public void clearSupplies() {
        suppliesEntry.clear();
        this.currentSuppliesEntry.clear();
        this.sessionHandler.clearSupplies();
    }

    public void clearItem(int itemId) {
        suppliesEntry.remove(itemId);
        this.currentSuppliesEntry.remove(itemId);
        this.sessionHandler.clearItem(itemId);
    }

    public void removeOneItem(int itemId) {
        if (!suppliesEntry.containsKey(itemId)) {
            return;
        }
        if (suppliesEntry.get(itemId).getQuantity() == 1) {
            this.clearItem(itemId);
        } else {
            suppliesEntry.get(itemId).setQuantity(suppliesEntry.get(itemId).getQuantity() - 1);
        }
    }

    public int getPotionID(String name) {
        int itemId = 0;
        List items = this.itemManager.search(name);
        for (ItemPrice item : items) {
            if (!item.getName().contains(name)) continue;
            itemId = item.getId();
        }
        return itemId;
    }

    private int getFullVersionItemID(int itemId) {
        switch (itemId) {
            case 2299: {
                itemId = 2297;
                break;
            }
            case 2295: {
                itemId = 2293;
                break;
            }
            case 2303: {
                itemId = 2301;
                break;
            }
            case 2291: {
                itemId = 2289;
                break;
            }
            case 2333: {
                itemId = 2325;
                break;
            }
            case 7180: {
                itemId = 7178;
                break;
            }
            case 7220: {
                itemId = 7218;
                break;
            }
            case 7190: {
                itemId = 7188;
                break;
            }
            case 19659: {
                itemId = 19662;
                break;
            }
            case 21687: {
                itemId = 21690;
                break;
            }
            case 7200: {
                itemId = 7198;
                break;
            }
            case 7210: {
                itemId = 7208;
                break;
            }
            case 2335: {
                itemId = 2323;
                break;
            }
            case 2331: {
                itemId = 2327;
                break;
            }
            case 1893: 
            case 1895: {
                itemId = 1891;
                break;
            }
            case 1899: 
            case 1901: {
                itemId = 1897;
            }
        }
        return itemId;
    }

    private void checkUsedRunePouch() {
        if (!this.xpDropTracker.hadXpThisTick(Skill.MAGIC) && !this.noXpCast) {
            return;
        }
        if (this.amountused1 != 0 && this.amountused1 < 20) {
            this.buildEntries(Runes.getRune(rune1).getItemId(), this.amountused1);
        }
        if (this.amountused2 != 0 && this.amountused2 < 20) {
            this.buildEntries(Runes.getRune(rune2).getItemId(), this.amountused2);
        }
        if (this.amountused3 != 0 && this.amountused3 < 20) {
            this.buildEntries(Runes.getRune(rune3).getItemId(), this.amountused3);
        }
        if (this.amountused4 != 0 && this.amountused4 < 20) {
            this.buildEntries(Runes.getRune(rune4).getItemId(), this.amountused4);
        }
    }

    private void updateRunePouch() {
        if (OLD_AMOUNT_VARBITS[0] != this.client.getVarbitValue(AMOUNT_VARBITS[0])) {
            if (OLD_AMOUNT_VARBITS[0] > this.client.getVarbitValue(AMOUNT_VARBITS[0])) {
                this.amountused1 += OLD_AMOUNT_VARBITS[0] - this.client.getVarbitValue(AMOUNT_VARBITS[0]);
            }
            SuppliesTrackerPlugin.OLD_AMOUNT_VARBITS[0] = this.client.getVarbitValue(AMOUNT_VARBITS[0]);
        }
        if (OLD_AMOUNT_VARBITS[1] != this.client.getVarbitValue(AMOUNT_VARBITS[1])) {
            if (OLD_AMOUNT_VARBITS[1] > this.client.getVarbitValue(AMOUNT_VARBITS[1])) {
                this.amountused2 += OLD_AMOUNT_VARBITS[1] - this.client.getVarbitValue(AMOUNT_VARBITS[1]);
            }
            SuppliesTrackerPlugin.OLD_AMOUNT_VARBITS[1] = this.client.getVarbitValue(AMOUNT_VARBITS[1]);
        }
        if (OLD_AMOUNT_VARBITS[2] != this.client.getVarbitValue(AMOUNT_VARBITS[2])) {
            if (OLD_AMOUNT_VARBITS[2] > this.client.getVarbitValue(AMOUNT_VARBITS[2])) {
                this.amountused3 += OLD_AMOUNT_VARBITS[2] - this.client.getVarbitValue(AMOUNT_VARBITS[2]);
            }
            SuppliesTrackerPlugin.OLD_AMOUNT_VARBITS[2] = this.client.getVarbitValue(AMOUNT_VARBITS[2]);
        }
        if (OLD_AMOUNT_VARBITS[3] != this.client.getVarbitValue(AMOUNT_VARBITS[3])) {
            if (OLD_AMOUNT_VARBITS[3] > this.client.getVarbitValue(AMOUNT_VARBITS[3])) {
                this.amountused4 += OLD_AMOUNT_VARBITS[3] - this.client.getVarbitValue(AMOUNT_VARBITS[3]);
            }
            SuppliesTrackerPlugin.OLD_AMOUNT_VARBITS[3] = this.client.getVarbitValue(AMOUNT_VARBITS[3]);
        }
        if (OLD_RUNE_VARBITS[0] != this.client.getVarbitValue(RUNE_VARBITS[0])) {
            rune1 = this.client.getVarbitValue(RUNE_VARBITS[0]);
            SuppliesTrackerPlugin.OLD_RUNE_VARBITS[0] = this.client.getVarbitValue(RUNE_VARBITS[0]);
        }
        if (OLD_RUNE_VARBITS[1] != this.client.getVarbitValue(RUNE_VARBITS[1])) {
            rune2 = this.client.getVarbitValue(RUNE_VARBITS[1]);
            SuppliesTrackerPlugin.OLD_RUNE_VARBITS[1] = this.client.getVarbitValue(RUNE_VARBITS[1]);
        }
        if (OLD_RUNE_VARBITS[2] != this.client.getVarbitValue(RUNE_VARBITS[2])) {
            rune3 = this.client.getVarbitValue(RUNE_VARBITS[2]);
            SuppliesTrackerPlugin.OLD_RUNE_VARBITS[2] = this.client.getVarbitValue(RUNE_VARBITS[2]);
        }
        if (OLD_RUNE_VARBITS[3] != this.client.getVarbitValue(RUNE_VARBITS[3])) {
            rune4 = this.client.getVarbitValue(RUNE_VARBITS[3]);
            SuppliesTrackerPlugin.OLD_RUNE_VARBITS[3] = this.client.getVarbitValue(RUNE_VARBITS[3]);
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN || this.client.getAccountHash() == this.sessionHash) {
            return;
        }
        this.skillTracker.loadAll(this.client);
        this.sessionHash = this.client.getAccountHash();
        suppliesEntry.clear();
        this.currentSuppliesEntry.clear();
        SwingUtilities.invokeLater(() -> this.panel.resetAll());
        this.sessionHandler.clearSession();
        try {
            File sessionFile = new File(RuneLite.RUNELITE_DIR + "/supplies-tracker/" + this.client.getAccountHash() + ".txt");
            if (sessionFile.createNewFile()) {
                return;
            }
            this.sessionLoading = true;
            List<String> savedSupplies = Files.readAllLines(sessionFile.toPath());
            for (String supplies : savedSupplies) {
                if (!supplies.contains(":")) continue;
                String[] temp = supplies.split(":");
                if (temp[0].contains("c")) {
                    this.buildChargesEntries(Integer.parseInt(temp[0].replace("c", "")), Integer.parseInt(temp[1]));
                    this.sessionHandler.setupMaps(Integer.parseInt(temp[0].replace("c", "")), Integer.parseInt(temp[1]), true);
                    continue;
                }
                this.buildEntries(Integer.parseInt(temp[0]), Integer.parseInt(temp[1]));
                this.sessionHandler.setupMaps(Integer.parseInt(temp[0]), Integer.parseInt(temp[1]), false);
            }
            this.sessionLoading = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void switchTracking() {
        SwingUtilities.invokeLater(() -> this.panel.resetAll());
        this.showSession = !this.showSession;
        Map<Integer, SuppliesTrackerItem> map = this.showSession ? this.currentSuppliesEntry : suppliesEntry;
        for (SuppliesTrackerItem item : map.values()) {
            SwingUtilities.invokeLater(() -> this.panel.addItem(item));
        }
    }

    public SuppliesTrackerConfig getConfig() {
        return this.config;
    }
}

