/*
 * Decompiled with CFR 0.152.
 */
package com.suppliestracker.Skills;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Skill;

@Singleton
public class XpDropTracker {
    @Inject
    private Client client;
    private static final Map<Skill, XpDrop> skillToLastXpDrop = new HashMap<Skill, XpDrop>();

    public XpDrop lastXpDrop(Skill skill) {
        return skillToLastXpDrop.getOrDefault(skill, XpDrop.NONE);
    }

    public void update(Skill skill, int xpDrop) {
        skillToLastXpDrop.put(skill, new XpDrop(this.client.getTickCount(), xpDrop));
    }

    public boolean hadXpThisTick(Skill skill) {
        return this.lastXpDrop((Skill)skill).tick == this.client.getTickCount();
    }

    static class XpDrop {
        public final int tick;
        public final int xpDrop;
        public static final XpDrop NONE = new XpDrop(-1, 0);

        public XpDrop(int tick, int xpDrop) {
            this.tick = tick;
            this.xpDrop = xpDrop;
        }
    }
}

