/*
 * Decompiled with CFR 0.152.
 */
package com.suppliestracker.Skills;

import com.google.common.collect.ImmutableSet;
import com.suppliestracker.SuppliesTrackerPlugin;
import java.util.Set;
import javax.inject.Singleton;
import net.runelite.client.game.ItemManager;

@Singleton
public class Farming {
    private final SuppliesTrackerPlugin plugin;
    private final ItemManager itemManager;
    private int plantId = 0;
    private int compostId = 0;
    private int bucketId = 0;
    private final Set<Integer> ALLOTMENT_SEEDS = ImmutableSet.of((Object)5318, (Object)5319, (Object)5324, (Object)5322, (Object)5320, (Object)5323, (Object[])new Integer[]{5321, 22879});

    public Farming(SuppliesTrackerPlugin plugin, ItemManager itemManager) {
        this.plugin = plugin;
        this.itemManager = itemManager;
    }

    public void onChatPlant(String message) {
        if (this.plantId <= 0) {
            return;
        }
        String name = this.itemManager.getItemComposition(this.plantId).getName().toLowerCase();
        if (name.contains(" seed") || name.contains(" sapling") || name.contains(" spore")) {
            if (this.ALLOTMENT_SEEDS.contains(this.plantId)) {
                this.plugin.buildEntries(this.plantId, 3);
                return;
            }
            this.plugin.buildEntries(this.plantId);
        }
    }

    public void onChatTreat(String message) {
        if (this.bucketId <= 0) {
            return;
        }
        String name = this.itemManager.getItemComposition(this.bucketId).getName().toLowerCase();
        if (name.contains("compost") || name.contains("plant cure")) {
            if (this.bucketId == 22994 || this.bucketId == 22997) {
                this.plugin.buildEntries(this.compostId);
            } else {
                this.plugin.buildEntries(this.bucketId);
            }
        }
    }

    public void setPlantId(int plantId) {
        this.plantId = plantId;
    }

    public void setBucketId(int bucketId) {
        this.bucketId = bucketId;
    }

    public void setEndlessBucket(String message) {
        this.compostId = message.toLowerCase().contains("ultracompost") ? 21483 : (message.toLowerCase().contains("supercompost") ? 6034 : 6032);
    }
}

