/*
 * Decompiled with CFR 0.152.
 */
package com.suppliestracker;

import com.suppliestracker.Bait;
import com.suppliestracker.SuppliesTrackerItem;
import com.suppliestracker.SuppliesTrackerPlugin;

public enum ItemType {
    FOOD("Food"),
    POTION("Potions"),
    RUNE("Runes"),
    AMMO("Ammo"),
    TELEPORT("Teleports"),
    COINS("Coins"),
    JEWELLERY("Jewellery"),
    CHARGES("Charges"),
    FARMING("Farming"),
    DEATH("Deaths"),
    PRAYER("Prayer"),
    BAIT("Bait");

    private String label;

    public static ItemType categorize(SuppliesTrackerItem item) {
        String name = item.getName().toLowerCase();
        int itemId = item.getId();
        if (name.endsWith("(4)")) {
            return POTION;
        }
        if (name.contains("bones") && !name.contains(" to ") || name.startsWith("ensouled") || name.endsWith(" ashes")) {
            return PRAYER;
        }
        if (name.contains("bolt") || name.contains("dart") || name.contains(" arrow") || name.contains("javelin") || name.contains("knive") || name.contains("throwing") || name.contains("zulrah's scale") || name.contains("cannonball") || name.contains("knife") || name.contains("chinchompa") || name.endsWith(" brutal") || name.contains("thrownaxe") || item.getId() == 21820) {
            return AMMO;
        }
        if (SuppliesTrackerPlugin.runeIds.contains(itemId)) {
            return RUNE;
        }
        if (name.contains("teleport") || itemId == 22601 || itemId == 22599) {
            return TELEPORT;
        }
        if (item.getId() == 995) {
            return COINS;
        }
        if (name.contains("ring of") || name.contains("amulet") || name.contains("bracelet") || name.contains("necklace")) {
            return JEWELLERY;
        }
        if (name.contains(" sapling") || name.contains(" seed") || name.contains("compost") || name.contains("plant cure") || name.contains(" spore")) {
            return FARMING;
        }
        if (item.getId() == 22325 || item.getId() == 22323 || item.getId() == 11907 || item.getId() == 12899 || item.getId() == 23995 || item.getId() == 1409 || item.getId() == 27275 || item.getId() == 27610 || item.getId() == 27616 || item.getId() == 22555 || item.getId() == 22550 || item.getId() == 22545 || item.getId() == 27665 || item.getId() == 27655 || item.getId() == 27660 || item.getId() == 27679) {
            return CHARGES;
        }
        if (item.getId() == 20802 || item.getId() == 22308) {
            return DEATH;
        }
        if (Bait.isBait(item.getId())) {
            return BAIT;
        }
        return FOOD;
    }

    private ItemType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }
}

