/*
 * Decompiled with CFR 0.152.
 */
package com.handegg;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import com.handegg.DiscordWebhookBody;
import com.handegg.HandeggDiscordWebhookConfig;
import com.handegg.HandeggState;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Handegg Discord Webhook")
public class HandeggDiscordWebhookPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HandeggDiscordWebhookPlugin.class);
    public static int HOLY_HANDEGG_THROWN_ANIMATIONID = 7994;
    public static int PEACEFUL_HANDEGG_THROWN_ANIMATIONID = 7995;
    public static int CHAOTIC_HANDEGG_THROWN_ANIMATIONID = 7996;
    public static int HANDEGG_RECEIVED_ANIMATIONID = 782;
    public static HandeggState state = HandeggState.IDLE;
    private static int currentGameTick = 0;
    private static int lastStateChanged;
    private static String lastThrower;
    private static String lastReciever;
    private static String currentPlayer;
    @Inject
    private Client client;
    @Inject
    private HandeggDiscordWebhookConfig config;
    @Inject
    private DrawManager drawManager;
    @Inject
    private OkHttpClient okHttpClient;

    @Provides
    HandeggDiscordWebhookConfig provideConfig(ConfigManager configManager) {
        return (HandeggDiscordWebhookConfig)configManager.getConfig(HandeggDiscordWebhookConfig.class);
    }

    private void updateState(HandeggState newState) {
        state = newState;
        lastStateChanged = currentGameTick;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        int changedAnimationID = animationChanged.getActor().getAnimation();
        if (changedAnimationID == -1) {
            return;
        }
        if (currentPlayer == null) {
            Player currentPlayerFromClient = this.client.getLocalPlayer();
            if (currentPlayerFromClient == null) {
                return;
            }
            String currentPlayerName = currentPlayerFromClient.getName();
            if (currentPlayerName == null) {
                return;
            }
            currentPlayer = currentPlayerName;
        }
        String actorName = animationChanged.getActor().getName();
        if (changedAnimationID == HOLY_HANDEGG_THROWN_ANIMATIONID || changedAnimationID == PEACEFUL_HANDEGG_THROWN_ANIMATIONID || changedAnimationID == CHAOTIC_HANDEGG_THROWN_ANIMATIONID) {
            if (currentPlayer.equals(actorName)) {
                this.updateState(HandeggState.THROWN);
            } else {
                lastThrower = actorName;
            }
        } else if (changedAnimationID == HANDEGG_RECEIVED_ANIMATIONID) {
            if (currentPlayer.equals(actorName)) {
                this.updateState(HandeggState.RECEIVED);
            } else {
                lastReciever = actorName;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (state != HandeggState.IDLE && lastStateChanged + 3 < ++currentGameTick) {
            String message;
            if (state == HandeggState.RECEIVED) {
                message = currentPlayer + " just got handegged by " + lastThrower + "!";
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You just got handegged by " + lastThrower + "!", null);
                log.info(message);
                if (this.config.uploadOnReceive()) {
                    this.sendWebhook(message);
                }
            }
            if (state == HandeggState.THROWN) {
                message = currentPlayer + " just handegged " + lastReciever + "!";
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You just handegged " + lastReciever + "!", null);
                log.info(message);
                if (this.config.uploadOnThrow()) {
                    this.sendWebhook(message);
                }
            }
            this.updateState(HandeggState.IDLE);
        }
    }

    private void sendWebhook(String message) {
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(message);
        this.sendWebhook(discordWebhookBody, this.config.includeScreenshot());
    }

    private void sendWebhook(DiscordWebhookBody discordWebhookBody, boolean sendScreenshot) {
        String configUrl = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        List webhookUrls = Arrays.asList(configUrl.split("\n")).stream().filter(u -> u.length() > 0).map(u -> u.trim()).collect(Collectors.toList());
        for (String webhookUrl : webhookUrls) {
            HttpUrl url = HttpUrl.parse((String)webhookUrl);
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
            if (sendScreenshot) {
                this.sendWebhookWithScreenshot(url, requestBodyBuilder);
                continue;
            }
            this.buildRequestAndSend(url, requestBodyBuilder);
        }
    }

    private void sendWebhookWithScreenshot(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = HandeggDiscordWebhookPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    static {
        lastThrower = "";
        lastReciever = "";
    }
}

