/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.templetrekking;

import com.andmcadams.templetrekking.TempleTrekkingOverlayPanel;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Temple Trekking")
public class TempleTrekkingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TempleTrekkingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TempleTrekkingOverlayPanel overlayPanel;
    private int currentPoints;
    private int lastPoints;
    private static final int TEMPLE_TREKKING_POINTS = 1955;

    protected void startUp() throws Exception {
        log.info("Temple Trekking started!");
        this.currentPoints = 0;
        this.lastPoints = 0;
        this.overlayManager.add((Overlay)this.overlayPanel);
    }

    protected void shutDown() throws Exception {
        log.info("Temple Trekking stopped!");
        this.overlayManager.remove((Overlay)this.overlayPanel);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int tempPoints = this.client.getVarbitValue(1955);
        if (tempPoints == 0 && this.currentPoints != 0) {
            this.lastPoints = this.currentPoints;
        }
        this.currentPoints = tempPoints;
    }

    public int getCurrentPoints() {
        return this.currentPoints;
    }

    public int getLastPoints() {
        return this.lastPoints;
    }
}

