/*
 * Decompiled with CFR 0.152.
 */
package com.konarreminder;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import com.konarreminder.KonarReminderConfig;
import java.awt.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Renderable;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.Hooks;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Konar Milestone Reminder")
public class KonarReminderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(KonarReminderPlugin.class);
    private static final int MAX_ACTOR_VIEW_RANGE = 15;
    @Inject
    private Client client;
    @Inject
    private KonarReminderConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private NpcOverlayService npcOverlayService;
    @Inject
    private Hooks hooks;
    private boolean hideOtherSlayerMasters;
    private final Map<NPC, HighlightedNpc> highlightedNpcs = new HashMap<NPC, HighlightedNpc>();
    private Instant lastTickUpdate;
    private List<String> highlights = new ArrayList<String>();
    private WorldPoint lastPlayerLocation;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    private final Function<NPC, HighlightedNpc> isHighlighted = this.highlightedNpcs::get;

    protected void startUp() throws Exception {
        this.npcOverlayService.registerHighlighter(this.isHighlighted);
        this.hooks.registerRenderableDrawListener(this.drawListener);
        this.updateConfig();
        this.clientThread.invoke(() -> this.rebuild());
        log.info("Konar Milestone Reminder started!");
    }

    protected void shutDown() throws Exception {
        this.npcOverlayService.unregisterHighlighter(this.isHighlighted);
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        this.clientThread.invoke(() -> this.highlightedNpcs.clear());
        log.info("Konar Milestone Reminder stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.highlightedNpcs.clear();
            this.lastPlayerLocation = null;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("konarreminder")) {
            return;
        }
        this.updateConfig();
        this.clientThread.invoke(this::rebuild);
    }

    private void updateConfig() {
        this.hideOtherSlayerMasters = this.config.hideOtherSlayerMasters();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (this.highlightMatchesNPCName(npcName)) {
            this.highlightedNpcs.put(npc, this.highlightedNpc(npc));
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.highlightedNpcs.remove(npc);
    }

    @Subscribe
    public void onNpcChanged(NpcChanged event) {
        NPC npc = event.getNpc();
        String npcName = npc.getName();
        this.highlightedNpcs.remove(npc);
        if (npcName == null) {
            return;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.lastTickUpdate = Instant.now();
        this.lastPlayerLocation = this.client.getLocalPlayer().getWorldLocation();
    }

    private void updateNpcsToHighlight(String npc) {
        ArrayList<String> highlightedNpcs = new ArrayList<String>(this.highlights);
        if (!highlightedNpcs.removeIf(npc::equalsIgnoreCase)) {
            highlightedNpcs.add(npc);
        }
        this.config.setNpcToHighlight(Text.toCSV(highlightedNpcs));
    }

    private static boolean isInViewRange(WorldPoint wp1, WorldPoint wp2) {
        int distance = wp1.distanceTo(wp2);
        return distance < 15;
    }

    private static WorldPoint getWorldLocationBehind(NPC npc) {
        int orientation = npc.getOrientation() / 256;
        int dx = 0;
        int dy = 0;
        switch (orientation) {
            case 0: {
                dy = -1;
                break;
            }
            case 1: {
                dx = -1;
                dy = -1;
                break;
            }
            case 2: {
                dx = -1;
                break;
            }
            case 3: {
                dx = -1;
                dy = 1;
                break;
            }
            case 4: {
                dy = 1;
                break;
            }
            case 5: {
                dx = 1;
                dy = 1;
                break;
            }
            case 6: {
                dx = 1;
                break;
            }
            case 7: {
                dx = 1;
                dy = -1;
            }
        }
        WorldPoint currWP = npc.getWorldLocation();
        return new WorldPoint(currWP.getX() - dx, currWP.getY() - dy, currWP.getPlane());
    }

    @VisibleForTesting
    List<String> getHighlights() {
        String configNpcs = this.config.getNpcToHighlight();
        if (configNpcs.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configNpcs);
    }

    void rebuild() {
        this.highlights = this.getHighlights();
        this.highlightedNpcs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (npcName == null || !this.highlightMatchesNPCName(npcName)) continue;
            this.highlightedNpcs.put(npc, this.highlightedNpc(npc));
        }
        this.npcOverlayService.rebuild();
    }

    private boolean highlightMatchesNPCName(String npcName) {
        for (String highlight : this.highlights) {
            if (!WildcardMatcher.matches((String)highlight, (String)npcName)) continue;
            return true;
        }
        return false;
    }

    private HighlightedNpc highlightedNpc(NPC npc) {
        if (this.config.otherHighlight() && this.config.getReminderStatus()) {
            return HighlightedNpc.builder().npc(npc).highlightColor(this.config.highlightColor()).fillColor(this.config.fillColor()).hull(this.config.highlightHull()).tile(this.config.highlightTile()).outline(this.config.highlightOutline()).borderWidth((float)this.config.borderWidth()).outlineFeather(this.config.outlineFeather()).build();
        }
        return null;
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        Pattern streakPattern;
        Matcher messageMatcher;
        String message = chatMessage.getMessage();
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE && (messageMatcher = (streakPattern = Pattern.compile("\\d+ tasks")).matcher(message)).find()) {
            int streak = Integer.parseInt(messageMatcher.group().replaceAll("\\D", ""));
            if ((streak + 1) % this.config.multiple() == 0) {
                this.config.setReminderStatus(true);
                String reminderMessage = ColorUtil.wrapWithColorTag((String)"You should visit Konar to get bonus points for your next task.", (Color)this.config.chatMessageColor());
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", reminderMessage, null);
            } else {
                this.config.setReminderStatus(false);
            }
            this.updateConfig();
            this.rebuild();
        }
    }

    @Provides
    KonarReminderConfig provideConfig(ConfigManager configManager) {
        return (KonarReminderConfig)configManager.getConfig(KonarReminderConfig.class);
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        NPC npc;
        if (renderable instanceof NPC && this.highlightMatchesNPCName((npc = (NPC)renderable).getName()) && this.config.getReminderStatus()) {
            return !this.hideOtherSlayerMasters;
        }
        return true;
    }

    Map<NPC, HighlightedNpc> getHighlightedNpcs() {
        return this.highlightedNpcs;
    }

    Instant getLastTickUpdate() {
        return this.lastTickUpdate;
    }
}

