/*
 * Decompiled with CFR 0.152.
 */
package io.mark.hdminimap;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Rasterizer;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.events.BeforeRender;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;

@PluginDescriptor(name="HD Minimap", description="Adds a HD Minimap from 2008!", tags={"hd", "minimap"})
public class HDMinimapPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private PluginManager pluginManager;
    private final int[] tmpScreenX = new int[6];
    private final int[] tmpScreenY = new int[6];

    protected void startUp() {
        this.client.setMinimapTileDrawer(this::drawTile);
    }

    static int blend(int var0, int var1) {
        var1 = (var0 & 0x7F) * var1 >> 7;
        var1 = Math.max(2, var1);
        var1 = Math.min(126, var1);
        return (var0 & 0xFF80) + var1;
    }

    @Subscribe
    public void onBeforeRender(BeforeRender beforeRender) {
        this.client.setMinimapTileDrawer(this::drawTile);
    }

    public void shutDown() {
        this.client.setMinimapTileDrawer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTile(Tile tile, int tx, int ty, int px0, int py0, int px1, int py1) {
        this.client.getRasterizer().setRasterGouraudLowRes(false);
        try {
            SceneTilePaint paint = tile.getSceneTilePaint();
            if (paint != null) {
                int tex = paint.getTexture();
                if (tex == -1) {
                    int nw = paint.getNwColor();
                    if (nw != 12345678) {
                        this.fillGradient(px0, py0, px1, py1, nw, paint.getNeColor(), paint.getSwColor(), paint.getSeColor());
                    } else {
                        this.client.getRasterizer().fillRectangle(px0, py0, px1 - px0, py1 - py0, paint.getRBG());
                    }
                } else {
                    int hsl = this.client.getTextureProvider().getDefaultColor(tex);
                    this.fillGradient(px0, py0, px1, py1, HDMinimapPlugin.blend(hsl, paint.getNwColor()), HDMinimapPlugin.blend(hsl, paint.getNeColor()), HDMinimapPlugin.blend(hsl, paint.getSwColor()), HDMinimapPlugin.blend(hsl, paint.getSeColor()));
                }
                return;
            }
            SceneTileModel stm = tile.getSceneTileModel();
            if (stm == null) {
                return;
            }
            int[] vertexX = stm.getVertexX();
            int[] vertexZ = stm.getVertexZ();
            int[] indicies1 = stm.getFaceX();
            int[] indicies2 = stm.getFaceY();
            int[] indicies3 = stm.getFaceZ();
            int[] color1 = stm.getTriangleColorA();
            int[] color2 = stm.getTriangleColorB();
            int[] color3 = stm.getTriangleColorC();
            int[] textures = stm.getTriangleTextureId();
            int localX = tx << 7;
            int localY = ty << 7;
            int w = px1 - px0;
            int h = py1 - py0;
            for (int vert = 0; vert < vertexX.length; ++vert) {
                this.tmpScreenX[vert] = px0 + ((vertexX[vert] - localX) * w >> 7);
                this.tmpScreenY[vert] = py0 + ((128 - (vertexZ[vert] - localY)) * h >> 7);
            }
            for (int face = 0; face < indicies1.length; ++face) {
                int idx1 = indicies1[face];
                int idx2 = indicies2[face];
                int idx3 = indicies3[face];
                int c1 = color1[face];
                int c2 = color2[face];
                int c3 = color3[face];
                if (textures != null && textures[face] != -1) {
                    int hsl = this.client.getTextureProvider().getDefaultColor(textures[face]);
                    this.client.getRasterizer().rasterGouraud(this.tmpScreenY[idx1], this.tmpScreenY[idx2], this.tmpScreenY[idx3], this.tmpScreenX[idx1], this.tmpScreenX[idx2], this.tmpScreenX[idx3], HDMinimapPlugin.blend(hsl, c1), HDMinimapPlugin.blend(hsl, c2), HDMinimapPlugin.blend(hsl, c3));
                    continue;
                }
                if (c1 == 12345678) continue;
                this.client.getRasterizer().rasterGouraud(this.tmpScreenY[idx1], this.tmpScreenY[idx2], this.tmpScreenY[idx3], this.tmpScreenX[idx1], this.tmpScreenX[idx2], this.tmpScreenX[idx3], c1, c2, c3);
            }
        }
        finally {
            this.client.getRasterizer().setRasterGouraudLowRes(true);
        }
    }

    private void fillGradient(int px0, int py0, int px1, int py1, int c00, int c10, int c01, int c11) {
        Rasterizer g3d = this.client.getRasterizer();
        g3d.rasterGouraud(py0, py0, py1, px0, px1, px0, c00, c10, c01);
        g3d.rasterGouraud(py0, py1, py1, px1, px0, px1, c10, c01, c11);
    }
}

