/*
 * Decompiled with CFR 0.152.
 */
package alexsuperfly.forcerecolor;

import alexsuperfly.forcerecolor.ForceRecolorConfig;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Force Recolor")
public class ForceRecolorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ForceRecolorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ForceRecolorConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ConfigManager configManager;
    private static final Pattern TAG_REGEXP_SANS_LT_GT = Pattern.compile("<(?!lt>|gt>)[^>]*>");
    private int transparencyVarbit = -1;
    private final Map<Integer, String> textGroupStrings = new HashMap<Integer, String>();
    private final Map<Integer, Pattern> matchGroupPatterns = new HashMap<Integer, Pattern>();
    private final Map<Integer, String> colorGroupStrings = new HashMap<Integer, String>();

    @Provides
    ForceRecolorConfig provideConfig(ConfigManager configManager) {
        return (ForceRecolorConfig)configManager.getConfig(ForceRecolorConfig.class);
    }

    protected void startUp() throws Exception {
        this.updateMatchingText();
        this.updateRecolorColor();
    }

    private void updateMatchingText() {
        this.textGroupStrings.clear();
        this.matchGroupPatterns.clear();
        if (!this.config.matchedTextString().trim().equals("")) {
            List items = Text.fromCSV((String)this.config.matchedTextString());
            for (String val : items) {
                String[] segments = val.split("::");
                int group2 = 0;
                if (segments.length == 2) {
                    int n = group2 = StringUtils.isNumeric((CharSequence)segments[1]) ? Integer.parseInt(segments[1]) : 0;
                    if (group2 > 9 || group2 < 0) {
                        group2 = 0;
                    }
                }
                String matchText = Pattern.quote(Text.escapeJagex((String)segments[0]));
                String currentText = this.textGroupStrings.get(group2);
                String combinedMatchText = currentText != null ? currentText + "|" + matchText : matchText;
                this.textGroupStrings.put(group2, combinedMatchText);
            }
            this.textGroupStrings.forEach((group, text) -> this.matchGroupPatterns.put((Integer)group, Pattern.compile("(?:\\b|(?<=\\s)|\\A)(?:" + text + ")(?:\\b|(?=\\s)|\\z)", 2)));
        }
    }

    private void updateRecolorColor() {
        log.debug("updateRecolorColor");
        boolean transparent = this.client.isResized() && this.transparencyVarbit != 0;
        Object defaultColorString = "";
        this.colorGroupStrings.clear();
        switch (this.config.recolorStyle()) {
            case CHAT_COLOR_CONFIG: {
                Color chatColorConfigColor = (Color)this.configManager.getConfiguration("textrecolor", transparent ? "transparentGameMessage" : "opaqueGameMessage", Color.class);
                if (chatColorConfigColor == null) break;
                defaultColorString = "<col=" + ColorUtil.toHexColor((Color)chatColorConfigColor).substring(1) + ">";
                break;
            }
            case THIS_CONFIG: {
                Color thisConfigColor;
                Color color = thisConfigColor = transparent ? this.config.transparentRecolor() : this.config.opaqueRecolor();
                if (thisConfigColor == null) break;
                defaultColorString = "<col=" + ColorUtil.toHexColor((Color)thisConfigColor).substring(1) + ">";
                break;
            }
        }
        this.colorGroupStrings.put(0, (String)defaultColorString);
        for (int i = 1; i < 10; ++i) {
            Color color = (Color)this.configManager.getConfiguration("forcerecolor", transparent ? "transparentRecolorGroup" + String.valueOf(i) : "opaqueRecolorGroup" + String.valueOf(i), Color.class);
            this.colorGroupStrings.put(i, (String)(color != null ? "<col=" + ColorUtil.toHexColor((Color)color).substring(1) + ">" : ""));
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("forcerecolor")) {
            this.updateMatchingText();
            this.updateRecolorColor();
        }
        if (event.getGroup().equals("textrecolor")) {
            this.updateRecolorColor();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int setting = this.client.getVarbitValue(4608);
        if (this.transparencyVarbit != setting) {
            this.transparencyVarbit = setting;
            this.updateRecolorColor();
        }
    }

    @Subscribe(priority=-3.0f)
    public void onChatMessage(ChatMessage chatMessage) {
        ChatMessageType chatType = chatMessage.getType();
        if (!this.config.allMessageTypes() && chatType != ChatMessageType.GAMEMESSAGE && chatType != ChatMessageType.SPAM && chatType != ChatMessageType.ENGINE) {
            return;
        }
        MessageNode messageNode = chatMessage.getMessageNode();
        String nodeValue = ForceRecolorPlugin.removeMostTags(messageNode.getValue());
        for (int group : this.matchGroupPatterns.keySet()) {
            Matcher matcher = this.matchGroupPatterns.get(group).matcher(nodeValue);
            if (!matcher.find()) continue;
            this.clientThread.invokeLater(() -> {
                messageNode.setValue(this.colorGroupStrings.get(group) + nodeValue);
                messageNode.setRuneLiteFormatMessage(messageNode.getValue());
                this.client.refreshChat();
            });
            break;
        }
    }

    public static String removeMostTags(String str) {
        return TAG_REGEXP_SANS_LT_GT.matcher(str).replaceAll("").replace('\u00a0', ' ');
    }
}

