/*
 * Decompiled with CFR 0.152.
 */
package com.godwarsprot;

import com.godwarsprot.GodWarsProtConfig;
import com.godwarsprot.GodWarsProtItemOverlay;
import com.godwarsprot.GodWarsProtOverlay;
import com.godwarsprot.items.Ancient;
import com.godwarsprot.items.Armadyl;
import com.godwarsprot.items.Bandos;
import com.godwarsprot.items.Saradomin;
import com.godwarsprot.items.Zamorak;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="God Wars Protection Overlay")
public class GodWarsProtPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GodWarsProtPlugin.class);
    public static boolean hasBandos = false;
    public static boolean hasArma = false;
    public static boolean hasZam = false;
    public static boolean hasAnc = false;
    public static boolean hasSara = false;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GodWarsProtConfig config;
    @Inject
    private GodWarsProtOverlay overlay;
    @Inject
    private GodWarsProtItemOverlay itemOverlay;
    @Inject
    private Armadyl armadyl;
    @Inject
    private Bandos bandos;
    @Inject
    private Zamorak zamorak;
    @Inject
    private Saradomin saradomin;
    @Inject
    private Ancient ancient;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.itemOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.itemOverlay);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            return;
        }
        this.checkItems(event.getItemContainer().getItems());
    }

    private void checkItems(Item[] items) {
        boolean sara2 = false;
        boolean bandos2 = false;
        boolean arma2 = false;
        boolean zam2 = false;
        boolean anc2 = false;
        for (Item item : items) {
            if (!arma2 && this.armadyl.checkList(item.getId())) {
                arma2 = true;
            }
            if (!bandos2 && this.bandos.checkList(item.getId())) {
                bandos2 = true;
            }
            if (!zam2 && this.zamorak.checkList(item.getId())) {
                zam2 = true;
            }
            if (!sara2 && this.saradomin.checkList(item.getId())) {
                sara2 = true;
            }
            if (anc2 || !this.ancient.checkList(item.getId())) continue;
            anc2 = true;
        }
        hasArma = arma2;
        hasZam = zam2;
        hasBandos = bandos2;
        hasAnc = anc2;
        hasSara = sara2;
    }

    @Provides
    GodWarsProtConfig provideConfig(ConfigManager configManager) {
        return (GodWarsProtConfig)configManager.getConfig(GodWarsProtConfig.class);
    }
}

