/*
 * Decompiled with CFR 0.152.
 */
package com.godwarsprot;

import com.godwarsprot.GodWarsProtConfig;
import com.godwarsprot.GodWarsProtPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.ImageUtil;

public class GodWarsProtOverlay
extends OverlayPanel {
    private final PanelComponent panelComponent = new PanelComponent();
    private final ItemManager itemManager;
    @Inject
    GodWarsProtConfig config;
    private final ImageComponent saraGreen = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/saragreen.png"));
    private final ImageComponent saraRed = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/sarared.png"));
    private final ImageComponent armaGreen = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/armagreen.png"));
    private final ImageComponent armaRed = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/armared.png"));
    private final ImageComponent bandosGreen = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/bandosgreen.png"));
    private final ImageComponent bandosRed = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/bandosred.png"));
    private final ImageComponent zamGreen = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/zamgreen.png"));
    private final ImageComponent zamRed = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/zamred.png"));
    private final ImageComponent ancGreen = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/zarosgreen.png"));
    private final ImageComponent ancRed = new ImageComponent(ImageUtil.loadImageResource(GodWarsProtPlugin.class, (String)"/zarosred.png"));

    public Dimension render(Graphics2D graphics) {
        this.setPosition(this.config.overlayLoc());
        this.panelComponent.getChildren().clear();
        if (this.config.iconOverlay()) {
            this.panelComponent.setOrientation(ComponentOrientation.HORIZONTAL);
            this.panelComponent.getChildren().add(GodWarsProtPlugin.hasArma ? this.armaGreen : this.armaRed);
            this.panelComponent.getChildren().add(GodWarsProtPlugin.hasBandos ? this.bandosGreen : this.bandosRed);
            this.panelComponent.getChildren().add(GodWarsProtPlugin.hasSara ? this.saraGreen : this.saraRed);
            this.panelComponent.getChildren().add(GodWarsProtPlugin.hasZam ? this.zamGreen : this.zamRed);
            this.panelComponent.getChildren().add(GodWarsProtPlugin.hasAnc ? this.ancGreen : this.ancRed);
        } else {
            this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
            String overlayTitle = "God Wars Protection:";
            this.panelComponent.getChildren().add(TitleComponent.builder().text(overlayTitle).color(Color.YELLOW).build());
            this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(overlayTitle) + 60, 50));
            this.panelComponent.getChildren().add(LineComponent.builder().left("Armadyl").right(GodWarsProtPlugin.hasArma ? "Yes" : "No").rightColor(GodWarsProtPlugin.hasArma ? Color.green : Color.red).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Bandos").right(GodWarsProtPlugin.hasBandos ? "Yes" : "No").rightColor(GodWarsProtPlugin.hasBandos ? Color.green : Color.red).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Saradomin").right(GodWarsProtPlugin.hasSara ? "Yes" : "No").rightColor(GodWarsProtPlugin.hasSara ? Color.green : Color.red).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Zamorak").right(GodWarsProtPlugin.hasZam ? "Yes" : "No").rightColor(GodWarsProtPlugin.hasZam ? Color.green : Color.red).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Ancient").right(GodWarsProtPlugin.hasAnc ? "Yes" : "No").rightColor(GodWarsProtPlugin.hasAnc ? Color.green : Color.red).build());
        }
        if (this.config.showOverlay()) {
            return this.panelComponent.render(graphics);
        }
        return null;
    }

    @Inject
    private GodWarsProtOverlay(ItemManager itemManager) {
        this.itemManager = itemManager;
    }
}

