/*
 * Decompiled with CFR 0.152.
 */
package com.godwarsprot;

import com.godwarsprot.GodWarsProtConfig;
import com.godwarsprot.GodWarsProtHighlightStyle;
import com.godwarsprot.items.Ancient;
import com.godwarsprot.items.Armadyl;
import com.godwarsprot.items.Bandos;
import com.godwarsprot.items.Saradomin;
import com.godwarsprot.items.Zamorak;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

public class GodWarsProtItemOverlay
extends WidgetItemOverlay {
    private final GodWarsProtConfig config;
    private final ItemManager itemManager;
    private final Armadyl armadyl;
    private final Bandos bandos;
    private final Zamorak zamorak;
    private final Saradomin saradomin;
    private final Ancient ancient;

    @Inject
    public GodWarsProtItemOverlay(ItemManager itemManager, GodWarsProtConfig config, Armadyl armadyl, Bandos bandos, Zamorak zamorak, Saradomin saradomin, Ancient ancient) {
        this.config = config;
        this.armadyl = armadyl;
        this.bandos = bandos;
        this.zamorak = zamorak;
        this.saradomin = saradomin;
        this.ancient = ancient;
        this.itemManager = itemManager;
        this.showOnInventory();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (!this.config.itemHighlight()) {
            return;
        }
        Color colorToUse = this.checkGod(itemId);
        if (colorToUse == null) {
            return;
        }
        Rectangle bounds = itemWidget.getCanvasBounds();
        if (this.config.highlightStyle() == GodWarsProtHighlightStyle.OUTLINE || this.config.highlightStyle() == GodWarsProtHighlightStyle.BOTH) {
            BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), colorToUse);
            graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
        }
        if (this.config.highlightStyle() == GodWarsProtHighlightStyle.UNDERLINE || this.config.highlightStyle() == GodWarsProtHighlightStyle.BOTH) {
            int heightOffSet = (int)bounds.getY() + (int)bounds.getHeight() + 2;
            graphics.setColor(colorToUse);
            graphics.drawLine((int)bounds.getX(), heightOffSet, (int)bounds.getX() + (int)bounds.getWidth(), heightOffSet);
        }
    }

    private Color checkGod(int itemId) {
        if (this.armadyl.checkList(itemId)) {
            return Color.white;
        }
        if (this.zamorak.checkList(itemId)) {
            return Color.red;
        }
        if (this.ancient.checkList(itemId)) {
            return Color.MAGENTA;
        }
        if (this.bandos.checkList(itemId)) {
            return Color.ORANGE;
        }
        if (this.saradomin.checkList(itemId)) {
            return Color.blue;
        }
        return null;
    }
}

