/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.fishbarrel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FishBarrelWidgetParser {
    private static final String EMPTY_MESSAGE = "The barrel is empty.";
    private static final String MESSAGE_ENTRY_REGEX = "([0-9]+) x [a-zA-Z ]+,? ?";
    private static final Pattern MESSAGE_ENTRY_PATTERN = Pattern.compile("([0-9]+) x [a-zA-Z ]+,? ?");
    private static final Pattern FULL_MESSAGE_PATTERN = Pattern.compile("^The barrel contains: (([0-9]+) x [a-zA-Z ]+,? ?)+$");

    public int parse(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return -1;
        }
        if (EMPTY_MESSAGE.equals(message = StringUtils.replace((String)message, (String)"<br>", (String)" ").trim())) {
            return 0;
        }
        if (!FULL_MESSAGE_PATTERN.matcher(message).matches()) {
            return -1;
        }
        int fishCount = 0;
        Matcher matcher = MESSAGE_ENTRY_PATTERN.matcher(message);
        while (matcher.find()) {
            try {
                fishCount += Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return fishCount;
    }
}

