/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.fishbarrel;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.molopl.plugins.fishbarrel.FishBarrel;
import com.molopl.plugins.fishbarrel.FishBarrelAction;
import com.molopl.plugins.fishbarrel.FishBarrelOverlay;
import com.molopl.plugins.fishbarrel.FishBarrelWidgetParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fish Barrel", description="Shows how many fish are in the fish barrel", tags={"fish", "barrel", "tempoross"})
public class FishBarrelPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FishBarrelPlugin.class);
    private final int GAME_TICK_MARGIN = 3;
    private static final Pattern FISH_CAUGHT_MESSAGE = Pattern.compile("^You catch (an?|some) ([a-zA-Z ]+)[.!]( It hardens as you handle it with your ice gloves\\.)?$");
    private static final String RADA_DOUBLE_CATCH_MESSAGE = "Rada's blessing enabled you to catch an extra fish.";
    private static final String FLAKES_DOUBLE_CATCH_MESSAGE = "The spirit flakes enabled you to catch an extra fish.";
    private static final String CORMORANT_CATCH_MESSAGE = "Your cormorant returns with its catch.";
    private static final String BANK_FULL_MESSAGE = "Your bank could not hold your fish.";
    private static final String BARREL_FULL_MESSAGE = "The barrel is full. It may be emptied at a bank.";
    private static final Map<String, Integer> FISH_TYPES_BY_NAME = ImmutableMap.builder().put((Object)"shrimp", (Object)317).put((Object)"shrimps", (Object)317).put((Object)"sardine", (Object)327).put((Object)"herring", (Object)345).put((Object)"anchovies", (Object)321).put((Object)"mackerel", (Object)353).put((Object)"trout", (Object)335).put((Object)"cod", (Object)341).put((Object)"pike", (Object)349).put((Object)"slimy swamp eel", (Object)3379).put((Object)"salmon", (Object)331).put((Object)"tuna", (Object)359).put((Object)"rainbow fish", (Object)10138).put((Object)"cave eel", (Object)5001).put((Object)"lobster", (Object)377).put((Object)"bass", (Object)363).put((Object)"leaping trout", (Object)11328).put((Object)"swordfish", (Object)371).put((Object)"lava eel", (Object)2148).put((Object)"leaping salmon", (Object)11330).put((Object)"monkfish", (Object)7944).put((Object)"Karambwan", (Object)3142).put((Object)"leaping sturgeon", (Object)11332).put((Object)"shark", (Object)383).put((Object)"infernal eel", (Object)21293).put((Object)"anglerfish", (Object)13439).put((Object)"dark crab", (Object)11934).put((Object)"sacred eel", (Object)13339).build();
    private static final Set<Integer> MOLCH_ISLAND_FISH_TYPES = ImmutableSet.of((Object)22826, (Object)22829, (Object)22832, (Object)22835);
    private static final Set<Integer> OTHER_FISH_TYPES = ImmutableSet.of((Object)395, (Object)389);
    private static final Set<Integer> ALL_FISH_TYPES = ImmutableSet.builder().addAll(FISH_TYPES_BY_NAME.values()).addAll(MOLCH_ISLAND_FISH_TYPES).addAll(OTHER_FISH_TYPES).build();
    private static final int CHECK_WIDGET_INTERFACE = 193;
    private static final int CHECK_WIDGET_COMPONENT = 2;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private FishBarrelOverlay fishBarrelOverlay;
    @Inject
    private ClientThread clientThread;
    private final FishBarrelWidgetParser widgetParser = new FishBarrelWidgetParser();
    private final AtomicInteger fishCaughtMessages = new AtomicInteger();
    private final AtomicInteger newFishInInventory = new AtomicInteger();
    private final AtomicInteger cookingXpDrops = new AtomicInteger();
    private final Multiset<Integer> inventoryItems = HashMultiset.create();
    private final Multiset<Integer> equipmentItems = HashMultiset.create();
    private final Map<FishBarrelAction, Integer> barrelActions = new HashMap<FishBarrelAction, Integer>();

    public void startUp() {
        this.overlayManager.add((Overlay)this.fishBarrelOverlay);
        FishBarrel.STATE.setHolding(0);
        FishBarrel.STATE.setUnknown(true);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.updateInventory(InventoryID.INVENTORY, (Collection<Integer>)this.inventoryItems);
            this.updateInventory(InventoryID.EQUIPMENT, (Collection<Integer>)this.equipmentItems);
        }
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.fishBarrelOverlay);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE && this.hasAnyOfItems(FishBarrel.BARREL_IDS)) {
            switch (event.getMessage()) {
                case "Your bank could not hold your fish.": {
                    FishBarrel.STATE.setUnknown(true);
                    break;
                }
                case "The barrel is full. It may be emptied at a bank.": {
                    FishBarrel.STATE.setHolding(28);
                    FishBarrel.STATE.setUnknown(false);
                }
            }
        } else if (event.getType() == ChatMessageType.SPAM && this.hasAnyOfItems(FishBarrel.OPEN_BARREL_IDS)) {
            Matcher matcher = FISH_CAUGHT_MESSAGE.matcher(event.getMessage());
            if (matcher.matches()) {
                String fishName = matcher.group(2);
                if (FISH_TYPES_BY_NAME.containsKey(fishName)) {
                    this.fishCaughtMessages.incrementAndGet();
                }
            } else {
                switch (event.getMessage()) {
                    case "Rada's blessing enabled you to catch an extra fish.": 
                    case "The spirit flakes enabled you to catch an extra fish.": 
                    case "Your cormorant returns with its catch.": {
                        this.fishCaughtMessages.incrementAndGet();
                    }
                }
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            if (!this.hasAnyOfItems(FishBarrel.BARREL_IDS)) {
                this.updateInventory(event.getItemContainer(), (Collection<Integer>)this.inventoryItems);
                return;
            }
            HashMultiset prevInventory = HashMultiset.create(this.inventoryItems);
            this.updateInventory(event.getItemContainer(), (Collection<Integer>)this.inventoryItems);
            Multiset addedItems = Multisets.difference(this.inventoryItems, (Multiset)prevInventory);
            Multiset addedFish = Multisets.filter((Multiset)addedItems, ALL_FISH_TYPES::contains);
            Multiset removedItems = Multisets.difference((Multiset)prevInventory, this.inventoryItems);
            Multiset removedFish = Multisets.filter((Multiset)removedItems, ALL_FISH_TYPES::contains);
            if (addedFish.size() > 0) {
                this.newFishInInventory.updateAndGet(i -> i + addedFish.size());
            }
            if (removedFish.size() > 0 && this.recentlyActioned(FishBarrelAction.FILL)) {
                if (this.inventoryItems.stream().anyMatch(ALL_FISH_TYPES::contains)) {
                    FishBarrel.STATE.setHolding(28);
                    FishBarrel.STATE.setUnknown(false);
                } else {
                    FishBarrel.STATE.setHolding(Math.min(28, FishBarrel.STATE.getHolding() + removedFish.size()));
                }
            }
        } else if (event.getContainerId() == InventoryID.EQUIPMENT.getId()) {
            this.updateInventory(event.getItemContainer(), (Collection<Integer>)this.equipmentItems);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        if (event.getSkill() == Skill.COOKING && event.getXp() > 0) {
            this.cookingXpDrops.incrementAndGet();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 193 && this.recentlyActioned(FishBarrelAction.CHECK)) {
            this.clientThread.invokeLater(() -> {
                Widget widget = this.client.getWidget(193, 2);
                if (widget == null) {
                    return;
                }
                int parseResult = this.widgetParser.parse(widget.getText());
                if (parseResult != -1) {
                    FishBarrel.STATE.setHolding(parseResult);
                    FishBarrel.STATE.setUnknown(false);
                }
            });
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.fishCaughtMessages.get() > 0) {
            FishBarrel barrel = FishBarrel.STATE;
            if (this.newFishInInventory.get() == 0) {
                int delta = Math.max(0, this.fishCaughtMessages.get() - this.cookingXpDrops.get());
                barrel.setHolding(Math.min(28, barrel.getHolding() + delta));
            } else {
                barrel.setHolding(28);
                barrel.setUnknown(false);
            }
        } else if (this.recentlyActioned(FishBarrelAction.EMPTY)) {
            FishBarrel.STATE.setHolding(0);
            FishBarrel.STATE.setUnknown(false);
        }
        this.fishCaughtMessages.set(0);
        this.newFishInInventory.set(0);
        this.cookingXpDrops.set(0);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int itemId = -1;
        switch (event.getMenuAction()) {
            case ITEM_FIRST_OPTION: 
            case ITEM_SECOND_OPTION: 
            case ITEM_THIRD_OPTION: 
            case ITEM_FOURTH_OPTION: 
            case ITEM_FIFTH_OPTION: {
                itemId = event.getId();
                break;
            }
            case CC_OP: 
            case CC_OP_LOW_PRIORITY: {
                int widgetId = event.getWidgetId();
                Widget widget = this.client.getWidget(WidgetInfo.TO_GROUP((int)widgetId), WidgetInfo.TO_CHILD((int)widgetId));
                if (widget == null) break;
                int child = event.getActionParam();
                if (child == -1) {
                    return;
                }
                if ((widget = widget.getChild(child)) == null) break;
                itemId = widget.getItemId();
                break;
            }
            default: {
                return;
            }
        }
        if (!FishBarrel.BARREL_IDS.contains(itemId)) {
            return;
        }
        FishBarrelAction action = FishBarrelAction.forMenuOption(event.getMenuOption());
        if (action != null) {
            this.barrelActions.put(action, this.client.getTickCount());
        }
    }

    private void updateInventory(InventoryID inventoryID, Collection<Integer> target) {
        this.clientThread.invokeLater(() -> {
            ItemContainer itemContainer = this.client.getItemContainer(inventoryID);
            if (itemContainer != null) {
                this.updateInventory(itemContainer, target);
            }
        });
    }

    private void updateInventory(ItemContainer itemContainer, Collection<Integer> target) {
        target.clear();
        Arrays.stream(itemContainer.getItems()).map(Item::getId).forEach(target::add);
    }

    private boolean hasAnyOfItems(Collection<Integer> itemIds) {
        for (int itemId : itemIds) {
            if (!this.inventoryItems.contains((Object)itemId) && !this.equipmentItems.contains((Object)itemId)) continue;
            return true;
        }
        return false;
    }

    private boolean recentlyActioned(FishBarrelAction action) {
        if (this.barrelActions.containsKey((Object)action) && this.barrelActions.get((Object)action) > this.client.getTickCount() - 3) {
            this.barrelActions.remove((Object)action);
            return true;
        }
        return false;
    }
}

