/*
 * Decompiled with CFR 0.152.
 */
package com.gotrleech.overlay;

import com.gotrleech.GotrGameState;
import com.gotrleech.GotrLeechConfig;
import com.gotrleech.GotrLeechPlugin;
import com.gotrleech.GotrPlayerState;
import com.gotrleech.item.GotrItemManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class GotrOverlayPanel
extends OverlayPanel {
    private static final String OVERLAY_NAME = "Guardians of the Rift Leech Overlay";
    private final Client client;
    private final GotrLeechPlugin plugin;
    private final GotrGameState gotrGameState;
    private final GotrPlayerState gotrPlayerState;
    private final GotrItemManager gotrItemManager;
    private final GotrLeechConfig config;
    private final Color originalBackgroundColor;

    @Inject
    public GotrOverlayPanel(Client client, GotrLeechPlugin plugin, GotrGameState gotrGameState, GotrPlayerState gotrPlayerState, GotrItemManager gotrItemManager, GotrLeechConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.gotrGameState = gotrGameState;
        this.gotrPlayerState = gotrPlayerState;
        this.gotrItemManager = gotrItemManager;
        this.config = config;
        this.originalBackgroundColor = this.panelComponent.getBackgroundColor();
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", OVERLAY_NAME));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.gotrGameState.isInGame()) {
            return null;
        }
        this.renderBool(this.gotrPlayerState.isMining(), "Is Mining");
        this.renderInt(this.gotrPlayerState.getTotalEnergy(), "Total Energy", 150);
        this.panelComponent.getChildren().add(LineComponent.builder().build());
        if (this.config.minBindingNecklaceChargesRequired() > 0) {
            this.renderInt(this.gotrPlayerState.getBindingNecklaceCharges(), "Binding Necklace Charges", this.config.minBindingNecklaceChargesRequired());
            this.renderInt(this.gotrItemManager.getBindingNecklaces().getCount(), "Binding Necklaces", 1);
        }
        if (this.config.minUnchargedCellsRequired() > 0) {
            this.renderInt(this.gotrItemManager.getUnchargedCells().getCount(), "Uncharged Cells", this.config.minUnchargedCellsRequired());
        }
        if (this.shouldFlash()) {
            this.flashOverlay();
        } else {
            this.panelComponent.setBackgroundColor(this.originalBackgroundColor);
        }
        this.panelComponent.setPreferredSize(new Dimension(175, 0));
        return super.render(graphics);
    }

    private void renderInt(int val, String label, int minVal) {
        this.panelComponent.getChildren().add(LineComponent.builder().left(label + ":").right(String.valueOf(val)).rightColor(this.chooseColor(val >= minVal)).build());
    }

    private void renderBool(boolean val, String label) {
        this.panelComponent.getChildren().add(LineComponent.builder().left(label + ":").right(val ? "YES" : "NO").rightColor(this.chooseColor(val)).build());
    }

    private Color chooseColor(boolean val) {
        return val ? Color.GREEN : Color.RED;
    }

    private boolean shouldFlash() {
        return this.config.flashOverlayWhenNotMining() && !this.gotrPlayerState.isMining();
    }

    private void flashOverlay() {
        if (this.client.getTickCount() % 2 == 0) {
            this.panelComponent.setBackgroundColor(new Color(255, 0, 0, this.originalBackgroundColor.getAlpha()));
        } else {
            this.panelComponent.setBackgroundColor(this.originalBackgroundColor);
        }
    }
}

