/*
 * Decompiled with CFR 0.152.
 */
package com.gotrleech.item;

import com.google.common.collect.ImmutableList;
import com.gotrleech.EventHandler;
import com.gotrleech.GotrGameState;
import com.gotrleech.item.GotrItem;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.InventoryID;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GotrItemManager
extends EventHandler {
    private static final Logger log = LoggerFactory.getLogger(GotrItemManager.class);
    private final GotrItem unchargedCells = new GotrItem(26882, InventoryID.INVENTORY.getId());
    private final GotrItem guardianFragments = new GotrItem(26878, InventoryID.INVENTORY.getId());
    private final GotrItem bindingNecklaces = new GotrItem(5521, InventoryID.INVENTORY.getId(), InventoryID.EQUIPMENT.getId());
    private final List<GotrItem> trackedItems = ImmutableList.of((Object)this.unchargedCells, (Object)this.guardianFragments, (Object)this.bindingNecklaces);
    private final Set<Integer> trackedContainerIds = this.trackedItems.stream().map(GotrItem::getContainerIds).flatMap(Collection::stream).collect(Collectors.toSet());
    private final GotrGameState gotrGameState;

    @Inject
    public GotrItemManager(GotrGameState gotrGameState) {
        this.gotrGameState = gotrGameState;
    }

    @Override
    protected void cleanup() {
        this.trackedItems.forEach(item -> item.recalculate(this.client));
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (!this.trackedContainerIds.contains(event.getContainerId())) {
            return;
        }
        for (GotrItem gotrItem : this.trackedItems) {
            if (!gotrItem.getContainerIds().contains(event.getContainerId())) continue;
            gotrItem.recalculate(this.client);
        }
    }

    public GotrItem getUnchargedCells() {
        return this.unchargedCells;
    }

    public GotrItem getGuardianFragments() {
        return this.guardianFragments;
    }

    public GotrItem getBindingNecklaces() {
        return this.bindingNecklaces;
    }
}

