/*
 * Decompiled with CFR 0.152.
 */
package com.gotrleech.item;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.ItemContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GotrItem {
    private static final Logger log = LoggerFactory.getLogger(GotrItem.class);
    private final int itemId;
    private int count;
    private final Map<Integer, Integer> numItems;

    public GotrItem(int itemId, Integer ... containerIds) {
        this.itemId = itemId;
        this.numItems = Arrays.stream(containerIds).collect(Collectors.toMap(Function.identity(), i -> 0));
    }

    public void recalculate(Client client) {
        for (int containerId : this.numItems.keySet()) {
            ItemContainer itemContainer = client.getItemContainer(containerId);
            if (itemContainer == null) continue;
            this.numItems.put(containerId, itemContainer.count(this.itemId));
        }
        this.count = this.numItems.values().stream().mapToInt(Integer::intValue).sum();
    }

    public Set<Integer> getContainerIds() {
        return this.numItems.keySet();
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getCount() {
        return this.count;
    }
}

