/*
 * Decompiled with CFR 0.152.
 */
package com.gotrleech;

import com.google.common.collect.ImmutableSet;
import com.gotrleech.EventHandler;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GotrPlayerState
extends EventHandler {
    private static final Logger log = LoggerFactory.getLogger(GotrPlayerState.class);
    private static final int ELEMENTAL_ENERGY_VARBIT_ID = 13686;
    private static final int CATALYTIC_ENERGY_VARBIT_ID = 13685;
    private static final int BINDING_NECKLACE_VARP_ID = 487;
    private static final Set<Integer> MINING_ANIMATIONS = ImmutableSet.of((Object)625, (Object)626, (Object)627, (Object)3873, (Object)629, (Object)628, (Object[])new Integer[]{624, 8313, 7139, 642, 8346, 8887, 4482, 7283, 8347, 8787, 8788, 8789});
    private boolean isMining;
    private int bindingNecklaceCharges;
    private int elementalEnergy;
    private int catalyticEnergy;

    @Override
    protected void cleanup() {
        this.isMining = this.client.getLocalPlayer() != null ? MINING_ANIMATIONS.contains(this.client.getLocalPlayer().getAnimation()) : false;
        this.bindingNecklaceCharges = this.client.getVarpValue(487);
        this.elementalEnergy = this.client.getVarbitValue(13686);
        this.catalyticEnergy = this.client.getVarbitValue(13685);
    }

    public int getTotalEnergy() {
        return this.elementalEnergy + this.catalyticEnergy;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Player local = this.client.getLocalPlayer();
        if (event.getActor() != local) {
            return;
        }
        this.isMining = MINING_ANIMATIONS.contains(local.getAnimation());
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() == -1) {
            if (event.getVarpId() == 487) {
                this.bindingNecklaceCharges = event.getValue();
            }
        } else if (event.getVarbitId() == 13686) {
            this.elementalEnergy = event.getValue();
        } else if (event.getVarbitId() == 13685) {
            this.catalyticEnergy = event.getValue();
        }
    }

    @Inject
    public GotrPlayerState() {
    }

    public boolean isMining() {
        return this.isMining;
    }

    public int getBindingNecklaceCharges() {
        return this.bindingNecklaceCharges;
    }
}

