/*
 * Decompiled with CFR 0.152.
 */
package com.gotrleech;

import com.google.inject.Provides;
import com.gotrleech.GotrGameState;
import com.gotrleech.GotrLeechConfig;
import com.gotrleech.GotrPlayerState;
import com.gotrleech.event.GotrGameStateChanged;
import com.gotrleech.item.GotrItemManager;
import com.gotrleech.overlay.GotrOverlayPanel;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Guardians of the Rift Leech")
public class GotrLeechPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GotrLeechPlugin.class);
    public static final int ENERGY_REQUIRED = 150;
    static final String CONFIG_GROUP = "gotrLeech";
    @Inject
    private Client client;
    @Inject
    private GotrLeechConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GotrOverlayPanel overlayPanel;
    @Inject
    private GotrGameState gotrGameState;
    @Inject
    private GotrPlayerState gotrPlayerState;
    @Inject
    private GotrItemManager gotrItemManager;

    protected void startUp() throws Exception {
        this.clientThread.invoke(() -> {
            this.gotrGameState.startup();
            this.gotrPlayerState.startup();
            this.gotrItemManager.startup();
        });
        this.overlayManager.add((Overlay)this.overlayPanel);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlayPanel);
        this.clientThread.invoke(() -> {
            this.gotrItemManager.shutdown();
            this.gotrPlayerState.shutdown();
            this.gotrGameState.shutdown();
        });
    }

    @Subscribe
    public void onGotrGameStateChanged(GotrGameStateChanged event) {
        switch (event.getState()) {
            case START: {
                this.start();
                break;
            }
            case END: 
            case FAILED: {
                this.gameOver();
                break;
            }
            case SIXTY_PERCENT: {
                this.sixtyPercent();
                break;
            }
        }
    }

    private void start() {
        if (this.config.notifyOnStart()) {
            this.notifier.notify("A new Guardians of the Rift game has started!");
        }
    }

    private void gameOver() {
        if (!this.config.notifyOnEndForNextGame()) {
            return;
        }
        if (this.gotrItemManager.getBindingNecklaces().getCount() < 1) {
            this.notifier.notify("You are out of binding necklaces!");
            return;
        }
        int bindingCharges = this.gotrPlayerState.getBindingNecklaceCharges();
        if (bindingCharges < this.config.minBindingNecklaceChargesRequired()) {
            this.notifier.notify("You need more binding necklace charges for the next round!");
            return;
        }
        if (this.gotrItemManager.getUnchargedCells().getCount() < this.config.minUnchargedCellsRequired()) {
            this.notifier.notify("You need more uncharged cells for the next round!");
            return;
        }
    }

    private void sixtyPercent() {
        if (!this.config.notifyOnSixtyPercentMessage()) {
            return;
        }
        int pointsToQualify = 150 - this.gotrPlayerState.getTotalEnergy();
        if (pointsToQualify > 0) {
            this.notifier.notify("You still need " + pointsToQualify + " more points to qualify for GotR rewards!");
            return;
        }
    }

    @Provides
    GotrLeechConfig provideConfig(ConfigManager configManager) {
        return (GotrLeechConfig)configManager.getConfig(GotrLeechConfig.class);
    }
}

