/*
 * Decompiled with CFR 0.152.
 */
package com.gotrleech;

import com.gotrleech.EventHandler;
import com.gotrleech.event.GotrGameStateChanged;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GotrGameState
extends EventHandler {
    private static final Logger log = LoggerFactory.getLogger(GotrGameState.class);
    private static final int GOTR_WIDGET_GROUP_ID = 746;
    private static final int GOTR_WIDGET_CHILD_GAME_ID = 1;
    private boolean inGame;

    @Override
    protected void cleanup() {
        this.inGame = false;
    }

    @Subscribe(priority=5.0f)
    public void onGameTick(GameTick e) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.inGame = this.client.getWidget(746, 1) != null;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.inGame) {
            return;
        }
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = Text.removeTags((String)event.getMessage());
        if (message == null) {
            return;
        }
        for (State state : State.values()) {
            if (!message.startsWith(state.getGameMessage())) continue;
            this.eventBus.post((Object)new GotrGameStateChanged(state));
            return;
        }
    }

    @Inject
    public GotrGameState() {
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public static enum State {
        START("Creatures from the Abyss will attack in"),
        END("The Great Guardian successfully closed the rift"),
        FAILED("The Great Guardian was defeated"),
        SIXTY_PERCENT("The rift burns intensely");

        private final String gameMessage;

        private State(String gameMessage) {
            this.gameMessage = gameMessage;
        }

        public String getGameMessage() {
            return this.gameMessage;
        }
    }
}

