/*
 * Decompiled with CFR 0.152.
 */
package com.weaponcharges;

import com.google.inject.Provides;
import com.weaponcharges.ChargedWeapon;
import com.weaponcharges.ChargesDialogHandler;
import com.weaponcharges.ChargesMessage;
import com.weaponcharges.Devtools;
import com.weaponcharges.DialogTracker;
import com.weaponcharges.WeaponChargesConfig;
import com.weaponcharges.WeaponChargesItemOverlay;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.Projectile;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.StatChanged;
import net.runelite.api.kit.KitType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Weapon Charges", description="Displays ibans blast and swamp trident charges on the inventory icon or as an infobox.", tags={"iban", "trident", "charge"})
public class WeaponChargesPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(WeaponChargesPlugin.class);
    public static final String CONFIG_GROUP_NAME = "weaponCharges";
    public static final String DEV_MODE_CONFIG_KEY = "logData";
    private static final int BLOWPIPE_ATTACK_ANIMATION = 5061;
    ChargedWeapon lastUsedOnWeapon;
    ChargedWeapon lastUnchargeClickedWeapon;
    @Inject
    Client client;
    @Inject
    private WeaponChargesItemOverlay itemOverlay;
    @Inject
    private ItemManager itemManager;
    @Inject
    private WeaponChargesConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private DialogTracker dialogTracker;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private Devtools devtools;
    private int lastDegradedHitsplatTick = -1000;
    private List<ChargedWeapon> lastWeaponChecked = new ArrayList<ChargedWeapon>();
    private List<ChargedWeapon> lastWeaponChecked2 = new ArrayList<ChargedWeapon>();
    private final List<Runnable> delayChargeUpdateUntilAfterAnimations = new ArrayList<Runnable>();
    private static final Pattern NO_DARTS_CHECK_PATTERN = Pattern.compile("Darts: None. Scales: ([\\d,]+) \\(\\d+[.]?\\d%\\).");
    private static final Pattern DARTS_AND_SCALE_CHECK_PATTERN = Pattern.compile("Darts: (\\S*)(?: dart)? x ([\\d,]+). Scales: ([\\d,]+) \\(\\d+[.]?\\d%\\).");
    private static final Pattern USE_SCALES_ON_FULL_BLOWPIPE_PATTERN = Pattern.compile("The blowpipe can't hold any more scales.");
    private static final Pattern USE_DARTS_ON_FULL_BLOWPIPE_PATTERN = Pattern.compile("The blowpipe can't hold any more darts.");
    private static final Pattern UNLOAD_EMPTY_BLOWPIPE_PATTERN = Pattern.compile("The blowpipe has no darts in it.");
    private static final Pattern NO_DARTS_PATTERN = Pattern.compile("Your blowpipe has run out of darts.");
    private static final Pattern NO_SCALES_PATTERN = Pattern.compile("Your blowpipe needs to be charged with Zulrah's scales.");
    private static final Pattern NO_DARTS_OR_SCALES_PATTERN = Pattern.compile("Your blowpipe has run out of scales and darts.");
    private static final Pattern NO_DARTS_PATTERN_2 = Pattern.compile("Your blowpipe contains no darts.");
    private static final Pattern NO_DARTS_OR_SCALES_PATTERN_2 = Pattern.compile("Your blowpipe needs to be charged with Zulrah's scales and loaded with darts.");
    private int checkBlowpipeUnload = -100;
    private int checkSingleCrystalShardUse = -100;
    private int lastLocalPlayerAnimationChangedGameTick = -1;
    private int lastLocalPlayerAnimationChanged = -1;
    private int lastLocalPlayerGraphicChangedGameTick = -1;
    private int lastLocalPlayerGraphicChanged = -1;
    private int checkBlowpipeGameTick = -1;
    private static final int TICKS_RAPID_PVM = 2;
    private static final int TICKS_NORMAL_PVM = 3;
    public static final int MAX_SCALES_BLOWPIPE = 16383;
    public static final int MAX_DARTS = 16383;
    private int blowpipeCooldownUp = 0;
    @Inject
    ConfigManager configManager;
    private boolean showChargesKeyIsDown = false;
    private boolean bloodFuryAppliedThisTick = false;
    private final Set<Integer> MELEE_ATTACK_ANIMATIONS = Set.of(8056, 245, 376, 381, 386, 390, 8288, 8290, 8289, 9471, 6118, 393, 0, 395, 400, 401, 406, 407, 414, 419, 422, 423, 428, 429, 440, 1058, 1060, 1062, 1378, 1658, 1665, 1667, 2066, 2067, 2078, 2661, 3297, 3298, 3852, 4503, 5865, 7004, 7045, 7054, 7055, 7514, 7515, 7516, 7638, 7639, 7640, 7641, 7642, 7643, 7644, 7645, 8145, 9171, 1203, 5439, 8640);
    private int checkScytheHitsplats = -1;
    private int scytheHitsplatsSeen = 0;

    @Provides
    WeaponChargesConfig getConfig(ConfigManager configManager) {
        return (WeaponChargesConfig)configManager.getConfig(WeaponChargesConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.itemOverlay);
        if (this.config.devMode()) {
            this.enableDevMode();
        }
        this.dialogTracker.reset();
        this.eventBus.register((Object)this.dialogTracker);
        this.keyManager.registerKeyListener((KeyListener)this.dialogTracker);
        this.keyManager.registerKeyListener((KeyListener)this);
        this.dialogTracker.setStateChangedListener(this::dialogStateChanged);
        this.dialogTracker.setOptionSelectedListener(this::optionSelected);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.itemOverlay);
        this.disableDevMode();
        this.eventBus.unregister((Object)this.dialogTracker);
        this.keyManager.unregisterKeyListener((KeyListener)this.dialogTracker);
        this.keyManager.unregisterKeyListener((KeyListener)this);
    }

    void dialogStateChanged(DialogTracker.DialogState dialogState) {
        if (this.devtools != null && this.config.devMode()) {
            this.devtools.dialogStateChanged(dialogState);
        }
        for (ChargesDialogHandler nonUniqueDialogHandler : ChargedWeapon.getNonUniqueDialogHandlers()) {
            nonUniqueDialogHandler.handleDialog(dialogState, this);
        }
        block1: for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            for (ChargesDialogHandler dialogHandler : chargedWeapon.getDialogHandlers()) {
                if (!dialogHandler.handleDialog(dialogState, this)) continue;
                break block1;
            }
        }
    }

    void optionSelected(DialogTracker.DialogState dialogState, String optionSelected) {
        if (this.devtools != null && this.config.devMode()) {
            this.devtools.optionSelected(dialogState, optionSelected);
        }
        for (ChargesDialogHandler nonUniqueDialogHandler : ChargedWeapon.getNonUniqueDialogHandlers()) {
            nonUniqueDialogHandler.handleDialogOptionSelected(dialogState, optionSelected, this);
        }
        block1: for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            for (ChargesDialogHandler dialogHandler : chargedWeapon.getDialogHandlers()) {
                if (!dialogHandler.handleDialogOptionSelected(dialogState, optionSelected, this)) continue;
                break block1;
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals(CONFIG_GROUP_NAME) && configChanged.getKey().equals(DEV_MODE_CONFIG_KEY)) {
            if (this.config.devMode()) {
                this.enableDevMode();
            } else {
                this.disableDevMode();
            }
        }
    }

    private void enableDevMode() {
        if (this.devtools == null) {
            this.devtools = new Devtools(this);
        }
        this.eventBus.register((Object)this.devtools);
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied e) {
        ChargedWeapon helm;
        int hitType = e.getHitsplat().getHitsplatType();
        if (this.checkScytheHitsplats == this.client.getTickCount() && e.getHitsplat().isMine() && e.getHitsplat().getAmount() > 0 && this.scytheHitsplatsSeen <= 2) {
            if (this.scytheHitsplatsSeen > 0) {
                this.addCharges(ChargedWeapon.BLOOD_FURY, -1.0f, false);
            }
            ++this.scytheHitsplatsSeen;
        }
        if ((helm = this.getEquippedChargedWeapon(EquipmentInventorySlot.HEAD)) == ChargedWeapon.SERPENTINE_HELM && e.getHitsplat().isMine() && this.client.getTickCount() - this.lastDegradedHitsplatTick > 90) {
            this.addCharges(helm, -10.0f, false);
            this.lastDegradedHitsplatTick = this.client.getTickCount();
            if (this.config.devMode()) {
                this.client.addChatMessage(ChatMessageType.FRIENDSCHAT, "WeaponCharges", "Serpentine Helmet has Degraded!", "DEVMODE");
            }
        }
        ChargedWeapon body = this.getEquippedChargedWeapon(EquipmentInventorySlot.BODY);
        ChargedWeapon legs = this.getEquippedChargedWeapon(EquipmentInventorySlot.LEGS);
        if (e.getActor() == this.client.getLocalPlayer() && hitType == 16) {
            if (helm == ChargedWeapon.CRYSTAL_HELM) {
                this.addCharges(helm, -1.0f, false);
            }
            if (body == ChargedWeapon.CRYSTAL_BODY) {
                this.addCharges(body, -1.0f, false);
            }
            if (legs == ChargedWeapon.CRYSTAL_LEGS) {
                this.addCharges(legs, -1.0f, false);
            }
        }
    }

    private void disableDevMode() {
        if (this.devtools != null) {
            this.eventBus.unregister((Object)this.devtools);
        }
    }

    @Subscribe(priority=-1.0f)
    public void onMenuOpened(MenuOpened e) {
        this.onMenuOpened2();
        this.addVorkathsHeadMenuOptions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addVorkathsHeadMenuOptions() {
        if (!this.client.isKeyPressed(81) || this.config.vorkathsHeadMenuOptionDisabled()) {
            return;
        }
        for (MenuEntry menuEntry : this.client.getMenuEntries()) {
            int itemId;
            if (WidgetUtil.componentToInterface((int)menuEntry.getParam1()) == 387) {
                int childId = WidgetUtil.componentToId((int)menuEntry.getParam1());
                if (childId != 16) return;
                ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
                if (itemContainer == null) {
                    return;
                }
                Item item = itemContainer.getItem(EquipmentInventorySlot.CAPE.getSlotIdx());
                if (item == null) {
                    return;
                }
                itemId = item.getId();
            } else {
                if (menuEntry.getItemId() == -1) continue;
                itemId = menuEntry.getItemId();
            }
            if (itemId != 9756 && itemId != 9757 && itemId != 13280) continue;
            boolean vorkathsHeadUsed = Boolean.valueOf(this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, "vorkathsHeadUsed"));
            this.client.createMenuEntry(0).setOption("Weapon Charges Plugin vorkath's head ammo saving is " + (vorkathsHeadUsed ? "on" : "off")).setTarget(ColorUtil.wrapWithColorTag((String)("Click to turn " + (vorkathsHeadUsed ? "off" : "on")), (Color)Color.ORANGE)).onClick(entry -> this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, "vorkathsHeadUsed", (Object)(!vorkathsHeadUsed ? 1 : 0)));
            return;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuOption().equalsIgnoreCase("check")) {
            if (this.config.devMode()) {
                log.info("clicked \"check\" on " + event.getMenuTarget());
            }
            if (WidgetUtil.componentToInterface((int)event.getParam1()) == 387) {
                ChargedWeapon chargedWeapon;
                int childId = WidgetUtil.componentToId((int)event.getParam1());
                if (childId == 18) {
                    chargedWeapon = this.getEquippedChargedWeapon(EquipmentInventorySlot.WEAPON);
                    if (chargedWeapon != null) {
                        this.lastWeaponChecked.add(chargedWeapon);
                    }
                } else if (childId == 20 && (chargedWeapon = this.getEquippedChargedWeapon(EquipmentInventorySlot.SHIELD)) != null) {
                    this.lastWeaponChecked.add(chargedWeapon);
                }
            } else {
                for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
                    if (!chargedWeapon.getItemIds().contains(event.getItemId()) || !chargedWeapon.getCheckChargesRegexes().isEmpty()) continue;
                    if (this.config.devMode()) {
                        log.info("adding last weapon checked to " + chargedWeapon);
                    }
                    this.lastWeaponChecked.add(chargedWeapon);
                    break;
                }
            }
        } else if (event.getMenuOption().equalsIgnoreCase("uncharge")) {
            for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
                if (!chargedWeapon.getItemIds().contains(event.getItemId())) continue;
                if (this.config.devMode()) {
                    log.info("setting lastUnchargeClickedWeapon to " + chargedWeapon);
                }
                this.lastUnchargeClickedWeapon = chargedWeapon;
                break;
            }
        } else if (event.getMenuOption().equalsIgnoreCase("unload") && event.getItemId() == 12926) {
            this.checkBlowpipeUnload = this.client.getTickCount();
        } else if (event.getMenuOption().equalsIgnoreCase("pages")) {
            this.lastUsedOnWeapon = WidgetUtil.componentToInterface((int)event.getParam1()) == 387 ? this.getEquippedChargedWeapon(EquipmentInventorySlot.SHIELD) : ChargedWeapon.getChargedWeaponFromId(event.getItemId());
            if (this.config.devMode()) {
                log.info("pages checked. setting last used weapon to {}", (Object)this.lastUsedOnWeapon.toString());
            }
        }
        if (event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET) {
            ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
            Item itemUsed = itemContainer.getItem(this.client.getSelectedWidget().getIndex());
            if (itemUsed == null) {
                return;
            }
            int itemUsedId = itemUsed.getId();
            Item itemUsedOn = itemContainer.getItem(event.getWidget().getIndex());
            if (itemUsedOn == null) {
                return;
            }
            int itemUsedOnId = itemUsedOn.getId();
            this.lastUsedOnWeapon = ChargedWeapon.getChargedWeaponFromId(itemUsedId);
            if (this.lastUsedOnWeapon == null) {
                this.lastUsedOnWeapon = ChargedWeapon.getChargedWeaponFromId(itemUsedOnId);
                if (this.lastUsedOnWeapon != null) {
                    if (this.config.devMode()) {
                        log.info("{}: used {} on {}", new Object[]{this.client.getTickCount(), itemUsedId, this.lastUsedOnWeapon});
                    }
                    this.checkSingleCrystalShardUse(itemUsed, itemUsedId);
                } else if (this.config.devMode()) {
                    log.info("{}: used {} on {}", new Object[]{this.client.getTickCount(), itemUsedId, itemUsedOnId});
                }
            } else {
                if (this.config.devMode()) {
                    log.info("{}: used {} on {}", new Object[]{this.client.getTickCount(), this.lastUsedOnWeapon, itemUsedOnId});
                }
                this.checkSingleCrystalShardUse(itemUsedOn, itemUsedOnId);
            }
        }
    }

    private void checkSingleCrystalShardUse(Item itemUsed, int itemUsedId) {
        if (itemUsedId == 23962 && itemUsed.getQuantity() == 1 && ChargedWeapon.CRYSTAL_SHARD_RECHARGABLE_ITEMS.contains((Object)this.lastUsedOnWeapon)) {
            this.checkSingleCrystalShardUse = this.client.getTickCount();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        if (this.checkBlowpipeUnload == this.client.getTickCount() || this.checkBlowpipeUnload + 1 == this.client.getTickCount()) {
            this.setDartsLeft(0.0f);
            this.setDartType(DartType.UNKNOWN);
        }
        if (this.checkSingleCrystalShardUse == this.client.getTickCount() || this.checkSingleCrystalShardUse + 1 == this.client.getTickCount()) {
            this.addCharges(this.lastUsedOnWeapon, 100.0f, false);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher matcher;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = Text.removeTags((String)event.getMessage());
        for (ChargesMessage checkMessage : ChargedWeapon.getNonUniqueCheckChargesRegexes()) {
            matcher = checkMessage.getPattern().matcher(message);
            if (!matcher.find()) continue;
            ChargedWeapon chargedWeapon = this.removeLastWeaponChecked();
            if (chargedWeapon != null) {
                this.setCharges(chargedWeapon, checkMessage.getChargesLeft(matcher));
                break;
            }
            if (this.lastUsedOnWeapon != null) {
                this.setCharges(this.lastUsedOnWeapon, checkMessage.getChargesLeft(matcher));
                if (!this.config.devMode()) break;
                log.info("applying charges to last used-on weapon: {}", (Object)this.lastUsedOnWeapon);
                break;
            }
            log.warn("saw check message without having seen a charged weapon checked or used: \"" + message + "\"");
            break;
        }
        for (ChargesMessage checkMessage : ChargedWeapon.getNonUniqueUpdateMessageChargesRegexes()) {
            matcher = checkMessage.getPattern().matcher(message);
            if (!matcher.find()) continue;
            int chargeCount = checkMessage.getChargesLeft(matcher);
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                ChargedWeapon equippedWeapon = this.getEquippedChargedWeapon(EquipmentInventorySlot.WEAPON);
                if (equippedWeapon != null) {
                    this.setCharges(equippedWeapon, chargeCount);
                } else {
                    log.warn("saw charge update message without a weapon being equipped: \"" + message + "\"");
                }
            });
            break;
        }
        block2: for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            Matcher matcher2;
            if (chargedWeapon.getCheckChargesRegexes().isEmpty()) continue;
            for (ChargesMessage checkMessage : chargedWeapon.getCheckChargesRegexes()) {
                matcher2 = checkMessage.getPattern().matcher(message);
                if (!matcher2.find()) continue;
                this.setCharges(chargedWeapon, checkMessage.getChargesLeft(matcher2));
                break block2;
            }
            for (ChargesMessage checkMessage : chargedWeapon.getUpdateMessageChargesRegexes()) {
                matcher2 = checkMessage.getPattern().matcher(message);
                if (!matcher2.find()) continue;
                this.delayChargeUpdateUntilAfterAnimations.add(() -> this.setCharges(chargedWeapon, checkMessage.getChargesLeft(matcher2)));
                break block2;
            }
        }
        this.chatMessageBlowpipe(message);
    }

    private ChargedWeapon removeLastWeaponChecked() {
        return !this.lastWeaponChecked2.isEmpty() ? this.lastWeaponChecked2.remove(0) : (!this.lastWeaponChecked.isEmpty() ? this.lastWeaponChecked.remove(0) : null);
    }

    private ChargedWeapon getEquippedChargedWeapon(EquipmentInventorySlot slot) {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (itemContainer == null) {
            return null;
        }
        Item item = itemContainer.getItem(slot.getSlotIdx());
        if (item == null) {
            return null;
        }
        return ChargedWeapon.getChargedWeaponFromId(item.getId());
    }

    private void chatMessageBlowpipe(String chatMsg) {
        Matcher matcher = DARTS_AND_SCALE_CHECK_PATTERN.matcher(chatMsg);
        if (matcher.find()) {
            this.setDartsLeft(Integer.parseInt(matcher.group(2).replace(",", "")));
            this.setScalesLeft(Integer.parseInt(matcher.group(3).replace(",", "")));
            this.setDartType(DartType.getDartTypeByName(matcher.group(1)));
        }
        if ((matcher = NO_DARTS_CHECK_PATTERN.matcher(chatMsg)).find()) {
            this.setDartsLeft(0.0f);
            this.setScalesLeft(Integer.parseInt(matcher.group(1).replace(",", "")));
            this.setDartType(DartType.UNKNOWN);
        }
        if ((matcher = USE_SCALES_ON_FULL_BLOWPIPE_PATTERN.matcher(chatMsg)).find()) {
            this.setScalesLeft(16383.0f);
        }
        if ((matcher = USE_DARTS_ON_FULL_BLOWPIPE_PATTERN.matcher(chatMsg)).find()) {
            this.setDartsLeft(16383.0f);
        }
        if ((matcher = UNLOAD_EMPTY_BLOWPIPE_PATTERN.matcher(chatMsg)).find()) {
            this.setDartsLeft(0.0f);
            this.setDartType(DartType.UNKNOWN);
        }
        if ((matcher = NO_DARTS_PATTERN.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                this.setDartsLeft(0.0f);
                this.setDartType(DartType.UNKNOWN);
            });
        }
        if ((matcher = NO_SCALES_PATTERN.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> this.setScalesLeft(0.0f));
        }
        if ((matcher = NO_DARTS_OR_SCALES_PATTERN.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                this.setScalesLeft(0.0f);
                this.setDartsLeft(0.0f);
                this.setDartType(DartType.UNKNOWN);
            });
        }
        if ((matcher = NO_DARTS_PATTERN_2.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                this.setDartsLeft(0.0f);
                this.setDartType(DartType.UNKNOWN);
            });
        }
        if ((matcher = NO_DARTS_OR_SCALES_PATTERN_2.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                this.setScalesLeft(0.0f);
                this.setDartsLeft(0.0f);
                this.setDartType(DartType.UNKNOWN);
            });
        }
    }

    @Subscribe(priority=10.0f)
    public void onAnimationChanged(AnimationChanged event) {
        Actor actor = event.getActor();
        if (actor != this.client.getLocalPlayer()) {
            return;
        }
        this.lastLocalPlayerAnimationChangedGameTick = this.client.getTickCount();
        this.lastLocalPlayerAnimationChanged = actor.getAnimation();
    }

    @Subscribe(priority=10.0f)
    public void onGraphicChanged(GraphicChanged event) {
        Actor actor = event.getActor();
        if (actor != this.client.getLocalPlayer()) {
            return;
        }
        this.lastLocalPlayerGraphicChangedGameTick = this.client.getTickCount();
        this.lastLocalPlayerGraphicChanged = actor.getGraphic();
    }

    @Subscribe(priority=10.0f)
    public void onProjectileMoved(ProjectileMoved event) {
        Projectile projectile = event.getProjectile();
        if (this.client.getGameCycle() >= projectile.getStartCycle()) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        WorldPoint playerPos = player.getWorldLocation();
        if (playerPos == null) {
            return;
        }
        LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerPos);
        if (playerPosLocal == null) {
            return;
        }
        if (projectile.getX1() != playerPosLocal.getX() || projectile.getY1() != playerPosLocal.getY()) {
            return;
        }
        int id = projectile.getId();
        if (id == 1122 || id == 1936 || id >= 226 && id <= 231) {
            this.checkBlowpipeGameTick = this.client.getTickCount();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.bloodFuryAppliedThisTick = false;
        this.checkAnimation(this.lastLocalPlayerAnimationChangedGameTick == this.client.getTickCount(), this.lastLocalPlayerGraphicChangedGameTick == this.client.getTickCount());
        if (this.lastLocalPlayerAnimationChanged == 5061 && this.checkBlowpipeGameTick == this.client.getTickCount() && this.client.getTickCount() >= this.blowpipeCooldownUp) {
            this.blowpipeCooldownUp = this.client.getTickCount() + this.client.getVarpValue(43) == 1 ? 2 : (3 + this.leaguesRelic() == 1 ? -1 : 0);
            this.consumeBlowpipeCharges();
        }
        if (!this.delayChargeUpdateUntilAfterAnimations.isEmpty()) {
            for (Runnable runnable : this.delayChargeUpdateUntilAfterAnimations) {
                runnable.run();
            }
            this.delayChargeUpdateUntilAfterAnimations.clear();
        }
        if (!this.lastWeaponChecked2.isEmpty()) {
            log.warn("checked weapons with no check message: " + this.lastWeaponChecked2);
        }
        this.lastWeaponChecked2.clear();
        this.lastWeaponChecked2 = this.lastWeaponChecked;
        this.lastWeaponChecked = new ArrayList<ChargedWeapon>();
    }

    private void checkAnimation(boolean checkAnimation, boolean checkGraphic) {
        if (!checkAnimation && !checkGraphic) {
            return;
        }
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (itemContainer == null) {
            return;
        }
        Item weapon = itemContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx());
        int weaponItemId = weapon == null ? -1 : weapon.getId();
        Item offhand = itemContainer.getItem(EquipmentInventorySlot.SHIELD.getSlotIdx());
        int offhandItemId = offhand == null ? -1 : offhand.getId();
        int relic = this.leaguesRelic();
        for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            boolean isLeagueAffected;
            if (!chargedWeapon.getItemIds().contains(weaponItemId) && !chargedWeapon.getItemIds().contains(offhandItemId)) continue;
            boolean bl = isLeagueAffected = chargedWeapon.leaguesRelicType == relic;
            if (isLeagueAffected && chargedWeapon.leaguesAnimationIssue || (!checkAnimation || !chargedWeapon.animationIds.contains(this.lastLocalPlayerAnimationChanged)) && (!checkGraphic || !chargedWeapon.graphicIds.contains(this.lastLocalPlayerGraphicChanged))) continue;
            this.addCharges(chargedWeapon, isLeagueAffected ? -0.1f : -1.0f, false);
        }
    }

    public int leaguesRelic() {
        return this.client.getVarbitValue(10052);
    }

    private void consumeBlowpipeCharges() {
        float leaguesMultiplier = this.leaguesRelic() == 1 ? 0.1f : 1.0f;
        this.addDartsLeft(leaguesMultiplier * -1.0f * this.getAmmoLossChance(), false);
        this.addScalesLeft(leaguesMultiplier * -2.0f / 3.0f, false);
    }

    private float getAmmoLossChance() {
        int attractorEquippedId = this.client.getLocalPlayer().getPlayerComposition().getEquipmentId(KitType.CAPE);
        switch (attractorEquippedId) {
            case 10498: {
                return 0.4f;
            }
            case 10499: 
            case 13337: {
                return 0.28f;
            }
            case 9756: 
            case 9757: 
            case 13280: {
                boolean vorkathsHeadUsed = Boolean.valueOf(this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, "vorkathsHeadUsed"));
                return vorkathsHeadUsed ? 0.2f : 0.28f;
            }
            case 21898: 
            case 22109: 
            case 24135: 
            case 24222: 
            case 27363: 
            case 27365: 
            case 27374: 
            case 27376: {
                return 0.2f;
            }
        }
        return 1.0f;
    }

    public Float getCharges(ChargedWeapon weapon) {
        String configString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, weapon.configKeyName);
        if (configString == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(configString));
    }

    public void setCharges(ChargedWeapon weapon, int charges) {
        this.setCharges(weapon, charges, true);
    }

    public void setCharges(ChargedWeapon weapon, float charges, boolean logChange) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, weapon.configKeyName, (Object)Float.valueOf(Math.max(charges, 0.0f)));
        if (logChange) {
            log.info("set charges for " + weapon + " to " + charges + " (" + this.configManager.getRSProfileKey() + ")");
        }
    }

    public void addCharges(ChargedWeapon weapon, float change, boolean logChange) {
        Float charges = this.getCharges(weapon);
        this.setCharges(weapon, (charges == null ? 0.0f : charges.floatValue()) + change, logChange);
    }

    public Float getDartsLeft() {
        String configString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeDarts");
        if (configString == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(configString));
    }

    void setDartsLeft(float dartsLeft) {
        this.setDartsLeft(dartsLeft, true);
    }

    private void setDartsLeft(float dartsLeft, boolean logChange) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeDarts", (Object)Float.valueOf(dartsLeft));
        if (logChange) {
            log.info("set darts left to " + dartsLeft + " (" + this.configManager.getRSProfileKey() + ")");
        }
    }

    private void addDartsLeft(float change, boolean logChange) {
        Float dartsLeft = this.getDartsLeft();
        this.setDartsLeft((dartsLeft == null ? 0.0f : dartsLeft.floatValue()) + change, logChange);
    }

    public DartType getDartType() {
        String configString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeDartType");
        if (configString == null) {
            return DartType.UNKNOWN;
        }
        return DartType.valueOf(configString);
    }

    void setDartType(DartType dartType) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeDartType", (Object)dartType);
        log.info("set dart type to " + dartType + " (" + this.configManager.getRSProfileKey() + ")");
    }

    public Float getScalesLeft() {
        String configString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeScales");
        if (configString == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(configString));
    }

    void setScalesLeft(float scalesLeft) {
        this.setScalesLeft(scalesLeft, true);
    }

    private void setScalesLeft(float scalesLeft, boolean logChange) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeScales", (Object)Float.valueOf(scalesLeft));
        if (logChange) {
            log.info("set scales left to " + scalesLeft + " (" + this.configManager.getRSProfileKey() + ")");
        }
    }

    private void addScalesLeft(float change, boolean logChange) {
        Float scalesLeft = this.getScalesLeft();
        this.setScalesLeft((scalesLeft == null ? 0.0f : scalesLeft.floatValue()) + change, logChange);
    }

    public void keyPressed(KeyEvent e) {
        if (this.config.showOnHotkey().matches(e)) {
            this.showChargesKeyIsDown = true;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.config.showOnHotkey().matches(e)) {
            this.showChargesKeyIsDown = false;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.showChargesKeyIsDown = false;
        }
    }

    public void onMenuOpened2() {
        if (!this.client.isKeyPressed(81) || this.config.hideShiftRightClickOptions()) {
            return;
        }
        MenuEntry[] entries = this.client.getMenuEntries();
        block0: for (int i = 0; i < entries.length; ++i) {
            int itemId;
            MenuEntry entry = entries[i];
            Widget w = entry.getWidget();
            if (w != null && WidgetUtil.componentToInterface((int)w.getId()) == 149 && "Examine".equals(entry.getOption()) && entry.getIdentifier() == 10) {
                itemId = entry.getItemId();
            } else {
                if (w == null || WidgetUtil.componentToInterface((int)w.getId()) != 387 || !"Examine".equals(entry.getOption()) || entry.getIdentifier() != 10) continue;
                w = w.getChild(1);
                itemId = w.getItemId();
            }
            for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
                if (!chargedWeapon.getItemIds().contains(itemId) && !chargedWeapon.getUnchargedIds().contains(itemId)) continue;
                MenuEntry submenuEntry = this.client.createMenuEntry(1).setOption("Weapon charges plugin").setType(MenuAction.RUNELITE_SUBMENU);
                this.addSubmenu("Set low charge threshold (" + chargedWeapon.getLowCharge(this.configManager) + ")", e -> this.openChangeLowChargeDialog(chargedWeapon, chargedWeapon.getLowCharge(this.configManager)), submenuEntry);
                this.addSubmenu(ColorUtil.wrapWithColorTag((String)"Show charge count on item", (Color)Color.decode("#ff9040")), submenuEntry);
                WeaponChargesConfig.DisplayWhen displayWhen = chargedWeapon.getDisplayWhen(this.configManager);
                this.addSubmenuRadioButtonStyle(displayWhen == WeaponChargesConfig.DisplayWhen.USE_DEFAULT, "Use default settings", e -> chargedWeapon.setDisplayWhen(this.configManager, WeaponChargesConfig.DisplayWhen.USE_DEFAULT), submenuEntry);
                this.addSubmenuRadioButtonStyle(displayWhen == WeaponChargesConfig.DisplayWhen.LOW_CHARGE, "When low", e -> chargedWeapon.setDisplayWhen(this.configManager, WeaponChargesConfig.DisplayWhen.LOW_CHARGE), submenuEntry);
                this.addSubmenuRadioButtonStyle(displayWhen == WeaponChargesConfig.DisplayWhen.ALWAYS, "Always", e -> chargedWeapon.setDisplayWhen(this.configManager, WeaponChargesConfig.DisplayWhen.ALWAYS), submenuEntry);
                this.addSubmenuRadioButtonStyle(displayWhen == WeaponChargesConfig.DisplayWhen.NEVER, "Never", e -> chargedWeapon.setDisplayWhen(this.configManager, WeaponChargesConfig.DisplayWhen.NEVER), submenuEntry);
                if (chargedWeapon != ChargedWeapon.SERPENTINE_HELM) continue block0;
                this.addSubmenu(ColorUtil.wrapWithColorTag((String)"Display style", (Color)Color.decode("#ff9040")), submenuEntry);
                WeaponChargesConfig.SerpModes serpMode = this.getSerpHelmDisplayStyle();
                this.addSubmenuRadioButtonStyle(serpMode == WeaponChargesConfig.SerpModes.PERCENT, "Percent", e -> this.setSerpHelmDisplayStyle(WeaponChargesConfig.SerpModes.PERCENT), submenuEntry);
                this.addSubmenuRadioButtonStyle(serpMode == WeaponChargesConfig.SerpModes.SCALES, "Scales", e -> this.setSerpHelmDisplayStyle(WeaponChargesConfig.SerpModes.SCALES), submenuEntry);
                this.addSubmenuRadioButtonStyle(serpMode == WeaponChargesConfig.SerpModes.BOTH, "Both", e -> this.setSerpHelmDisplayStyle(WeaponChargesConfig.SerpModes.BOTH), submenuEntry);
                continue block0;
            }
        }
    }

    public void setSerpHelmDisplayStyle(WeaponChargesConfig.SerpModes percent) {
        this.configManager.setConfiguration(CONFIG_GROUP_NAME, "serpentine_helm_display_style", (Object)percent);
    }

    public WeaponChargesConfig.SerpModes getSerpHelmDisplayStyle() {
        String serpentine_helm_display_style = this.configManager.getConfiguration(CONFIG_GROUP_NAME, "serpentine_helm_display_style");
        try {
            return WeaponChargesConfig.SerpModes.valueOf(serpentine_helm_display_style);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return WeaponChargesConfig.SerpModes.PERCENT;
        }
    }

    private void openChangeLowChargeDialog(ChargedWeapon chargedWeapon, int currentLowCharge) {
        this.chatboxPanelManager.openTextInput("Set low charge threshold for " + chargedWeapon.getName() + ", (currently " + currentLowCharge + "):").addCharValidator(c -> "-0123456789".indexOf(c) != -1).onDone(input -> this.clientThread.invoke(() -> {
            int newLowChargeThreshold;
            try {
                newLowChargeThreshold = Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("\"" + input + "\" is not a number.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
                return;
            }
            chargedWeapon.setLowCharge(this.configManager, newLowChargeThreshold);
        })).build();
    }

    private void addSubmenu(String option, MenuEntry submenuEntry) {
        this.addSubmenu(option, e -> {}, submenuEntry);
    }

    private void addSubmenuRadioButtonStyle(boolean selected, String option, Consumer<MenuEntry> callback, MenuEntry submenuEntry) {
        this.addSubmenu("(" + (selected ? "x" : "  ") + ") " + option, callback, submenuEntry);
    }

    private void addSubmenu(String option, Consumer<MenuEntry> callback, MenuEntry submenuEntry) {
        this.client.createMenuEntry(0).setOption(option).setType(MenuAction.RUNELITE).onClick(callback).setParent(submenuEntry);
    }

    @Subscribe
    public void onStatChanged(StatChanged e) {
        Skill skill = e.getSkill();
        if (!this.bloodFuryAppliedThisTick && (skill == Skill.ATTACK || skill == Skill.STRENGTH || skill == Skill.DEFENCE && this.MELEE_ATTACK_ANIMATIONS.contains(this.client.getLocalPlayer().getAnimation())) && this.getEquippedChargedWeapon(EquipmentInventorySlot.AMULET) == ChargedWeapon.BLOOD_FURY && this.leaguesRelic() != 2) {
            this.bloodFuryAppliedThisTick = true;
            if (this.client.getLocalPlayer().getAnimation() == 8056) {
                this.checkScytheHitsplats = this.client.getTickCount() + 1;
                this.scytheHitsplatsSeen = 0;
            }
            this.addCharges(ChargedWeapon.BLOOD_FURY, -1.0f, false);
        }
    }

    public boolean isShowChargesKeyIsDown() {
        return this.showChargesKeyIsDown;
    }

    public static enum DartType {
        UNKNOWN(-1, Color.LIGHT_GRAY, null),
        BRONZE(806, new Color(7231271), "bronze"),
        IRON(807, new Color(5394508), "iron"),
        STEEL(808, new Color(8026227), "steel"),
        MITHRIL(809, new Color(4280184), "mithril"),
        ADAMANT(810, new Color(4290642), "adamant"),
        RUNE(811, new Color(6807797), "rune"),
        AMETHYST(25849, new Color(13139412), "amethyst"),
        DRAGON(11230, new Color(4094071), "dragon");

        public final int itemId;
        public final Color displayColor;
        public final String checkBlowpipeMessageName;

        public static DartType getDartTypeByName(String group) {
            group = group.toLowerCase();
            for (DartType dartType : DartType.values()) {
                if (dartType.checkBlowpipeMessageName == null || !dartType.checkBlowpipeMessageName.equals(group)) continue;
                return dartType;
            }
            return null;
        }

        private DartType(int itemId, Color displayColor, String checkBlowpipeMessageName) {
            this.itemId = itemId;
            this.displayColor = displayColor;
            this.checkBlowpipeMessageName = checkBlowpipeMessageName;
        }
    }
}

