/*
 * Decompiled with CFR 0.152.
 */
package com.weaponcharges;

import com.weaponcharges.ChargedWeapon;
import com.weaponcharges.WeaponChargesConfig;
import com.weaponcharges.WeaponChargesPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

public class WeaponChargesItemOverlay
extends WidgetItemOverlay {
    private final WeaponChargesPlugin plugin;
    private final WeaponChargesConfig config;

    @Inject
    WeaponChargesItemOverlay(WeaponChargesPlugin plugin, WeaponChargesConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
        this.showOnEquipment();
        this.showOnBank();
        this.showOnInterfaces(new int[]{551});
        this.showOnInterfaces(new int[]{271});
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            Integer charges;
            if (chargedWeapon.getItemIds().contains(itemId)) {
                Float c = this.plugin.getCharges(chargedWeapon);
                charges = c == null ? null : Integer.valueOf((int)c.floatValue());
            } else {
                if (!chargedWeapon.getUnchargedIds().contains(itemId)) continue;
                charges = 0;
            }
            graphics.setFont(FontManager.getRunescapeSmallFont());
            Rectangle bounds = itemWidget.getCanvasBounds();
            TextComponent topText = new TextComponent();
            topText.setPosition(new Point(bounds.x - 1, bounds.y + 10));
            topText.setText("");
            topText.setColor(this.config.chargesTextRegularColor());
            TextComponent bottomText = new TextComponent();
            bottomText.setPosition(new Point(bounds.x - 1, bounds.y + 30));
            bottomText.setText("");
            bottomText.setColor(this.config.chargesTextRegularColor());
            if (chargedWeapon != ChargedWeapon.TOXIC_BLOWPIPE) {
                if (charges == null) {
                    topText.setText("?");
                } else {
                    boolean isLowCharge;
                    WeaponChargesConfig.DisplayWhen displayWhen = WeaponChargesConfig.DisplayWhenNoDefault.getDisplayWhen(chargedWeapon.getDisplayWhen(this.plugin.configManager), this.config.defaultDisplay());
                    if (displayWhen == WeaponChargesConfig.DisplayWhen.NEVER && !this.plugin.isShowChargesKeyIsDown()) break;
                    boolean bl = isLowCharge = charges <= chargedWeapon.getLowCharge(this.plugin.configManager);
                    if (!isLowCharge && displayWhen == WeaponChargesConfig.DisplayWhen.LOW_CHARGE && !this.plugin.isShowChargesKeyIsDown()) break;
                    if (charges == 0 && this.config.emptyNotZero()) {
                        topText.setText("Empty");
                    } else if (chargedWeapon != ChargedWeapon.SERPENTINE_HELM) {
                        String prefix = chargedWeapon.leaguesRelicType == this.plugin.leaguesRelic() && chargedWeapon.leaguesAnimationIssue ? "~" : "";
                        topText.setText(prefix + (Serializable)(charges >= 10000 ? charges / 1000 + "k" : charges));
                    } else {
                        String scalesLeftPercentDisplay = WeaponChargesItemOverlay.formatPercentage(charges, ChargedWeapon.SERPENTINE_HELM.rechargeAmount);
                        WeaponChargesConfig.SerpModes displayStyle = this.plugin.getSerpHelmDisplayStyle();
                        if (displayStyle == WeaponChargesConfig.SerpModes.PERCENT) {
                            topText.setText(scalesLeftPercentDisplay);
                        } else if (displayStyle == WeaponChargesConfig.SerpModes.BOTH) {
                            topText.setText(charges.toString());
                            bottomText.setText(scalesLeftPercentDisplay);
                            if (isLowCharge) {
                                bottomText.setColor(this.config.chargesTextLowColor());
                            }
                        }
                    }
                    if (isLowCharge) {
                        topText.setColor(this.config.chargesTextLowColor());
                    }
                }
            } else {
                WeaponChargesConfig.DisplayWhen displayWhen = WeaponChargesConfig.DisplayWhenNoDefault.getDisplayWhen(ChargedWeapon.TOXIC_BLOWPIPE.getDisplayWhen(this.plugin.configManager), this.config.defaultDisplay());
                Float dartsLeft1 = this.plugin.getDartsLeft();
                Float scalesLeft = this.plugin.getScalesLeft();
                if (dartsLeft1 == null || scalesLeft == null) {
                    topText.setText("?");
                } else {
                    int dartsLeft;
                    if (displayWhen == WeaponChargesConfig.DisplayWhen.NEVER && !this.plugin.isShowChargesKeyIsDown()) {
                        return;
                    }
                    boolean isLowCharge = this.blowpipeChargesLow(scalesLeft.floatValue(), dartsLeft1.floatValue());
                    if (!isLowCharge && displayWhen == WeaponChargesConfig.DisplayWhen.LOW_CHARGE && !this.plugin.isShowChargesKeyIsDown()) {
                        return;
                    }
                    Object dartsString = dartsLeft1 == null ? "?" : ((dartsLeft = (int)dartsLeft1.floatValue()) > 9999 ? new DecimalFormat("#0").format((double)dartsLeft / 1000.0) + "k" : (dartsLeft < 1000 ? String.valueOf(dartsLeft) : new DecimalFormat("#0.0").format((double)dartsLeft / 1000.0) + "k"));
                    bottomText.setText((String)dartsString);
                    int stringLength = graphics.getFontMetrics().stringWidth((String)dartsString);
                    bottomText.setPosition(new Point(bounds.x - 1 + 30 - stringLength, bounds.y + 30));
                    WeaponChargesPlugin.DartType dartType = this.plugin.getDartType();
                    if (dartType == null) {
                        bottomText.setText("");
                    } else {
                        bottomText.setColor(dartType.displayColor);
                    }
                    if (scalesLeft == null) {
                        topText.setText("??.?%");
                    } else {
                        String scalesLeftPercentDisplay = WeaponChargesItemOverlay.formatPercentage(Math.round(scalesLeft.floatValue()), 16383);
                        topText.setText(scalesLeftPercentDisplay);
                        if (this.blowpipeChargesLow(scalesLeft.floatValue(), dartsLeft1.floatValue())) {
                            topText.setColor(this.config.chargesTextLowColor());
                        }
                    }
                }
            }
            topText.render(graphics);
            bottomText.render(graphics);
            return;
        }
    }

    static String formatPercentage(int numerator, int denominator) {
        DecimalFormat df = new DecimalFormat("##0.0");
        ((NumberFormat)df).setRoundingMode(RoundingMode.DOWN);
        float scalesLeftPercent = (float)numerator / (float)denominator;
        String percentage = df.format(scalesLeftPercent * 100.0f);
        if (percentage.equals("0.0") && numerator > 0) {
            percentage = "0.1";
        }
        return percentage + "%";
    }

    private boolean blowpipeChargesLow(float scalesLeft, float dartsLeft) {
        int lowCharges = ChargedWeapon.TOXIC_BLOWPIPE.getLowCharge(this.plugin.configManager);
        int scaleCharges = (int)(scalesLeft * 1.5f);
        int dartCharges = (int)(dartsLeft * 5.0f);
        return scaleCharges <= lowCharges || dartCharges <= lowCharges;
    }

    private Color getColorForScalesLeft(float scalesLeftPercent) {
        return Color.getHSBColor(scalesLeftPercent * 1.0f / 3.0f, 1.0f, 1.0f);
    }
}

