/*
 * Decompiled with CFR 0.152.
 */
package com.weaponcharges;

import com.weaponcharges.ChargedWeapon;
import com.weaponcharges.DialogStateMatcher;
import com.weaponcharges.DialogTracker;
import com.weaponcharges.WeaponChargesPlugin;

public final class ChargesDialogHandler {
    private final DialogStateMatcher dialogStateMatcher;
    private final MatchHandler matchHandler;

    public boolean handleDialog(DialogTracker.DialogState dialogState, WeaponChargesPlugin plugin) {
        boolean matched;
        DialogStateMatcher.DialogStateMatchers matchers = this.dialogStateMatcher.matchDialog(dialogState);
        boolean bl = matched = matchers != null;
        if (matched) {
            this.matchHandler.handleDialog(matchers, dialogState, null, plugin);
        }
        return matched;
    }

    public boolean handleDialogOptionSelected(DialogTracker.DialogState dialogState, String optionSelected, WeaponChargesPlugin plugin) {
        boolean matched;
        DialogStateMatcher.DialogStateMatchers matchers = this.dialogStateMatcher.matchDialogOptionSelected(dialogState, optionSelected);
        boolean bl = matched = matchers != null;
        if (matched) {
            this.matchHandler.handleDialog(matchers, dialogState, optionSelected, plugin);
        }
        return matched;
    }

    public static MatchHandler genericSpriteDialogChargesMessage(boolean chargesAbsolute, int group) {
        return (matchers, dialogState, optionSelected, plugin) -> {
            if (dialogState.spriteDialogItemId == null) {
                throw new IllegalArgumentException("This handler is for sprite dialogs only.");
            }
            String chargeCountString = matchers.getTextMatcher().group(group).replaceAll(",", "");
            int charges = Integer.parseInt(chargeCountString);
            ChargedWeapon chargedWeapon = ChargedWeapon.getChargedWeaponFromId(matchers.getSpriteDialogId());
            if (chargedWeapon != null) {
                if (chargesAbsolute) {
                    plugin.setCharges(chargedWeapon, charges);
                } else {
                    plugin.addCharges(chargedWeapon, charges, true);
                }
            }
        };
    }

    public static MatchHandler genericSpriteDialogUnchargeMessage() {
        return (matchers, dialogState, optionSelected, plugin) -> {
            if (dialogState.spriteDialogItemId == null) {
                throw new IllegalArgumentException("This handler is for sprite dialogs only.");
            }
            ChargedWeapon chargedWeapon = ChargedWeapon.getChargedWeaponFromId(matchers.getSpriteDialogId());
            if (chargedWeapon != null) {
                plugin.setCharges(chargedWeapon, 0);
            }
        };
    }

    public static MatchHandler genericSpriteDialogFullChargeMessage() {
        return (matchers, dialogState, optionSelected, plugin) -> {
            if (dialogState.spriteDialogItemId == null) {
                throw new IllegalArgumentException("This handler is for sprite dialogs only.");
            }
            ChargedWeapon chargedWeapon = ChargedWeapon.getChargedWeaponFromId(matchers.getSpriteDialogId());
            if (chargedWeapon != null) {
                plugin.setCharges(chargedWeapon, chargedWeapon.getRechargeAmount());
            }
        };
    }

    public static MatchHandler genericInputChargeMessage() {
        return ChargesDialogHandler.genericInputChargeMessage(1);
    }

    public static MatchHandler genericInputChargeMessage(int multiplier) {
        return (matchers, dialogState, optionSelected, plugin) -> {
            int chargesEntered;
            if (plugin.lastUsedOnWeapon == null) {
                return;
            }
            String chargeCountString = matchers.getNameMatcher().group(1).replaceAll(",", "");
            int maxChargeCount = Integer.parseInt(chargeCountString);
            try {
                chargesEntered = Integer.parseInt(optionSelected.replaceAll("k", "000").replaceAll("m", "000000").replaceAll("b", "000000000"));
            }
            catch (NumberFormatException e) {
                return;
            }
            if (chargesEntered > maxChargeCount) {
                chargesEntered = maxChargeCount;
            }
            plugin.addCharges(plugin.lastUsedOnWeapon, chargesEntered * multiplier, true);
        };
    }

    public static MatchHandler genericUnchargeDialog() {
        return (matchers, dialogState, optionSelected, plugin) -> plugin.setCharges(plugin.lastUnchargeClickedWeapon, 0.0f, true);
    }

    public ChargesDialogHandler(DialogStateMatcher dialogStateMatcher, MatchHandler matchHandler) {
        this.dialogStateMatcher = dialogStateMatcher;
        this.matchHandler = matchHandler;
    }

    @FunctionalInterface
    public static interface MatchHandler {
        public void handleDialog(DialogStateMatcher.DialogStateMatchers var1, DialogTracker.DialogState var2, String var3, WeaponChargesPlugin var4);
    }
}

