/*
 * Decompiled with CFR 0.152.
 */
package com.weaponcharges;

import com.weaponcharges.ChargesDialogHandler;
import com.weaponcharges.ChargesMessage;
import com.weaponcharges.DialogStateMatcher;
import com.weaponcharges.WeaponChargesConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.util.Text;

public enum ChargedWeapon {
    IBANS_STAFF(new ChargedWeaponBuilder().chargedItemIds(1409, 12658).graphicIds(87).name("Iban's staff").rechargeAmount(2500).defaultLowChargeThreshold(250).configKeyName("ibans_staff").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("You have ([\\d,]+) charges left on the staff.", 1), ChargesMessage.staticChargeMessage("You have a charge left on the staff.", 1), ChargesMessage.staticChargeMessage("You have no charges left on the staff.", 0)).updateMessageChargesRegexes(ChargesMessage.matcherGroupChargeMessage(Text.removeTags((String)"<col=ef1020>Your staff only has ([\\d,]+) charges left.</col>"), 1), ChargesMessage.staticChargeMessage(Text.removeTags((String)"<col=ef1020>Your staff has run out of charges.</col>"), 0), ChargesMessage.staticChargeMessage("You need to recharge your staff to use this spell.", 0)).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You hold the staff above the well and feel the power of Zamorak flow through you."), null), ChargesDialogHandler.genericSpriteDialogFullChargeMessage())).leaguesMageRelic().leaguesAnimationIssue(false)),
    TRIDENT_OF_THE_SEAS(new ChargedWeaponBuilder().chargedItemIds(11907).unchargedItemIds(11908).animationIds(1167).name("Trident of the seas").rechargeAmount(2500).configKeyName("trident_of_the_seas").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your Trident of the seas has ([\\d,]+) charges.", 1), ChargesMessage.staticChargeMessage("Your Trident of the seas has one charge.", 1), ChargesMessage.staticChargeMessage("Your Trident of the seas has no charges.", 0)).leaguesMageRelic().leaguesAnimationIssue(false)),
    TRIDENT_OF_THE_SWAMP(new ChargedWeaponBuilder().chargedItemIds(12899).unchargedItemIds(12900).animationIds(1167).name("Trident of the swamp").rechargeAmount(2500).configKeyName("trident_of_the_swamp").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your Trident of the swamp has ([\\d,]+) charges.", 1), ChargesMessage.staticChargeMessage("Your Trident of the swamp has one charge.", 1), ChargesMessage.staticChargeMessage("Your Trident of the swamp has no charges.", 0)).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.optionsOptionSelected(Pattern.compile("Really uncharge the Trident of the swamp?"), null, Pattern.compile("Okay, uncharge it.")), ChargesDialogHandler.genericUnchargeDialog())).leaguesMageRelic().leaguesAnimationIssue(false)),
    TRIDENT_OF_THE_SEAS_E(new ChargedWeaponBuilder().chargedItemIds(22288).unchargedItemIds(22290).animationIds(1167).name("Trident of the seas (e)").rechargeAmount(10000).configKeyName("trident_of_the_seas_e").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your Trident of the seas \\(e\\) has ([\\d,]+) charges.", 1), ChargesMessage.staticChargeMessage("Your Trident of the seas \\(e\\) has one charge.", 1), ChargesMessage.staticChargeMessage("Your Trident of the seas \\(e\\) has no charges.", 0)).leaguesMageRelic().leaguesAnimationIssue(false)),
    TRIDENT_OF_THE_SWAMP_E(new ChargedWeaponBuilder().chargedItemIds(22292).unchargedItemIds(22294).animationIds(1167).name("Trident of the swamp (e)").rechargeAmount(10000).configKeyName("trident_of_the_swamp_e").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your Trident of the swamp \\(e\\) has ([\\d,]+) charges.", 1), ChargesMessage.staticChargeMessage("Your Trident of the swamp \\(e\\) has one charge.", 1), ChargesMessage.staticChargeMessage("Your Trident of the swamp \\(e\\) has no charges.", 0)).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.optionsOptionSelected(Pattern.compile("Really uncharge the Trident of the swamp (e)?"), null, Pattern.compile("Okay, uncharge it.")), ChargesDialogHandler.genericUnchargeDialog())).leaguesMageRelic().leaguesAnimationIssue(false)),
    WARPED_SCEPTRE(new ChargedWeaponBuilder().chargedItemIds(28585).unchargedItemIds(28583).animationIds(10501).name("Warped sceptre").rechargeAmount(20000).configKeyName("warped_sceptre").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your warped sceptre has ([\\d,]+) charges remaining\\.", 1), ChargesMessage.staticChargeMessage("Your warped sceptre has 1 charge remaining\\.", 1), ChargesMessage.staticChargeMessage(Text.removeTags((String)"<col=ff0000>Your warped sceptre has run out of charges!</col>"), 0)).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.optionsOptionSelected(Pattern.compile("Fully uncharge your warped sceptre\\?"), null, Pattern.compile("Yes\\.")), ChargesDialogHandler.genericUnchargeDialog()), new ChargesDialogHandler(DialogStateMatcher.inputOptionSelected(Pattern.compile("How many charges do you want to add\\? \\(0 - ([\\d,]+)\\)"), null), ChargesDialogHandler.genericInputChargeMessage()), new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You add ([\\d,]+) charges? to your warped sceptre\\."), null), ChargesDialogHandler.genericSpriteDialogChargesMessage(true, 1)), new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You add an additional ([\\d,]+) charges to your warped sceptre\\. It now has ([\\d,]+) charges in total\\."), null), ChargesDialogHandler.genericSpriteDialogChargesMessage(true, 2))).leaguesMageRelic().leaguesAnimationIssue(true)),
    ABYSSAL_TENTACLE(new ChargedWeaponBuilder().chargedItemIds(12006, 26484).animationIds(1658).name("Abyssal tentacle").rechargeAmount(10000).configKeyName("abyssal_tentacle").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your abyssal tentacle can perform ([\\d,]+) more attacks.", 1)).leaguesMeleeRelic().leaguesAnimationIssue(false)),
    CRYSTAL_HALBERD(new ChargedWeaponBuilder().chargedItemIds(23987).unchargedItemIds(new Integer[0]).animationIds(428, 440, 1203).name("Crystal halberd").rechargeAmount(10000).defaultLowChargeThreshold(25).configKeyName("crystal_halberd").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your crystal halberd has ([\\d,]+) charges remaining.", 1)).leaguesMeleeRelic().leaguesAnimationIssue(false)),
    TOME_OF_FIRE(new ChargedWeaponBuilder().chargedItemIds(20714).unchargedItemIds(20716).graphicIds(99, 126, 129, 155, 1464).name("Tome of fire").rechargeAmount(20000).configKeyName("tome_of_fire").updateMessageChargesRegexes(ChargesMessage.staticChargeMessage("Your Tome of Fire is now empty.", 0))),
    TOME_OF_WATER(new ChargedWeaponBuilder().chargedItemIds(25574).unchargedItemIds(25576).graphicIds(177, 102, 105, 108, 167, 170, 173, 93, 120, 135, 161, 1458).name("Tome of water").rechargeAmount(20000).configKeyName("tome_of_water").updateMessageChargesRegexes(ChargesMessage.staticChargeMessage("Your Tome of Water is now empty.", 0))),
    SCYTHE_OF_VITUR(new ChargedWeaponBuilder().chargedItemIds(22325, 25736, 25739).unchargedItemIds(22486, 25738, 25741).animationIds(8056).name("Scythe of vitur").rechargeAmount(20000).configKeyName("scythe_of_vitur").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your (Sanguine s|Holy s|S)cythe of vitur has ([\\d,]+) charges remaining.", 2)).updateMessageChargesRegexes(new ChargesMessage[0]).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.inputOptionSelected(Pattern.compile("How many sets of 100 charges do you wish to apply\\? \\(Up to ([\\d,]+)\\)"), null), (matchers, dialogState, optionSelected, plugin) -> {
        int chargesEntered;
        String chargeCountString = matchers.getNameMatcher().group(1).replaceAll(",", "");
        int maxChargeCount = Integer.parseInt(chargeCountString);
        try {
            chargesEntered = Integer.parseInt(optionSelected.replaceAll("k", "000").replaceAll("m", "000000").replaceAll("b", "000000000"));
        }
        catch (NumberFormatException e) {
            return;
        }
        if (chargesEntered > maxChargeCount) {
            chargesEntered = maxChargeCount;
        }
        plugin.addCharges(ChargedWeapon.get_scythe_circumvent_illegal_self_reference(), chargesEntered * 100, true);
    }), new ChargesDialogHandler(DialogStateMatcher.spriteOptionSelected(Pattern.compile("If you uncharge your scythe into the well, ([\\d,]+) charges will be added to the well."), null), ChargesDialogHandler.genericSpriteDialogUnchargeMessage())).leaguesMeleeRelic().leaguesAnimationIssue(true)),
    BLOOD_FURY(new ChargedWeaponBuilder().chargedItemIds(24780).name("Amulet of blood fury").rechargeAmount(10000).configKeyName("amulet_of_blood_fury").checkChargesRegexes(ChargesMessage.staticChargeMessage("You have successfully created an Amulet of blood fury.", 10000), ChargesMessage.matcherGroupChargeMessage("Your Amulet of blood fury will work for ([\\d,]+) more hits.", 1)).updateMessageChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your Amulet of blood fury can perform ([\\d,]+) more hits.", 1))),
    SANGUINESTI_STAFF(new ChargedWeaponBuilder().chargedItemIds(22323, 25731).unchargedItemIds(22481, 25733).animationIds(1167).name("Sanguinesti staff").rechargeAmount(20000).configKeyName("sanguinesti_staff").checkChargesRegexes(ChargesMessage.staticChargeMessage("Your (Holy s|S)anguinesti staff is already fully charged.", 20000)).updateMessageChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your (Holy s|S)anguinesti staff has ([\\d,]+) charges remaining.", 2), ChargesMessage.matcherGroupChargeMessage(Text.removeTags((String)"<col=ef1020>Your (Holy s|S)anguinesti staff only has ([\\d,]+) charges left!</col>"), 2), ChargesMessage.staticChargeMessage("Your (Holy s|S)anguinesti staff has run out of charges.", 0)).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.optionsOptionSelected(Pattern.compile("Uncharge your staff for all its charges\\? \\(regaining [\\d,]+ blood runes\\)"), null, Pattern.compile("Proceed.")), ChargesDialogHandler.genericUnchargeDialog()), new ChargesDialogHandler(DialogStateMatcher.inputOptionSelected(Pattern.compile("How many charges do you want to apply\\? \\(Up to ([\\d,]+)\\)"), null), ChargesDialogHandler.genericInputChargeMessage()), new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You apply ([\\d,]+) charges to your (Holy s|S)anguinesti staff."), null), ChargesDialogHandler.genericSpriteDialogChargesMessage(true, 1)), new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You apply an additional ([\\d,]+) charges to your (Holy s|S)anguinesti staff. It now has ([\\d,]+) charges in total."), null), ChargesDialogHandler.genericSpriteDialogChargesMessage(true, 3))).leaguesMageRelic().leaguesAnimationIssue(false)),
    ARCLIGHT(new ChargedWeaponBuilder().chargedItemIds(19675).animationIds(386, 390).name("Arclight").rechargeAmount(10000).configKeyName("arclight").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your arclight has ([\\d,]+) charges left.", 1)).leaguesMeleeRelic().leaguesAnimationIssue(true)),
    CRAWS(new ChargedWeaponBuilder().chargedItemIds(22550).unchargedItemIds(22547).animationIds(426).name("Craw's bow").rechargeAmount(16000).configKeyName("craws_bow").leaguesRangeRelic().leaguesAnimationIssue(false)),
    WEBWEAVER(new ChargedWeaponBuilder().chargedItemIds(27655).unchargedItemIds(27652).name("Webweaver bow").animationIds(426, 9964).rechargeAmount(16000).configKeyName("webweaver_bow").settingsConfigKey("craws_bow").leaguesRangeRelic().leaguesAnimationIssue(false)),
    VIGGORAS(new ChargedWeaponBuilder().chargedItemIds(22545).unchargedItemIds(22542).animationIds(245, 9963).name("Viggora's chainmace").rechargeAmount(16000).configKeyName("viggoras_chainmace").leaguesMeleeRelic().leaguesAnimationIssue(false)),
    URSINE(new ChargedWeaponBuilder().chargedItemIds(27660).unchargedItemIds(27657).name("Ursine chainmace").animationIds(245, 9963).rechargeAmount(16000).configKeyName("ursine_chainmace").settingsConfigKey("viggoras_chainmace").leaguesMeleeRelic().leaguesAnimationIssue(false)),
    THAMMARONS(new ChargedWeaponBuilder().chargedItemIds(22555, 27788).unchargedItemIds(22552, 27785).name("Thammaron's sceptre").animationIds(1167, 1978, 1979, 1162, 1167, 7855, 811, 9961).rechargeAmount(16000).configKeyName("thammarons_sceptre").leaguesMageRelic().leaguesAnimationIssue(true)),
    ACCURSED(new ChargedWeaponBuilder().chargedItemIds(27665, 27679).unchargedItemIds(27662, 27676).name("Accursed sceptre").animationIds(1167, 1978, 1979, 1162, 1167, 7855, 811, 9961).rechargeAmount(16000).configKeyName("accursed_sceptre").settingsConfigKey("thammarons_sceptre").leaguesMageRelic().leaguesAnimationIssue(true)),
    CRYSTAL_BOW(new ChargedWeaponBuilder().chargedItemIds(23983).animationIds(426).name("Crystal bow").configKeyName("crystal_bow").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your crystal bow has ([\\d,]+) charges remaining.", 1)).leaguesRangeRelic().leaguesAnimationIssue(false)),
    BOW_OF_FAERDHINEN(new ChargedWeaponBuilder().chargedItemIds(25865).unchargedItemIds(25862).animationIds(426).name("Bow of faerdhinen").configKeyName("bow_of_faerdhinen").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your bow of Faerdhinen has ([\\d,]+) charges remaining.", 1)).updateMessageChargesRegexes(ChargesMessage.matcherGroupChargeMessage(Text.removeTags((String)"<col=ff0000>Your bow of Faerdhinen has ([\\d,]+) charges remaining.</col>"), 1)).leaguesRangeRelic().leaguesAnimationIssue(false)),
    CRYSTAL_HELM(new ChargedWeaponBuilder().chargedItemIds(23971, 27705, 27717, 27729, 27741, 27753, 27765, 27777).unchargedItemIds(23973, 27707, 27719, 27731, 27743, 27755, 27767, 27779).name("Crystal armour").configKeyName("crystal_helm").settingsConfigKey("crystal_armour").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your crystal helm has ([\\d,]+) charges remaining.", 1))),
    CRYSTAL_BODY(new ChargedWeaponBuilder().chargedItemIds(23975, 27697, 27709, 27721, 27733, 27745, 27757, 27769).unchargedItemIds(23977, 27699, 27711, 27723, 27735, 27747, 27759, 27771).name("Crystal armour").configKeyName("crystal_body").settingsConfigKey("crystal_armour").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your crystal body has ([\\d,]+) charges remaining.", 1))),
    CRYSTAL_LEGS(new ChargedWeaponBuilder().chargedItemIds(23979, 27701, 27713, 27725, 27737, 27749, 27761, 27773).unchargedItemIds(23981, 27703, 27715, 27727, 27739, 27751, 27763, 27775).name("Crystal armour").configKeyName("crystal_legs").settingsConfigKey("crystal_armour").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your crystal legs has ([\\d,]+) charges remaining.", 1))),
    SERPENTINE_HELM(new ChargedWeaponBuilder().chargedItemIds(12931, 13197, 13199).unchargedItemIds(12929, 13196, 13198).name("Serpentine helm").rechargeAmount(11000).configKeyName("serpentine_helm").checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage(Text.removeTags((String)"^Scales: <col=007f00>([\\d,]+) (\\(\\d+[.]?\\d%\\))</col>$"), 1)).updateMessageChargesRegexes(ChargesMessage.staticChargeMessage("Your serpentine helm has run out of Zulrah's scales.", 0), ChargesMessage.staticChargeMessage("Your tanzanite helm has run out of Zulrah's scales.", 0), ChargesMessage.staticChargeMessage("Your magma helm has run out of Zulrah's scales.", 0)).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.inputOptionSelected(Pattern.compile("How many scales would you like to use\\? \\(0 - ([\\d,]+)\\)"), null), ChargesDialogHandler.genericInputChargeMessage()))),
    TUMEKENS_SHADOW(new ChargedWeaponBuilder().chargedItemIds(27275).unchargedItemIds(27277).graphicIds(2125).name("Tumeken's shadow").rechargeAmount(20000).configKeyName("tumekens_shadow").checkChargesRegexes(ChargesMessage.staticChargeMessage("Your Tumeken's shadow is already fully charged.", 20000)).updateMessageChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Tumeken's shadow has ([\\d,]+) charges remaining.", 1), ChargesMessage.matcherGroupChargeMessage(Text.removeTags((String)"<col=e00a19>Tumeken's shadow only has ([\\d,]+) charges left!</col>"), 1), ChargesMessage.staticChargeMessage("Tumeken's shadow has run out of charges.", 0)).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.optionsOptionSelected(Pattern.compile("Uncharge all the charges from your staff?"), null, Pattern.compile("Proceed.")), ChargesDialogHandler.genericUnchargeDialog()), new ChargesDialogHandler(DialogStateMatcher.inputOptionSelected(Pattern.compile("How many charges do you want to apply\\? \\(Up to ([\\d,]+)\\)"), null), ChargesDialogHandler.genericInputChargeMessage()), new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You apply ([\\d,]+) charges to your Tumeken's shadow."), null), ChargesDialogHandler.genericSpriteDialogChargesMessage(true, 1)), new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You apply an additional ([\\d,]+) charges to your Tumeken's shadow. It now has ([\\d,]+) charges in total."), null), ChargesDialogHandler.genericSpriteDialogChargesMessage(true, 2))).leaguesMageRelic().leaguesAnimationIssue(false)),
    TOXIC_BLOWPIPE(new ChargedWeaponBuilder().chargedItemIds(12926, 28688).name("Toxic blowpipe").settingsConfigKey("blowpipe").leaguesRangeRelic().leaguesAnimationIssue(false)),
    VENATOR_BOW(new ChargedWeaponBuilder().chargedItemIds(27610).unchargedItemIds(27612).animationIds(9858).name("Venator bow").configKeyName("venator_bow").updateMessageChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your Venator bow has ([\\d,]+) charges remaining.", 1)).checkChargesRegexes(ChargesMessage.matcherGroupChargeMessage("Your venator bow has ([\\d,]+) charges remaining.", 1)).dialogHandlers(new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You use ([\\d,]+) ancient essence to charge your venator bow. It now has ([\\d,]+) charges."), null), ChargesDialogHandler.genericSpriteDialogChargesMessage(true, 2))).leaguesRangeRelic().leaguesAnimationIssue(false));

    public static final List<ChargedWeapon> CRYSTAL_SHARD_RECHARGABLE_ITEMS;
    public static final int MELEE_RELIC = 2;
    public static final int RANGE_RELIC = 1;
    public static final int MAGE_RELIC = 3;
    private static final List<ChargesMessage> nonUniqueCheckChargesRegexes;
    private static final List<ChargesMessage> nonUniqueUpdateMessageChargesRegexes;
    private static final List<ChargesDialogHandler> nonUniqueDialogHandlers;
    public final List<Integer> itemIds;
    public final List<Integer> unchargedIds;
    public final List<Integer> animationIds;
    public final List<Integer> graphicIds;
    public final String name;
    public final Integer rechargeAmount;
    public final int defaultLowChargeThreshold;
    public final String configKeyName;
    public final String settingsConfigKey;
    private final List<ChargesMessage> checkChargesRegexes;
    private final List<ChargesMessage> updateMessageChargesRegexes;
    private final List<ChargesDialogHandler> dialogHandlers;
    public final int leaguesRelicType;
    public final boolean leaguesAnimationIssue;
    public static final String DISPLAY_CONFIG_KEY_SUFFIX = "_display";
    public static final String LOW_CHARGE_CONFIG_KEY_SUFFIX = "_low_charge_threshold";

    private ChargedWeapon(ChargedWeaponBuilder builder) {
        this.itemIds = builder.chargedItemIds;
        this.unchargedIds = builder.unchargedItemIds;
        this.animationIds = builder.animationIds;
        this.graphicIds = builder.graphicIds;
        if (builder.name == null) {
            throw new IllegalStateException("cannot have a null name for charged weapon.");
        }
        this.name = builder.name;
        this.rechargeAmount = builder.rechargeAmount;
        this.defaultLowChargeThreshold = builder.defaultLowChargeThreshold;
        this.configKeyName = builder.configKeyName;
        this.settingsConfigKey = builder.settingsConfigKey == null ? builder.configKeyName : builder.settingsConfigKey;
        this.checkChargesRegexes = builder.checkChargesRegexes;
        this.updateMessageChargesRegexes = builder.updateMessageChargesRegexes;
        this.dialogHandlers = builder.dialogHandlers;
        this.leaguesAnimationIssue = builder.leaguesAnimationIssue;
        this.leaguesRelicType = builder.leaguesRelicType;
    }

    public static ChargedWeapon getChargedWeaponFromId(int itemId) {
        for (ChargedWeapon weapon : ChargedWeapon.values()) {
            if (!weapon.getItemIds().contains(itemId) && !weapon.getUnchargedIds().contains(itemId)) continue;
            return weapon;
        }
        return null;
    }

    public WeaponChargesConfig.DisplayWhen getDisplayWhen(ConfigManager configManager) {
        try {
            return WeaponChargesConfig.DisplayWhen.valueOf(configManager.getConfiguration("weaponCharges", this.settingsConfigKey + DISPLAY_CONFIG_KEY_SUFFIX));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return WeaponChargesConfig.DisplayWhen.USE_DEFAULT;
        }
    }

    public void setDisplayWhen(ConfigManager configManager, WeaponChargesConfig.DisplayWhen displayWhen) {
        if (displayWhen == null) {
            throw new IllegalArgumentException("displaywhen cannot be set to null");
        }
        configManager.setConfiguration("weaponCharges", this.settingsConfigKey + DISPLAY_CONFIG_KEY_SUFFIX, (Object)displayWhen);
    }

    public int getLowCharge(ConfigManager configManager) {
        try {
            return Integer.parseInt(configManager.getConfiguration("weaponCharges", this.settingsConfigKey + LOW_CHARGE_CONFIG_KEY_SUFFIX));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return this.getDefaultLowChargeThreshold();
        }
    }

    public void setLowCharge(ConfigManager configManager, int charges) {
        configManager.setConfiguration("weaponCharges", this.settingsConfigKey + LOW_CHARGE_CONFIG_KEY_SUFFIX, (Object)charges);
    }

    private static ChargedWeapon get_scythe_circumvent_illegal_self_reference() {
        return SCYTHE_OF_VITUR;
    }

    public List<Integer> getItemIds() {
        return this.itemIds;
    }

    public List<Integer> getUnchargedIds() {
        return this.unchargedIds;
    }

    public List<Integer> getAnimationIds() {
        return this.animationIds;
    }

    public List<Integer> getGraphicIds() {
        return this.graphicIds;
    }

    public String getName() {
        return this.name;
    }

    public Integer getRechargeAmount() {
        return this.rechargeAmount;
    }

    public int getDefaultLowChargeThreshold() {
        return this.defaultLowChargeThreshold;
    }

    public String getConfigKeyName() {
        return this.configKeyName;
    }

    public String getSettingsConfigKey() {
        return this.settingsConfigKey;
    }

    public List<ChargesMessage> getCheckChargesRegexes() {
        return this.checkChargesRegexes;
    }

    public List<ChargesMessage> getUpdateMessageChargesRegexes() {
        return this.updateMessageChargesRegexes;
    }

    public List<ChargesDialogHandler> getDialogHandlers() {
        return this.dialogHandlers;
    }

    public int getLeaguesRelicType() {
        return this.leaguesRelicType;
    }

    public boolean isLeaguesAnimationIssue() {
        return this.leaguesAnimationIssue;
    }

    public static List<ChargesMessage> getNonUniqueCheckChargesRegexes() {
        return nonUniqueCheckChargesRegexes;
    }

    public static List<ChargesMessage> getNonUniqueUpdateMessageChargesRegexes() {
        return nonUniqueUpdateMessageChargesRegexes;
    }

    public static List<ChargesDialogHandler> getNonUniqueDialogHandlers() {
        return nonUniqueDialogHandlers;
    }

    static {
        CRYSTAL_SHARD_RECHARGABLE_ITEMS = Arrays.asList(CRYSTAL_BOW, CRYSTAL_HELM, CRYSTAL_BODY, CRYSTAL_LEGS, BOW_OF_FAERDHINEN, CRYSTAL_HALBERD);
        nonUniqueCheckChargesRegexes = Arrays.asList(ChargesMessage.matcherGroupChargeMessage("Your weapon has ([\\d,]+) charges.", 1), ChargesMessage.matcherGroupChargeMessage("Your bow has ([\\d,]+) charges? left powering it.", 1), ChargesMessage.matcherGroupChargeMessage("Your chainmace has ([\\d,]+) charges? left powering it.", 1), ChargesMessage.matcherGroupChargeMessage("Your sceptre has ([\\d,]+) charges? left powering it.", 1), ChargesMessage.staticChargeMessage("You use 1000 ether to activate the weapon.", 0), ChargesMessage.matcherGroupChargeMessage("You add (a further )?([\\d,]+) revenant ether to your weapon, giving it a total of ([\\d,]+) charges?.", 3), ChargesMessage.matcherGroupChargeMessage("(You remove [\\S]+ pages? from the book. )?Your tome currently holds ([\\d,]+) charges.", 2), ChargesMessage.staticChargeMessage("(You remove [\\S]+ pages? from the book. )?Your tome currently holds one charge.", 1), ChargesMessage.staticChargeMessage("You empty your book of pages.", 0));
        nonUniqueUpdateMessageChargesRegexes = Arrays.asList(ChargesMessage.matcherGroupChargeMessage(Text.removeTags((String)"<col=ef1020>Your trident only has ([\\d,]+) charges left!</col>"), 1), ChargesMessage.staticChargeMessage(Text.removeTags((String)"<col=ef1020>Your trident has run out of charges.</col>"), 0), ChargesMessage.matcherGroupChargeMessage(Text.removeTags((String)"<col=ef1020>Your weapon only has ([\\d,]+) charges left.</col>"), 1), ChargesMessage.staticChargeMessage(Text.removeTags((String)"<col=ef1020>Your weapon has run out of revenant ether.</col>"), 0), ChargesMessage.staticChargeMessage("There is not enough revenant ether left powering your bow.", 0));
        nonUniqueDialogHandlers = Arrays.asList(new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You add [\\S]+ [\\S]+ to the weapon. New total: ([\\d,]+)"), null), ChargesDialogHandler.genericSpriteDialogChargesMessage(true, 1)), new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("Your weapon is already fully charged."), null), ChargesDialogHandler.genericSpriteDialogFullChargeMessage()), new ChargesDialogHandler(DialogStateMatcher.sprite(Pattern.compile("You uncharge your weapon."), null), ChargesDialogHandler.genericSpriteDialogUnchargeMessage()), new ChargesDialogHandler(DialogStateMatcher.inputOptionSelected(Pattern.compile("How many charges would you like to add\\? \\(0 - ([\\d,]+)\\)"), null), ChargesDialogHandler.genericInputChargeMessage()), new ChargesDialogHandler(DialogStateMatcher.optionsOptionSelected(Pattern.compile("You will NOT get the coins back."), null, Pattern.compile("Okay, uncharge it.")), ChargesDialogHandler.genericUnchargeDialog()), new ChargesDialogHandler(DialogStateMatcher.optionsOptionSelected(Pattern.compile("If you drop it, it will lose all its charges."), null, Pattern.compile("Drop it.")), ChargesDialogHandler.genericUnchargeDialog()), new ChargesDialogHandler(DialogStateMatcher.inputOptionSelected(Pattern.compile("How many shards do you wish to add\\? \\(0 - ([\\d,]+)\\)"), null), ChargesDialogHandler.genericInputChargeMessage(100)));
    }

    private static class ChargedWeaponBuilder {
        List<Integer> chargedItemIds = Collections.emptyList();
        List<Integer> unchargedItemIds = Collections.emptyList();
        List<Integer> animationIds = Collections.emptyList();
        String name = null;
        Integer rechargeAmount;
        String configKeyName;
        String settingsConfigKey;
        List<ChargesMessage> checkChargesRegexes = Collections.emptyList();
        List<ChargesMessage> updateMessageChargesRegexes = Collections.emptyList();
        List<ChargesDialogHandler> dialogHandlers = Collections.emptyList();
        int defaultLowChargeThreshold = 500;
        int leaguesRelicType = -1;
        boolean leaguesAnimationIssue = false;
        public List<Integer> graphicIds = Collections.emptyList();

        private ChargedWeaponBuilder() {
        }

        public ChargedWeaponBuilder chargedItemIds(Integer ... chargedItemIds) {
            this.chargedItemIds = Arrays.asList(chargedItemIds);
            return this;
        }

        public ChargedWeaponBuilder unchargedItemIds(Integer ... unchargedItemIds) {
            this.unchargedItemIds = Arrays.asList(unchargedItemIds);
            return this;
        }

        public ChargedWeaponBuilder animationIds(Integer ... animationIds) {
            this.animationIds = Arrays.asList(animationIds);
            return this;
        }

        public ChargedWeaponBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChargedWeaponBuilder rechargeAmount(Integer rechargeAmount) {
            this.rechargeAmount = rechargeAmount;
            return this;
        }

        public ChargedWeaponBuilder configKeyName(String configKeyName) {
            this.configKeyName = configKeyName;
            return this;
        }

        public ChargedWeaponBuilder settingsConfigKey(String settingsConfigKey) {
            this.settingsConfigKey = settingsConfigKey;
            return this;
        }

        public ChargedWeaponBuilder checkChargesRegexes(ChargesMessage ... checkChargesRegexes) {
            this.checkChargesRegexes = Arrays.asList(checkChargesRegexes);
            return this;
        }

        public ChargedWeaponBuilder updateMessageChargesRegexes(ChargesMessage ... updateMessageChargesRegexes) {
            this.updateMessageChargesRegexes = Arrays.asList(updateMessageChargesRegexes);
            return this;
        }

        public ChargedWeaponBuilder dialogHandlers(ChargesDialogHandler ... dialogHandlers) {
            this.dialogHandlers = Arrays.asList(dialogHandlers);
            return this;
        }

        public ChargedWeaponBuilder defaultLowChargeThreshold(int defaultLowChargeThreshold) {
            this.defaultLowChargeThreshold = defaultLowChargeThreshold;
            return this;
        }

        public ChargedWeaponBuilder leaguesMeleeRelic() {
            this.leaguesRelicType = 2;
            return this;
        }

        public ChargedWeaponBuilder leaguesRangeRelic() {
            this.leaguesRelicType = 1;
            return this;
        }

        public ChargedWeaponBuilder leaguesMageRelic() {
            this.leaguesRelicType = 3;
            return this;
        }

        public ChargedWeaponBuilder leaguesAnimationIssue(boolean leaguesAnimationIssue) {
            this.leaguesAnimationIssue = leaguesAnimationIssue;
            return this;
        }

        public ChargedWeaponBuilder graphicIds(Integer ... graphicIds) {
            this.graphicIds = Arrays.asList(graphicIds);
            return this;
        }
    }
}

