/*
 * Decompiled with CFR 0.152.
 */
package com.playerhighlighter;

import com.playerhighlighter.PlayerHighlighterConfig;
import com.playerhighlighter.PlayerHighlighterPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

public class PlayerHighlighterOverlay
extends Overlay {
    private final Client client;
    private final PlayerHighlighterPlugin plugin;
    private final PlayerHighlighterConfig config;
    private final ModelOutlineRenderer outlineRenderer;

    @Inject
    private PlayerHighlighterOverlay(Client client, PlayerHighlighterPlugin plugin, PlayerHighlighterConfig config, ModelOutlineRenderer outlineRenderer) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.outlineRenderer = outlineRenderer;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        WorldPoint my_loc = this.client.getLocalPlayer().getWorldLocation();
        for (Player player : this.client.getPlayers()) {
            WorldPoint player_loc = player.getWorldLocation();
            float distance = my_loc.distanceTo(player_loc);
            if (player != this.client.getLocalPlayer() && distance == 0.0f) {
                this.outlineRenderer.drawOutline(player, this.config.borderWidth(), this.config.underfootColor(), this.config.borderFeather());
                continue;
            }
            if (player == this.client.getLocalPlayer() || !(distance <= (float)this.config.highlightRadius())) continue;
            this.outlineRenderer.drawOutline(player, this.config.borderWidth(), this.config.outlineColor(), this.config.borderFeather());
        }
        if (this.config.highlightSelf()) {
            this.outlineRenderer.drawOutline(this.client.getLocalPlayer(), this.config.borderWidth(), this.config.selfColor(), this.config.borderFeather());
        }
        return null;
    }
}

