/*
 * Decompiled with CFR 0.152.
 */
package com.starinfo;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.starinfo.DiscordTimeStamp;
import com.starinfo.Star;
import com.starinfo.StarInfoBox;
import com.starinfo.StarInfoConfig;
import com.starinfo.StarInfoOverlay;
import com.starinfo.TierData;
import com.starinfo.WorldInfo;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.Renderable;
import net.runelite.api.Skill;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WorldType;
import net.runelite.api.coords.Angle;
import net.runelite.api.coords.Direction;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.Hooks;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;

@PluginDescriptor(name="Star Info", description="Displays tier, number of miners, health % above shooting stars")
public class StarInfoPlugin
extends Plugin {
    private static final int NPC_ID = 10629;
    private static final int MAX_PLAYER_LOAD_DIST = 13;
    private static final Queue<Star> despawnQueue = new LinkedList<Star>();
    private static final Set<Integer> dragonPickSpecAnims = ImmutableSet.of((Object)7138, (Object)334, (Object)8781, (Object)8330, (Object)8329, (Object)3410, (Object[])new Integer[0]);
    private static final Map<Integer, Double> pickAnims = ImmutableMap.builder().put((Object)6750, (Object)3.0).put((Object)8787, (Object)2.8333333333333335).put((Object)6108, (Object)5.0).put((Object)6747, (Object)8.0).put((Object)8314, (Object)3.0).put((Object)8350, (Object)2.75).put((Object)7284, (Object)2.8333333333333335).put((Object)7140, (Object)2.8333333333333335).put((Object)8349, (Object)2.8333333333333335).put((Object)8888, (Object)2.8333333333333335).put((Object)643, (Object)2.8333333333333335).put((Object)4483, (Object)2.8333333333333335).put((Object)6751, (Object)5.0).put((Object)6748, (Object)7.0).put((Object)6746, (Object)3.0).put((Object)6749, (Object)6.0).put((Object)8789, (Object)2.8333333333333335).put((Object)7138, (Object)2.8333333333333335).put((Object)334, (Object)2.8333333333333335).put((Object)8781, (Object)2.8333333333333335).put((Object)8330, (Object)2.8333333333333335).put((Object)3410, (Object)2.8333333333333335).put((Object)8329, (Object)2.75).build();
    private static final int MINING_CACHE_TIME = 13;
    private static final Map<String, Integer> playerLastMined = new HashMap<String, Integer>();
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    @Inject
    private StarInfoOverlay starOverlay;
    public final List<Star> stars = new ArrayList<Star>();
    private double xpPerHour = -1.0;
    private double dustPerHour = -1.0;
    private boolean hintArrowShown = false;
    public int layerTimer = 0;
    @Inject
    private InfoBoxManager infoBoxManager;
    private StarInfoBox infoBox;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    Client client;
    @Inject
    private StarInfoConfig starConfig;
    @Inject
    private WorldInfo worldInfo;
    @Inject
    private Hooks hooks;

    @Provides
    StarInfoConfig provideConfig(ConfigManager configManager) {
        return (StarInfoConfig)configManager.getConfig(StarInfoConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.starOverlay);
        this.starOverlay.updateConfig();
        this.hooks.registerRenderableDrawListener(this.drawListener);
    }

    protected void shutDown() throws Exception {
        this.clear();
        this.refresh();
        this.overlayManager.remove((Overlay)this.starOverlay);
        this.infoBox = null;
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
    }

    private void clear() {
        playerLastMined.clear();
        this.stars.clear();
        this.layerTimer = 0;
    }

    private boolean shouldDraw(Renderable renderable, boolean b) {
        if (!(renderable instanceof NPC)) {
            return true;
        }
        NPC npc = (NPC)renderable;
        return npc.getId() != 10629;
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getId() != 10629) {
            return;
        }
        for (Star star : this.stars) {
            if (!star.getWorldPoint().equals((Object)event.getNpc().getWorldLocation())) continue;
            star.setNpc(event.getNpc());
            this.refresh();
            return;
        }
        Star star = new Star(event.getNpc(), this.client.getWorld());
        this.worldInfo.update(star);
        this.stars.add(0, star);
        this.refresh();
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getId() != 10629) {
            return;
        }
        for (Star star : this.stars) {
            if (!star.getWorldPoint().equals((Object)event.getNpc().getWorldLocation())) continue;
            star.setNpc(null);
            this.refresh();
            return;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        int tier = Star.getTier(event.getGameObject().getId());
        if (tier < 0) {
            return;
        }
        boolean newStar = false;
        Star star = null;
        for (Star s : this.stars) {
            if (!s.getWorldPoint().equals((Object)event.getGameObject().getWorldLocation())) continue;
            s.setObject(event.getGameObject());
            s.resetHealth();
            star = s;
            this.layerTimer = 0;
            despawnQueue.remove(star);
            break;
        }
        if (star == null) {
            star = new Star(event.getGameObject(), this.client.getWorld());
            this.worldInfo.update(star);
            this.stars.add(0, star);
            newStar = true;
        }
        if (newStar && this.starConfig.addToChat()) {
            this.client.addChatMessage(ChatMessageType.CONSOLE, "", star.getMessage(), "");
        }
        this.refresh();
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        int tier = Star.getTier(event.getGameObject().getId());
        if (tier < 0) {
            return;
        }
        for (Star star : this.stars) {
            if (!event.getGameObject().equals(event.getGameObject()) && !event.getGameObject().getWorldLocation().equals((Object)star.getWorldPoint())) continue;
            despawnQueue.add(star);
            break;
        }
    }

    void updateMiners(Star star) {
        int distToStar = this.client.getLocalPlayer().getWorldLocation().distanceTo(new WorldArea(star.getWorldPoint(), 2, 2));
        if (distToStar > 13) {
            star.setMiners("?");
            return;
        }
        WorldArea areaH = new WorldArea(star.getWorldPoint().dx(-1), 4, 2);
        WorldArea areaV = new WorldArea(star.getWorldPoint().dy(-1), 2, 4);
        int count = 0;
        int tickCount = this.client.getTickCount();
        for (Player p : this.client.getPlayers()) {
            int ticksSinceMinedLast;
            if (!p.getWorldLocation().isInArea2D(new WorldArea[]{areaH, areaV}) || !this.facingObject(p.getWorldLocation(), p.getOrientation(), star.getWorldPoint())) continue;
            if (pickAnims.containsKey(p.getAnimation())) {
                ++count;
                playerLastMined.put(p.getName(), tickCount);
                continue;
            }
            if (p.getHealthRatio() < 0 || !playerLastMined.containsKey(p.getName()) || (ticksSinceMinedLast = tickCount - playerLastMined.get(p.getName())) >= 13) continue;
            ++count;
        }
        ++this.layerTimer;
        star.setMiners(Integer.toString(count));
    }

    private double getPickTicks(Player p) {
        int weaponId;
        int animId = p.getAnimation();
        if (animId == 8347 && (weaponId = p.getPlayerComposition().getEquipmentId(KitType.WEAPON)) == 23682) {
            return 2.8333333333333335;
        }
        return pickAnims.getOrDefault(p.getAnimation(), 2.8333333333333335);
    }

    private double prospectorXpMulti(PlayerComposition playerComposition) {
        double multi = 1.0;
        if (playerComposition.getEquipmentId(KitType.HEAD) == 25549 || playerComposition.getEquipmentId(KitType.HEAD) == 12013) {
            multi += 0.004;
        }
        if (playerComposition.getEquipmentId(KitType.BOOTS) == 25555 || playerComposition.getEquipmentId(KitType.HEAD) == 12016) {
            multi += 0.002;
        }
        if (playerComposition.getEquipmentId(KitType.TORSO) == 25551 || playerComposition.getEquipmentId(KitType.HEAD) == 12014 || playerComposition.getEquipmentId(KitType.HEAD) == 13107) {
            multi += 0.008;
        }
        if (playerComposition.getEquipmentId(KitType.LEGS) == 25553 || playerComposition.getEquipmentId(KitType.HEAD) == 12015) {
            multi += 0.006;
        }
        if (multi > 1.019) {
            multi += 0.005;
        }
        return multi;
    }

    private boolean facingObject(WorldPoint p1, int orientation, WorldPoint p2) {
        Direction dir = new Angle(orientation).getNearestDirection();
        WorldPoint dif = p2.dx(-p1.getX()).dy(-p1.getY());
        switch (dir) {
            case NORTH: {
                return dif.getY() > 0;
            }
            case SOUTH: {
                return dif.getY() < 0;
            }
            case EAST: {
                return dif.getX() > 0;
            }
            case WEST: {
                return dif.getX() < 0;
            }
        }
        return false;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged state) {
        if (state.getGameState() == GameState.HOPPING || state.getGameState() == GameState.LOGGING_IN) {
            this.clear();
            this.refresh();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        Star star;
        if (this.stars.isEmpty()) {
            return;
        }
        Iterator<Star> it = this.stars.iterator();
        boolean refresh = false;
        while (it.hasNext()) {
            star = it.next();
            if (!despawnQueue.contains(star) && this.client.getLocalPlayer().getWorldLocation().distanceTo(star.getWorldPoint()) <= this.starConfig.removeDistance()) continue;
            this.layerTimer = 0;
            it.remove();
            refresh = true;
            despawnQueue.remove(star);
        }
        if (!this.stars.isEmpty()) {
            star = this.stars.get(0);
            this.updateMiners(star);
            this.refreshHintArrow();
        }
        if (this.starConfig.xpPerHour() || this.starConfig.dustPerHour()) {
            this.updateXpDustPerHour();
        }
        if (refresh) {
            this.refresh();
        }
    }

    private void updateXpDustPerHour() {
        Item ringItem;
        Player player = this.client.getLocalPlayer();
        if (player == null || this.stars.isEmpty()) {
            this.dustPerHour = -1.0;
            this.xpPerHour = -1.0;
            return;
        }
        Star star = this.stars.get(0);
        TierData tierData = TierData.get(star.getTier());
        if (tierData == null || !this.nextToStar(star, player.getWorldLocation())) {
            this.dustPerHour = -1.0;
            this.xpPerHour = -1.0;
            return;
        }
        int animId = player.getAnimation();
        if (!pickAnims.containsKey(animId)) {
            this.dustPerHour = -1.0;
            this.xpPerHour = -1.0;
            return;
        }
        int level = this.client.getBoostedSkillLevel(Skill.MINING);
        boolean members = this.client.getWorldType().contains(WorldType.MEMBERS);
        ItemContainer equip = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (members && equip != null && (ringItem = equip.getItem(EquipmentInventorySlot.RING.getSlotIdx())) != null && ringItem.getId() == 25541) {
            level += 4;
        }
        double ticks = this.getPickTicks(player);
        double chance = tierData.getChance(level);
        double dustPerTick = chance / ticks;
        double xp = members ? tierData.xp : tierData.xp / 2.0;
        double xpPerTick = dustPerTick * xp;
        if (members) {
            xpPerTick *= this.prospectorXpMulti(player.getPlayerComposition());
        }
        this.xpPerHour = xpPerTick * 6000.0;
        this.dustPerHour = dustPerTick * (1.0 + tierData.doubleDustChance) * 6000.0;
    }

    public void toggleHintArrow(boolean show) {
        if (show) {
            if (!this.stars.isEmpty() && !this.hintArrowShown) {
                Star star = this.stars.get(0);
                this.client.setHintArrow(star.getWorldPoint());
                this.hintArrowShown = true;
            }
        } else if (this.hintArrowShown) {
            this.client.clearHintArrow();
            this.hintArrowShown = false;
        }
    }

    public void refreshHintArrow() {
        if (this.stars.isEmpty()) {
            if (this.starConfig.showHintArrow()) {
                this.toggleHintArrow(false);
            }
        } else {
            Star star = this.stars.get(0);
            if (this.starConfig.showHintArrow()) {
                if (this.nextToStar(star, this.client.getLocalPlayer().getWorldLocation())) {
                    this.toggleHintArrow(false);
                } else {
                    this.toggleHintArrow(true);
                }
            }
        }
    }

    public void refresh() {
        if (this.stars.isEmpty()) {
            if (this.starConfig.showInfoBox()) {
                this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
            }
        } else {
            Star star = this.stars.get(0);
            if (this.starConfig.showInfoBox()) {
                this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
                this.infoBox = new StarInfoBox((BufferedImage)this.itemManager.getImage(25547), this, star);
                this.infoBoxManager.addInfoBox((InfoBox)this.infoBox);
            }
        }
        this.refreshHintArrow();
    }

    private boolean nextToStar(Star star, WorldPoint worldPoint) {
        WorldArea areaH = new WorldArea(star.getWorldPoint().dx(-1), 4, 2);
        WorldArea areaV = new WorldArea(star.getWorldPoint().dy(-1), 2, 4);
        return worldPoint.isInArea2D(new WorldArea[]{areaH, areaV});
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.stars.isEmpty() || event.getType() != MenuAction.EXAMINE_OBJECT.getId() || !this.starConfig.copyToClipboard()) {
            return;
        }
        Tile tile = this.client.getScene().getTiles()[this.client.getPlane()][event.getActionParam0()][event.getActionParam1()];
        TileObject tileObject = this.findTileObject(tile, event.getIdentifier());
        if (tileObject == null || !tile.getWorldLocation().equals((Object)this.stars.get(0).getWorldPoint()) || Star.getTier(tileObject.getId()) < 0) {
            return;
        }
        this.client.createMenuEntry(-1).setOption("Copy").setTarget(event.getTarget()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(menuEntry -> this.copy((MenuEntry)menuEntry, false));
        this.client.createMenuEntry(-2).setOption("Detailed copy").setTarget(event.getTarget()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(menuEntry -> this.copy((MenuEntry)menuEntry, true));
    }

    private void copy(MenuEntry menuEntry, boolean detailed) {
        if (this.stars.isEmpty()) {
            return;
        }
        Star star = this.stars.get(0);
        String content = "W" + star.getWorld() + " T" + star.getTier() + " ";
        if (star.getHealth() >= 0) {
            content = content + star.getHealth() + "% ";
        }
        if (!star.getMiners().equals("?")) {
            content = content + "- " + star.getMiners() + " Miners - ";
        }
        content = content + star.getLocation().getDescription();
        content = content + star.getWorldInfo();
        content = content + " " + DiscordTimeStamp.relativeTimeNow();
        if (detailed && star.getTierTicksEstimate() != null) {
            for (int i = star.getTierTicksEstimate().length - 1; i >= 0; --i) {
                content = content + "\nT" + i + " estimate: " + DiscordTimeStamp.relativeTimeNowPlus(star.getTierTicksEstimate()[i]);
            }
        } else if (star.getTierTicksEstimate() != null && this.starConfig.addT0Estimate()) {
            content = content + " T0 estimate: " + DiscordTimeStamp.relativeTimeNowPlus(star.getTierTicksEstimate()[0]);
        }
        StringSelection stringSelection = new StringSelection(content);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Copied star information to clipboard.", "");
    }

    private TileObject findTileObject(Tile tile, int id) {
        if (tile == null) {
            return null;
        }
        for (GameObject object : tile.getGameObjects()) {
            if (object == null || object.getId() != id) continue;
            return object;
        }
        return null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("starinfoplugin")) {
            return;
        }
        switch (event.getKey()) {
            case "textColor": {
                this.starOverlay.updateConfig();
                break;
            }
            case "infoBox": {
                if (this.starConfig.showInfoBox()) {
                    this.refresh();
                    break;
                }
                this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
                this.infoBox = null;
                break;
            }
            case "hintArrow": {
                if (this.starConfig.showHintArrow()) {
                    this.refresh();
                    break;
                }
                this.toggleHintArrow(false);
            }
        }
    }

    public double getXpPerHour() {
        return this.xpPerHour;
    }

    public double getDustPerHour() {
        return this.dustPerHour;
    }
}

