/*
 * Decompiled with CFR 0.152.
 */
package com.starinfo;

import com.google.common.base.Strings;
import com.starinfo.EstimateConfig;
import com.starinfo.Star;
import com.starinfo.StarInfoConfig;
import com.starinfo.StarInfoPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;

public class StarInfoOverlay
extends Overlay {
    private static final int Y_ADJUST = 12;
    private final StarInfoPlugin plugin;
    private final StarInfoConfig config;
    private Color textColor;

    @Inject
    StarInfoOverlay(StarInfoPlugin plugin, StarInfoConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.LOW);
    }

    public void updateConfig() {
        this.textColor = this.config.getTextColor();
    }

    public Dimension render(Graphics2D graphics) {
        double dustPerHour;
        double xpPerHour;
        int minutes;
        int seconds;
        int ticks;
        Shape shape;
        if (this.plugin.stars.isEmpty()) {
            return null;
        }
        Star star = this.plugin.stars.get(0);
        if (this.config.colorStar() && (shape = star.getObject().getConvexHull()) != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)shape, (Color)this.getStarColor());
        }
        int health = star.getHealth();
        Point starLocation = star.getObject().getCanvasLocation(190);
        if (starLocation != null && !this.config.hideHealthBar() && health > 0) {
            try {
                starLocation = new Point(starLocation.getX() - this.config.healthBarWidth() / 2, starLocation.getY() - this.config.healthBarHeight() - 14);
                Color prevColor = graphics.getColor();
                graphics.setColor(this.config.getHpColorBack());
                graphics.fillRect(starLocation.getX(), starLocation.getY(), this.config.healthBarWidth(), this.config.healthBarHeight());
                graphics.setColor(this.config.getHpColorFore());
                graphics.fillRect(starLocation.getX(), starLocation.getY(), health * this.config.healthBarWidth() / 100, this.config.healthBarHeight());
                graphics.setColor(prevColor);
            }
            catch (Exception e) {
                return null;
            }
        }
        int yOff = 0;
        Object text = "T" + star.getTier();
        if (health >= 0 && this.config.showPercent()) {
            text = (String)text + " " + health + "%";
        }
        if ((starLocation = star.getObject().getCanvasTextLocation(graphics, (String)text, 190)) != null) {
            try {
                starLocation = new Point(starLocation.getX(), starLocation.getY() + yOff);
                this.overlayText(graphics, starLocation, (String)text);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.config.showMiners() && star.getMiners() != null && !star.getMiners().equals("?")) {
            text = this.config.compact() ? star.getMiners() + "M" : "Miners: " + star.getMiners();
            starLocation = star.getObject().getCanvasTextLocation(graphics, (String)text, 190);
            if (starLocation != null) {
                try {
                    starLocation = new Point(starLocation.getX(), starLocation.getY() + (yOff += 12));
                    this.overlayText(graphics, starLocation, (String)text);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        if (!this.config.estimateLayerTime().equals((Object)EstimateConfig.NONE)) {
            ticks = -1;
            if (star.getTierTicksEstimate() != null && star.getTier() <= star.getTierTicksEstimate().length) {
                ticks = star.getTierTicksEstimate()[star.getTier() - 1];
            }
            Object object = text = this.config.compact() ? "" : "Layer: ";
            if (this.config.estimateLayerTime().equals((Object)EstimateConfig.TICKS)) {
                text = (String)text + ticks;
            } else {
                seconds = ticks % 100 * 3 / 5;
                minutes = ticks / 100;
                text = (String)text + minutes + ":" + String.format("%02d", seconds);
            }
            starLocation = star.getObject().getCanvasTextLocation(graphics, (String)text, 190);
            if (starLocation != null && ticks >= 0) {
                try {
                    starLocation = new Point(starLocation.getX(), starLocation.getY() + (yOff += 12));
                    this.overlayText(graphics, starLocation, (String)text);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        if (!this.config.estimateDeathTime().equals((Object)EstimateConfig.NONE) && star.getTierTicksEstimate() != null) {
            ticks = star.getTierTicksEstimate()[0];
            Object object = text = this.config.compact() ? "" : "Dead: ";
            if (this.config.estimateDeathTime().equals((Object)EstimateConfig.TICKS)) {
                text = (String)text + ticks;
            } else {
                seconds = ticks % 100 * 3 / 5;
                minutes = ticks / 100;
                text = (String)text + minutes + ":" + String.format("%02d", seconds);
            }
            starLocation = star.getObject().getCanvasTextLocation(graphics, (String)text, 190);
            if (starLocation != null) {
                try {
                    starLocation = new Point(starLocation.getX(), starLocation.getY() + (yOff += 12));
                    this.overlayText(graphics, starLocation, (String)text);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        if ((xpPerHour = this.plugin.getXpPerHour()) > 0.0 && this.config.xpPerHour()) {
            text = Math.round(xpPerHour) + " xp/hr";
            starLocation = star.getObject().getCanvasTextLocation(graphics, (String)text, 190);
            if (starLocation != null) {
                try {
                    starLocation = new Point(starLocation.getX(), starLocation.getY() + (yOff += 12));
                    this.overlayText(graphics, starLocation, (String)text);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        if ((dustPerHour = this.plugin.getDustPerHour()) > 0.0 && this.config.dustPerHour()) {
            text = String.format("%d sd/hr", Math.round(dustPerHour));
            starLocation = star.getObject().getCanvasTextLocation(graphics, (String)text, 190);
            if (starLocation != null) {
                try {
                    starLocation = new Point(starLocation.getX(), starLocation.getY() + (yOff += 12));
                    this.overlayText(graphics, starLocation, (String)text);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    private void overlayText(Graphics2D graphics, Point starLocation, String text) {
        if (this.config.thickOutline()) {
            StarInfoOverlay.renderThickOutlineText(graphics, starLocation, text, this.textColor);
        } else {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)starLocation, (String)text, (Color)this.textColor);
        }
    }

    private Color getStarColor() {
        if (this.plugin.stars.isEmpty()) {
            return Color.RED;
        }
        Star star = this.plugin.stars.get(0);
        int level = this.plugin.client.getBoostedSkillLevel(Skill.MINING);
        if (level < star.getTier() * 10) {
            return Color.RED;
        }
        return Color.GREEN;
    }

    private static void renderThickOutlineText(Graphics2D graphics, Point txtLoc, String text, Color color) {
        if (Strings.isNullOrEmpty((String)text)) {
            return;
        }
        int x = txtLoc.getX();
        int y = txtLoc.getY();
        graphics.setColor(Color.BLACK);
        graphics.drawString(text, x + 1, y + 1);
        graphics.drawString(text, x + 1, y);
        graphics.drawString(text, x + 1, y - 1);
        graphics.drawString(text, x, y + 1);
        graphics.drawString(text, x, y - 1);
        graphics.drawString(text, x - 1, y + 1);
        graphics.drawString(text, x - 1, y);
        graphics.drawString(text, x - 1, y - 1);
        graphics.setColor(ColorUtil.colorWithAlpha((Color)color, (int)255));
        graphics.drawString(text, x, y);
    }
}

