/*
 * Decompiled with CFR 0.152.
 */
package com.catimer;

import com.catimer.CABoss;
import com.catimer.CATimerConfig;
import com.catimer.SpeedrunTimer;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="CA Timers")
public class CATimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CATimerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CATimerConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;

    @Provides
    CATimerConfig provideConfig(ConfigManager configManager) {
        return (CATimerConfig)configManager.getConfig(CATimerConfig.class);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        long configTime;
        NPC npc = npcSpawned.getNpc();
        if (npc.isDead()) {
            return;
        }
        int npcId = npc.getId();
        CABoss boss = CABoss.find(npcId);
        if (boss == null) {
            return;
        }
        switch (npcId) {
            case 8583: {
                configTime = this.config.hesporiTime().getTime();
                break;
            }
            case 2042: {
                configTime = this.config.zulrahTime().getTime();
                break;
            }
            case 8615: {
                if (this.client.isInInstancedRegion()) {
                    configTime = this.config.hydraTime().getTime();
                    break;
                }
                configTime = 0L;
                break;
            }
            default: {
                configTime = 0L;
            }
        }
        this.infoBoxManager.removeIf(t -> t instanceof SpeedrunTimer && ((SpeedrunTimer)((Object)t)).getBoss() == boss);
        if (configTime != 0L) {
            SpeedrunTimer timer = new SpeedrunTimer(boss, configTime, (BufferedImage)this.itemManager.getImage(boss.getItemSpriteId()), this);
            timer.setTooltip(npc.getName());
            this.infoBoxManager.addInfoBox((InfoBox)timer);
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        NPC npc = npcChanged.getNpc();
        NPCComposition npcComp = npc.getComposition();
        String firstAction = npcComp.getActions()[1];
        int npcId = npc.getId();
        CABoss boss = CABoss.find(npcId);
        if (boss == null || boss.getId() != 8061) {
            return;
        }
        long configTime = this.config.vorkathTime().getTime();
        this.infoBoxManager.removeIf(t -> t instanceof SpeedrunTimer && ((SpeedrunTimer)((Object)t)).getBoss() == boss);
        if (Objects.equals(firstAction, "Attack") && configTime != 0L) {
            SpeedrunTimer timer = new SpeedrunTimer(boss, configTime, (BufferedImage)this.itemManager.getImage(boss.getItemSpriteId()), this);
            timer.setTooltip(npc.getName());
            this.infoBoxManager.addInfoBox((InfoBox)timer);
        }
    }
}

