/*
 * Decompiled with CFR 0.152.
 */
package com.catimer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

enum CABoss {
    HESPORI(8583, 22994),
    VORKATH(8061, 21992),
    HYDRA(8615, 22746),
    ZULRAH(2042, 12921);

    private static final Map<Integer, CABoss> bosses;
    private final int id;
    private final int itemSpriteId;

    private CABoss(int id, int itemSpriteId) {
        this.id = id;
        this.itemSpriteId = itemSpriteId;
    }

    public int getId() {
        return this.id;
    }

    public int getItemSpriteId() {
        return this.itemSpriteId;
    }

    public static CABoss find(int id) {
        return bosses.get(id);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (CABoss boss : CABoss.values()) {
            builder.put((Object)boss.getId(), (Object)boss);
        }
        bosses = builder.build();
    }
}

