/*
 * Decompiled with CFR 0.152.
 */
package com.tileman;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import com.tileman.TileInfoOverlay;
import com.tileman.TilemanImportPanel;
import com.tileman.TilemanModeConfig;
import com.tileman.TilemanModeConfigEvaluator;
import com.tileman.TilemanModeMinimapOverlay;
import com.tileman.TilemanModeOverlay;
import com.tileman.TilemanModeTile;
import com.tileman.TilemanModeWorldMapOverlay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.CollisionData;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Tileman Mode", description="Automatically draws tiles where you walk", tags={"overlay", "tiles"})
public class TilemanModePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TilemanModePlugin.class);
    private static final String CONFIG_GROUP = "tilemanMode";
    private static final String MARK = "Unlock Tileman tile";
    private static final String UNMARK = "Clear Tileman tile";
    private static final String WALK_HERE = "Walk here";
    private static final String REGION_PREFIX = "region_";
    private static final Gson GSON = new Gson();
    private final List<WorldPoint> points = new ArrayList<WorldPoint>();
    @Inject
    private Client client;
    @Inject
    private TilemanModeConfigEvaluator config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TilemanModeOverlay overlay;
    @Inject
    private TilemanModeMinimapOverlay minimapOverlay;
    @Inject
    private TilemanModeWorldMapOverlay worldMapOverlay;
    @Inject
    private TileInfoOverlay infoOverlay;
    @Inject
    private ClientToolbar clientToolbar;
    private final MovementFlag[] fullBlock = new MovementFlag[]{MovementFlag.BLOCK_MOVEMENT_FLOOR, MovementFlag.BLOCK_MOVEMENT_FLOOR_DECORATION, MovementFlag.BLOCK_MOVEMENT_OBJECT, MovementFlag.BLOCK_MOVEMENT_FULL};
    private final MovementFlag[] allDirections = new MovementFlag[]{MovementFlag.BLOCK_MOVEMENT_NORTH_WEST, MovementFlag.BLOCK_MOVEMENT_NORTH, MovementFlag.BLOCK_MOVEMENT_NORTH_EAST, MovementFlag.BLOCK_MOVEMENT_EAST, MovementFlag.BLOCK_MOVEMENT_SOUTH_EAST, MovementFlag.BLOCK_MOVEMENT_SOUTH, MovementFlag.BLOCK_MOVEMENT_SOUTH_WEST, MovementFlag.BLOCK_MOVEMENT_WEST};
    private final HashSet<Integer> tutorialIslandRegionIds = new HashSet();
    private int totalTilesUsed;
    private int remainingTiles;
    private int xpUntilNextTile;
    private LocalPoint lastTile;
    private int lastPlane;
    private boolean lastAutoTilesConfig = false;
    private boolean inHouse = false;
    private long totalXp;

    @Provides
    TilemanModeConfig provideConfig(ConfigManager configManager) {
        return (TilemanModeConfig)configManager.getConfig(TilemanModeConfig.class);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction().getId() != MenuAction.RUNELITE.getId() || !event.getMenuOption().equals(MARK) && !event.getMenuOption().equals(UNMARK)) {
            return;
        }
        Tile target = this.client.getSelectedSceneTile();
        if (target == null) {
            return;
        }
        this.handleMenuOption(target.getLocalLocation(), event.getMenuOption().equals(MARK));
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        boolean hotKeyPressed = this.client.isKeyPressed(81);
        if (hotKeyPressed && event.getOption().equals(WALK_HERE)) {
            Tile selectedSceneTile = this.client.getSelectedSceneTile();
            if (selectedSceneTile == null) {
                return;
            }
            WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)selectedSceneTile.getLocalLocation());
            int regionId = worldPoint.getRegionID();
            TilemanModeTile point = new TilemanModeTile(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), this.client.getPlane());
            this.client.createMenuEntry(-1).setOption(this.getTiles(regionId).contains(point) ? UNMARK : MARK).setTarget(event.getTarget()).setType(MenuAction.RUNELITE);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.autoMark();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            this.lastTile = null;
            return;
        }
        this.loadPoints();
        this.updateTileCounter();
        this.inHouse = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
        LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerPos);
        if (playerPosLocal != null && this.config.automarkTiles() && !this.lastAutoTilesConfig) {
            this.handleWalkedToTile(playerPosLocal);
        }
        this.lastAutoTilesConfig = this.config.automarkTiles();
        this.updateTileCounter();
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        if (gameObject.getId() == 4525) {
            this.inHouse = true;
        }
    }

    protected void startUp() {
        this.tutorialIslandRegionIds.add(12079);
        this.tutorialIslandRegionIds.add(12080);
        this.tutorialIslandRegionIds.add(12335);
        this.tutorialIslandRegionIds.add(12336);
        this.tutorialIslandRegionIds.add(12592);
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.overlayManager.add((Overlay)this.worldMapOverlay);
        this.overlayManager.add((Overlay)this.infoOverlay);
        this.loadPoints();
        this.updateTileCounter();
        log.debug("startup");
        TilemanImportPanel panel = new TilemanImportPanel(this);
        NavigationButton navButton = NavigationButton.builder().tooltip("Tileman Import").icon(ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/icon.png")).priority(70).panel((PluginPanel)panel).build();
        this.clientToolbar.addNavigation(navButton);
    }

    protected void shutDown() {
        this.tutorialIslandRegionIds.clear();
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.overlayManager.remove((Overlay)this.worldMapOverlay);
        this.overlayManager.remove((Overlay)this.infoOverlay);
        this.points.clear();
    }

    private void autoMark() {
        WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
        if (playerPos == null) {
            return;
        }
        LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerPos);
        if (playerPosLocal == null) {
            return;
        }
        long currentTotalXp = this.client.getOverallExperience();
        if ((this.lastTile == null || this.lastTile.distanceTo(playerPosLocal) != 0 && this.lastPlane == playerPos.getPlane() || this.lastPlane != playerPos.getPlane()) && !this.regionIsOnTutorialIsland(playerPos.getRegionID())) {
            this.handleWalkedToTile(playerPosLocal);
            this.lastTile = playerPosLocal;
            this.lastPlane = this.client.getPlane();
            this.updateTileCounter();
            log.debug("player moved");
            log.debug("last tile={}  distance={}", (Object)this.lastTile, this.lastTile == null ? "null" : Integer.valueOf(this.lastTile.distanceTo(playerPosLocal)));
        } else if (this.totalXp != currentTotalXp) {
            this.updateTileCounter();
            this.totalXp = currentTotalXp;
        }
    }

    public void importGroundMarkerTiles() {
        List<String> groundMarkerRegions = this.getAllRegionIds("groundMarker");
        List<String> tilemanModeRegions = this.getAllRegionIds(CONFIG_GROUP);
        for (String region : groundMarkerRegions) {
            ArrayList<TilemanModeTile> groundMarkerTiles = new ArrayList<TilemanModeTile>(this.getConfiguration("groundMarker", REGION_PREFIX + region));
            if (tilemanModeRegions.contains(region)) {
                ArrayList<TilemanModeTile> regionTiles = new ArrayList<TilemanModeTile>(this.getTiles(region));
                int regionOriginalSize = regionTiles.size();
                for (TilemanModeTile groundMarkerTile : groundMarkerTiles) {
                    if (regionTiles.contains(groundMarkerTile)) continue;
                    regionTiles.add(groundMarkerTile);
                }
                if (regionOriginalSize == regionTiles.size()) continue;
                this.savePoints(Integer.parseInt(region), regionTiles);
                continue;
            }
            this.savePoints(Integer.parseInt(region), groundMarkerTiles);
        }
        this.loadPoints();
    }

    List<String> getAllRegionIds(String configGroup) {
        return this.removeRegionPrefixes(this.configManager.getConfigurationKeys(configGroup + ".region"));
    }

    private List<String> removeRegionPrefixes(List<String> regions) {
        ArrayList<String> trimmedRegions = new ArrayList<String>();
        for (String region : regions) {
            trimmedRegions.add(this.removeRegionPrefix(region));
        }
        return trimmedRegions;
    }

    private String removeRegionPrefix(String region) {
        return region.substring(region.indexOf(95) + 1);
    }

    Collection<TilemanModeTile> getTiles(int regionId) {
        return this.getConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
    }

    private Collection<TilemanModeTile> getTiles(String regionId) {
        return this.getConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
    }

    private void updateTileCounter() {
        List regions = this.configManager.getConfigurationKeys("tilemanMode.region");
        int totalTiles = 0;
        for (String region : regions) {
            Collection<TilemanModeTile> regionTiles = this.getTiles(this.removeRegionPrefix(region));
            totalTiles += regionTiles.size();
        }
        log.debug("Updating tile counter");
        this.updateTotalTilesUsed(totalTiles);
        this.updateRemainingTiles(totalTiles);
        this.updateXpUntilNextTile();
    }

    private void updateTotalTilesUsed(int totalTilesCount) {
        this.totalTilesUsed = totalTilesCount;
    }

    private void updateRemainingTiles(int placedTiles) {
        int earnedTiles = this.config.tilesOffset();
        if (!this.config.excludeExp()) {
            earnedTiles += (int)this.client.getOverallExperience() / this.config.expPerTile();
        }
        if (this.config.includeTotalLevel()) {
            earnedTiles += this.client.getTotalLevel();
        }
        this.remainingTiles = earnedTiles - placedTiles;
    }

    private void updateXpUntilNextTile() {
        this.xpUntilNextTile = this.config.expPerTile() - Integer.parseInt(Long.toString(this.client.getOverallExperience() % (long)this.config.expPerTile()));
    }

    private Collection<TilemanModeTile> getConfiguration(String configGroup, String key) {
        String json = this.configManager.getConfiguration(configGroup, key);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)GSON.fromJson(json, new TypeToken<List<TilemanModeTile>>(){}.getType());
    }

    private void loadPoints() {
        this.points.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int regionId : regions) {
            log.debug("Loading points for region {}", (Object)regionId);
            Collection<WorldPoint> worldPoint = this.translateToWorldPoint(this.getTiles(regionId));
            this.points.addAll(worldPoint);
        }
        this.updateTileCounter();
    }

    private void savePoints(int regionId, Collection<TilemanModeTile> points) {
        if (points == null || points.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
            return;
        }
        String json = GSON.toJson(points);
        this.configManager.setConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId, json);
    }

    private Collection<WorldPoint> translateToWorldPoint(Collection<TilemanModeTile> points) {
        if (points.isEmpty()) {
            return Collections.emptyList();
        }
        return points.stream().map(point -> WorldPoint.fromRegion((int)point.getRegionId(), (int)point.getRegionX(), (int)point.getRegionY(), (int)point.getZ())).flatMap(worldPoint -> {
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)worldPoint);
            return localWorldPoints.stream();
        }).collect(Collectors.toList());
    }

    int getTotalTiles() {
        return this.totalTilesUsed;
    }

    int getRemainingTiles() {
        return this.remainingTiles;
    }

    private void handleMenuOption(LocalPoint selectedPoint, boolean markedValue) {
        if (selectedPoint == null) {
            return;
        }
        this.updateTileMark(selectedPoint, markedValue);
    }

    private void handleWalkedToTile(LocalPoint currentPlayerPoint) {
        if (currentPlayerPoint == null || this.inHouse || !this.config.automarkTiles()) {
            return;
        }
        this.updateTileMark(currentPlayerPoint, true);
        if (this.lastTile != null) {
            int xDiff = currentPlayerPoint.getX() - this.lastTile.getX();
            int yDiff = currentPlayerPoint.getY() - this.lastTile.getY();
            int yModifier = yDiff / 2;
            int xModifier = xDiff / 2;
            switch (this.lastTile.distanceTo(currentPlayerPoint)) {
                case 0: 
                case 128: {
                    return;
                }
                case 181: {
                    this.handleCornerMovement(xDiff, yDiff);
                    break;
                }
                case 256: 
                case 362: {
                    this.fillTile(new LocalPoint(this.lastTile.getX() + xModifier, this.lastTile.getY() + yModifier));
                    break;
                }
                case 286: {
                    this.handleLMovement(xDiff, yDiff);
                }
            }
        }
    }

    private void handleLMovement(int xDiff, int yDiff) {
        int tileBesideYDiff;
        int tileBesideXDiff;
        int xModifier = xDiff / 2;
        int yModifier = yDiff / 2;
        if (Math.abs(yDiff) == 128) {
            tileBesideXDiff = xDiff;
            tileBesideYDiff = 0;
        } else {
            tileBesideXDiff = 0;
            tileBesideYDiff = yDiff;
        }
        MovementFlag[] tileBesideFlagsArray = this.getTileMovementFlags(this.lastTile.getX() + tileBesideXDiff, this.lastTile.getY() + tileBesideYDiff);
        if (tileBesideFlagsArray.length == 0) {
            this.fillTile(new LocalPoint(this.lastTile.getX() + tileBesideXDiff / 2, this.lastTile.getY() + tileBesideYDiff / 2));
        } else if (this.containsAnyOf(this.fullBlock, tileBesideFlagsArray)) {
            if (yModifier == 64) {
                yModifier = 128;
            } else if (xModifier == 64) {
                xModifier = 128;
            }
            this.fillTile(new LocalPoint(this.lastTile.getX() + xModifier, this.lastTile.getY() + yModifier));
        } else if (this.containsAnyOf(this.allDirections, tileBesideFlagsArray)) {
            MovementFlag direction2;
            MovementFlag direction1 = yDiff == 256 || yDiff == -128 ? MovementFlag.BLOCK_MOVEMENT_SOUTH : MovementFlag.BLOCK_MOVEMENT_NORTH;
            if (this.containsAnyOf(tileBesideFlagsArray, new MovementFlag[]{direction1, direction2 = xDiff == 256 || xDiff == -128 ? MovementFlag.BLOCK_MOVEMENT_WEST : MovementFlag.BLOCK_MOVEMENT_EAST})) {
                if (yModifier == 64) {
                    yModifier = 128;
                } else if (xModifier == 64) {
                    xModifier = 128;
                }
                this.fillTile(new LocalPoint(this.lastTile.getX() + xModifier, this.lastTile.getY() + yModifier));
            } else {
                this.fillTile(new LocalPoint(this.lastTile.getX() + tileBesideXDiff / 2, this.lastTile.getY() + tileBesideYDiff / 2));
            }
        }
    }

    private void handleCornerMovement(int xDiff, int yDiff) {
        LocalPoint southPoint;
        LocalPoint northPoint;
        if (yDiff > 0) {
            northPoint = new LocalPoint(this.lastTile.getX(), this.lastTile.getY() + yDiff);
            southPoint = new LocalPoint(this.lastTile.getX() + xDiff, this.lastTile.getY());
        } else {
            northPoint = new LocalPoint(this.lastTile.getX() + xDiff, this.lastTile.getY());
            southPoint = new LocalPoint(this.lastTile.getX(), this.lastTile.getY() + yDiff);
        }
        MovementFlag[] northTile = this.getTileMovementFlags(northPoint);
        MovementFlag[] southTile = this.getTileMovementFlags(southPoint);
        if (xDiff + yDiff == 0) {
            if (this.containsAnyOf(this.fullBlock, northTile) || this.containsAnyOf(northTile, new MovementFlag[]{MovementFlag.BLOCK_MOVEMENT_SOUTH, MovementFlag.BLOCK_MOVEMENT_WEST})) {
                this.fillTile(southPoint);
            } else if (this.containsAnyOf(this.fullBlock, southTile) || this.containsAnyOf(southTile, new MovementFlag[]{MovementFlag.BLOCK_MOVEMENT_NORTH, MovementFlag.BLOCK_MOVEMENT_EAST})) {
                this.fillTile(northPoint);
            }
        } else if (this.containsAnyOf(this.fullBlock, northTile) || this.containsAnyOf(northTile, new MovementFlag[]{MovementFlag.BLOCK_MOVEMENT_SOUTH, MovementFlag.BLOCK_MOVEMENT_EAST})) {
            this.fillTile(southPoint);
        } else if (this.containsAnyOf(this.fullBlock, southTile) || this.containsAnyOf(southTile, new MovementFlag[]{MovementFlag.BLOCK_MOVEMENT_NORTH, MovementFlag.BLOCK_MOVEMENT_WEST})) {
            this.fillTile(northPoint);
        }
    }

    private MovementFlag[] getTileMovementFlags(int x, int y) {
        LocalPoint pointBeside = new LocalPoint(x, y);
        CollisionData[] collisionData = this.client.getCollisionMaps();
        assert (collisionData != null);
        int[][] collisionDataFlags = collisionData[this.client.getPlane()].getFlags();
        Set<MovementFlag> tilesBesideFlagsSet = MovementFlag.getSetFlags(collisionDataFlags[pointBeside.getSceneX()][pointBeside.getSceneY()]);
        MovementFlag[] tileBesideFlagsArray = new MovementFlag[tilesBesideFlagsSet.size()];
        tilesBesideFlagsSet.toArray(tileBesideFlagsArray);
        return tileBesideFlagsArray;
    }

    private MovementFlag[] getTileMovementFlags(LocalPoint localPoint) {
        return this.getTileMovementFlags(localPoint.getX(), localPoint.getY());
    }

    private boolean containsAnyOf(MovementFlag[] comparisonFlags, MovementFlag[] flagsToCompare) {
        if (comparisonFlags.length == 0 || flagsToCompare.length == 0) {
            return false;
        }
        for (MovementFlag flag : flagsToCompare) {
            if (!Arrays.asList(comparisonFlags).contains((Object)flag)) continue;
            return true;
        }
        return false;
    }

    private boolean regionIsOnTutorialIsland(int regionId) {
        return this.tutorialIslandRegionIds.contains(regionId);
    }

    private void fillTile(LocalPoint localPoint) {
        if (this.lastPlane != this.client.getPlane()) {
            return;
        }
        this.updateTileMark(localPoint, true);
    }

    private void updateTileMark(LocalPoint localPoint, boolean markedValue) {
        if (this.containsAnyOf(this.getTileMovementFlags(localPoint), this.fullBlock)) {
            return;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
        int regionId = worldPoint.getRegionID();
        TilemanModeTile point = new TilemanModeTile(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), this.client.getPlane());
        log.debug("Updating point: {} - {}", (Object)point, (Object)worldPoint);
        ArrayList<TilemanModeTile> tilemanModeTiles = new ArrayList<TilemanModeTile>(this.getTiles(regionId));
        if (markedValue) {
            if (!tilemanModeTiles.contains(point) && (this.config.allowTileDeficit() || this.remainingTiles > 0)) {
                tilemanModeTiles.add(point);
            }
        } else {
            tilemanModeTiles.remove(point);
        }
        this.savePoints(regionId, tilemanModeTiles);
        this.loadPoints();
    }

    int getXpUntilNextTile() {
        return this.xpUntilNextTile;
    }

    List<WorldPoint> getPoints() {
        return this.points;
    }

    static enum MovementFlag {
        BLOCK_MOVEMENT_NORTH_WEST(1),
        BLOCK_MOVEMENT_NORTH(2),
        BLOCK_MOVEMENT_NORTH_EAST(4),
        BLOCK_MOVEMENT_EAST(8),
        BLOCK_MOVEMENT_SOUTH_EAST(16),
        BLOCK_MOVEMENT_SOUTH(32),
        BLOCK_MOVEMENT_SOUTH_WEST(64),
        BLOCK_MOVEMENT_WEST(128),
        BLOCK_MOVEMENT_OBJECT(256),
        BLOCK_MOVEMENT_FLOOR_DECORATION(262144),
        BLOCK_MOVEMENT_FLOOR(0x200000),
        BLOCK_MOVEMENT_FULL(2359552);

        private int flag;

        public static Set<MovementFlag> getSetFlags(int collisionData) {
            return Arrays.stream(MovementFlag.values()).filter(movementFlag -> (movementFlag.flag & collisionData) != 0).collect(Collectors.toSet());
        }

        private MovementFlag(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }
    }
}

