/*
 * Decompiled with CFR 0.152.
 */
package com.tileman;

import com.tileman.TilemanModeConfig;
import com.tileman.TilemanModePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class TilemanModeOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final TilemanModePlugin plugin;
    @Inject
    private TilemanModeConfig config;

    @Inject
    private TilemanModeOverlay(Client client, TilemanModeConfig config, TilemanModePlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        List<WorldPoint> points = this.plugin.getPoints();
        for (WorldPoint point : points) {
            if (point.getPlane() != this.client.getPlane()) continue;
            this.drawTile(graphics, point);
        }
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point) {
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return;
        }
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)this.getTileColor());
    }

    private Color getTileColor() {
        if (this.config.enableTileWarnings()) {
            if (this.plugin.getRemainingTiles() <= 0) {
                return Color.RED;
            }
            if (this.plugin.getRemainingTiles() <= this.config.warningLimit()) {
                return new Color(255, 153, 0);
            }
        }
        return this.config.markerColor();
    }
}

