/*
 * Decompiled with CFR 0.152.
 */
package com.tileman;

import com.tileman.TilemanModeConfig;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TilemanModeConfigEvaluator
implements TilemanModeConfig {
    private static final Logger log = LoggerFactory.getLogger(TilemanModeConfigEvaluator.class);
    @Inject
    private TilemanModeConfig config;
    private static final int TILEMAN_TILE_OFFSET = 9;
    private static final boolean TILEMAN_INCLUDE_TOTAL_LEVEL = false;
    private static final int STRICT_TILEMAN_TILE_OFFSET = 0;
    private static final boolean STRICT_TILEMAN_INCLUDE_TOTAL_LEVEL = false;
    private static final int EXPEDITIOUS_TILEMAN_TILE_OFFSET = 0;
    private static final boolean EXPEDITIOUS_TILEMAN_INCLUDE_TOTAL_LEVEL = true;
    private static Map<TilemanModeConfig.TilemanGameMode, Integer> gameModeToTilesOffsetDefault = new HashMap<TilemanModeConfig.TilemanGameMode, Integer>();
    private static Map<TilemanModeConfig.TilemanGameMode, Boolean> gameModeToIncludeTotalLevelDefault;

    TilemanModeConfigEvaluator() {
    }

    @Override
    public int tilesOffset() {
        if (this.config.enableCustomGameMode()) {
            return this.config.tilesOffset();
        }
        return gameModeToTilesOffsetDefault.get((Object)this.config.gameMode());
    }

    @Override
    public boolean includeTotalLevel() {
        if (this.config.enableCustomGameMode()) {
            return this.config.includeTotalLevel();
        }
        return gameModeToIncludeTotalLevelDefault.get((Object)this.config.gameMode());
    }

    @Override
    public int expPerTile() {
        if (this.config.enableCustomGameMode()) {
            return this.config.expPerTile();
        }
        return 1000;
    }

    @Override
    public boolean excludeExp() {
        if (this.config.enableCustomGameMode()) {
            return this.config.excludeExp();
        }
        return false;
    }

    @Override
    public boolean automarkTiles() {
        return this.config.automarkTiles();
    }

    @Override
    public boolean allowTileDeficit() {
        return this.config.allowTileDeficit();
    }

    static {
        gameModeToTilesOffsetDefault.put(TilemanModeConfig.TilemanGameMode.COMMUNITY, 9);
        gameModeToTilesOffsetDefault.put(TilemanModeConfig.TilemanGameMode.STRICT, 0);
        gameModeToTilesOffsetDefault.put(TilemanModeConfig.TilemanGameMode.ACCELERATED, 0);
        gameModeToIncludeTotalLevelDefault = new HashMap<TilemanModeConfig.TilemanGameMode, Boolean>();
        gameModeToIncludeTotalLevelDefault.put(TilemanModeConfig.TilemanGameMode.COMMUNITY, false);
        gameModeToIncludeTotalLevelDefault.put(TilemanModeConfig.TilemanGameMode.STRICT, false);
        gameModeToIncludeTotalLevelDefault.put(TilemanModeConfig.TilemanGameMode.ACCELERATED, true);
    }
}

