/*
 * Decompiled with CFR 0.152.
 */
package com.tileman;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="tilemanMode")
public interface TilemanModeConfig
extends Config {
    @ConfigSection(name="Game Mode", description="Select your Tileman game mode'", position=1)
    public static final String gameModeSection = "gameMode";
    @ConfigSection(name="Settings", description="Settings'", position=2)
    public static final String settingsSection = "settings";
    @ConfigSection(name="Custom Game Mode", description="Create a custom Tileman game mode. Be sure to 'Enable Custom Game Mode'", position=99, closedByDefault=true)
    public static final String customGameModeSection = "customGameMode";

    @Alpha
    @ConfigItem(keyName="gameMode", name="Game Mode", section="gameMode", description="Select your Tileman game mode", position=1)
    default public TilemanGameMode gameMode() {
        return TilemanGameMode.COMMUNITY;
    }

    @ConfigItem(keyName="automarkTiles", name="Auto-mark tiles", section="settings", description="Automatically mark tiles as you walk.", position=2)
    default public boolean automarkTiles() {
        return false;
    }

    @Range(min=-2147483648)
    @ConfigItem(keyName="warningLimit", name="Unspent tiles warning", section="settings", description="Highlights overlay when limit reached", position=3)
    default public int warningLimit() {
        return 20;
    }

    @ConfigItem(keyName="enableTilesWarning", name="Enable Tiles Warning", section="settings", description="Turns on tile warnings when you reach your set limit or 0.", position=4)
    default public boolean enableTileWarnings() {
        return false;
    }

    @ConfigItem(keyName="allowTileDeficit", name="Allow Tile Deficit", section="settings", description="Allows you to place tiles after you have none left.", position=5)
    default public boolean allowTileDeficit() {
        return false;
    }

    @ConfigItem(keyName="drawOnMinimap", name="Draw tiles on minimap", section="settings", description="Configures whether marked tiles should be drawn on minimap", position=6)
    default public boolean drawTilesOnMinimap() {
        return false;
    }

    @ConfigItem(keyName="drawTilesOnWorldMap", name="Draw tiles on world map", section="settings", description="Configures whether marked tiles should be drawn on world map", position=5)
    default public boolean drawTilesOnWorldMap() {
        return false;
    }

    @Alpha
    @ConfigItem(keyName="markerColor", name="Tile Color", section="settings", description="Configures the color of the tiles", position=6)
    default public Color markerColor() {
        return Color.YELLOW;
    }

    @ConfigItem(keyName="enableCustomGameMode", name="Enable Custom Game Mode", description="Settings below will override Game Mode defaults", section="customGameMode", position=1)
    default public boolean enableCustomGameMode() {
        return false;
    }

    @Range(min=-2147483648)
    @ConfigItem(keyName="tilesOffset", name="Bonus tiles", description="Add more tiles to your limit, set to 0 for off", section="customGameMode", position=2)
    default public int tilesOffset() {
        return 9;
    }

    @ConfigItem(keyName="includeTotalLevels", name="Include total level", description="Includes total level in usable tiles", section="customGameMode", position=3)
    default public boolean includeTotalLevel() {
        return false;
    }

    @ConfigItem(keyName="excludeExp", name="Exclude Experience", description="Includes experience / 1000 in usable tiles", section="customGameMode", position=4)
    default public boolean excludeExp() {
        return false;
    }

    @Range(min=500)
    @ConfigItem(keyName="expPerTile", name="Exp per Tile", description="Determines how much exp you require per tile", section="customGameMode", position=5)
    default public int expPerTile() {
        return 1000;
    }

    public static enum TilemanGameMode {
        COMMUNITY,
        STRICT,
        ACCELERATED;

    }
}

