/*
 * Decompiled with CFR 0.152.
 */
package com.tileman;

import com.tileman.TilemanModePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TilemanImportPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(TilemanImportPanel.class);
    private final TilemanModePlugin plugin;

    public TilemanImportPanel(TilemanModePlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        JLabel title = new JLabel();
        title.setText("Tileman Mode Import Panel");
        title.setForeground(Color.WHITE);
        northPanel.add((Component)title, "North");
        JPanel infoPanel = new JPanel();
        infoPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        infoPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        infoPanel.setLayout(new GridLayout(0, 1));
        JLabel info = new JLabel(TilemanImportPanel.htmlLabel("Clicking the Import button below will migrate all tiles marked with the Ground Marker plugin into the Tileman Mode plugin. They will NOT be removed from the Ground Marker Plugin.", "#FFFFFF"));
        JLabel warning = new JLabel(TilemanImportPanel.htmlLabel("WARNING: This directly modifies RuneLite's settings.properties file. You should make a back up before importing.", "#FFFF00"));
        infoPanel.add(info);
        infoPanel.add(warning);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JButton importButton = new JButton("Import");
        centerPanel.add((Component)importButton, "South");
        importButton.addActionListener(l -> plugin.importGroundMarkerTiles());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        importButton.setToolTipText("Import Ground Markers");
        this.add(northPanel, "North");
        this.add(infoPanel, "Center");
        this.add(centerPanel, "South");
    }

    private static String htmlLabel(String key, String color) {
        return "<html><body style = 'color:" + color + "'>" + key + "</body></html>";
    }
}

