/*
 * Decompiled with CFR 0.152.
 */
package com.tileman;

import com.tileman.TilemanModeConfig;
import com.tileman.TilemanModePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

class TileInfoOverlay
extends OverlayPanel {
    private final Client client;
    private final TilemanModeConfig config;
    private final TilemanModePlugin plugin;
    private static final String UNSPENT_TILES_STRING = "Available Tiles:";
    private static final String XP_UNTIL_NEXT_TILE = "XP Until Next Tile:";
    private static final String UNLOCKED_TILES = "Tiles Unlocked:";
    private static final String[] STRINGS = new String[]{"Available Tiles:", "XP Until Next Tile:", "Tiles Unlocked:"};

    @Inject
    private TileInfoOverlay(Client client, TilemanModeConfig config, TilemanModePlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.MED);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Tileman Mode overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        String unspentTiles = this.addCommasToNumber(this.plugin.getRemainingTiles());
        String unlockedTiles = this.addCommasToNumber(this.plugin.getTotalTiles());
        String xpUntilNextTile = this.addCommasToNumber(this.plugin.getXpUntilNextTile());
        this.panelComponent.getChildren().add(LineComponent.builder().left(UNSPENT_TILES_STRING).leftColor(this.getTextColor()).right(unspentTiles).rightColor(this.getTextColor()).build());
        if (!this.config.enableCustomGameMode() || !this.config.excludeExp()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(XP_UNTIL_NEXT_TILE).right(xpUntilNextTile).build());
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left(UNLOCKED_TILES).right(unlockedTiles).build());
        this.panelComponent.setPreferredSize(new Dimension(this.getLongestStringWidth(STRINGS, graphics) + this.getLongestStringWidth(new String[]{unlockedTiles, unspentTiles}, graphics), 0));
        return super.render(graphics);
    }

    private Color getTextColor() {
        if (this.config.enableTileWarnings()) {
            if (this.plugin.getRemainingTiles() <= 0) {
                return Color.RED;
            }
            if (this.plugin.getRemainingTiles() <= this.config.warningLimit()) {
                return Color.ORANGE;
            }
        }
        return Color.WHITE;
    }

    private int getLongestStringWidth(String[] strings, Graphics2D graphics) {
        int longest = graphics.getFontMetrics().stringWidth("000000");
        for (String i : strings) {
            int currentItemWidth = graphics.getFontMetrics().stringWidth(i);
            if (currentItemWidth <= longest) continue;
            longest = currentItemWidth;
        }
        return longest;
    }

    private String addCommasToNumber(int number) {
        String input = Integer.toString(number);
        StringBuilder output = new StringBuilder();
        for (int x = input.length() - 1; x >= 0; --x) {
            int lastPosition = input.length() - x - 1;
            if (lastPosition != 0 && lastPosition % 3 == 0) {
                output.append(",");
            }
            output.append(input.charAt(x));
        }
        return output.reverse().toString();
    }
}

