/*
 * Decompiled with CFR 0.152.
 */
package com.github.adituv.runedokuplugin;

public class SudokuSolver {
    private final int size;
    private final int[][] puzzle;
    private final int[][] board;

    private boolean additionIsValid(int x, int y, int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.board[y][i] != n) continue;
            return false;
        }
        for (int j = 0; j < this.size; ++j) {
            if (this.board[j][x] != n) continue;
            return false;
        }
        for (int k = 0; k < this.size; ++k) {
            int j;
            int i;
            if (this.size == 4) {
                i = x / 2 * 2 + k % 2;
                j = y / 2 * 2 + k / 2;
            } else {
                i = x / 3 * 3 + k % 3;
                j = y / 3 * 3 + k / 3;
            }
            if (this.board[j][i] != n) continue;
            return false;
        }
        return true;
    }

    public int[][] getSolution() {
        return this.board;
    }

    public boolean solve() {
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                if (this.board[j][i] != 0) continue;
                for (int n = 1; n <= this.size; ++n) {
                    if (!this.additionIsValid(i, j, n)) continue;
                    this.board[j][i] = n;
                    if (this.solve()) {
                        return true;
                    }
                    this.board[j][i] = 0;
                }
                return false;
            }
        }
        return true;
    }

    public SudokuSolver(int[][] puzzle) {
        this.size = puzzle.length;
        this.puzzle = puzzle;
        this.board = new int[this.size][this.size];
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                this.board[j][i] = puzzle[j][i];
            }
        }
    }
}

