/*
 * Decompiled with CFR 0.152.
 */
package com.github.adituv.runedokuplugin;

import com.github.adituv.runedokuplugin.RunedokuBoard;
import com.github.adituv.runedokuplugin.RunedokuCell;
import com.github.adituv.runedokuplugin.RunedokuConfig;
import com.github.adituv.runedokuplugin.RunedokuConstants;
import com.github.adituv.runedokuplugin.RunedokuOverlay;
import com.github.adituv.runedokuplugin.RunedokuRune;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.CanvasSizeChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Runedoku Helper")
public class RunedokuPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RunedokuPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private RunedokuConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RunedokuOverlay overlay;
    private RunedokuRune selectedRune = RunedokuRune.WATER_RUNE;
    private String selectedRuneText = "<col=ff9040>Water rune</col>";
    private RunedokuBoard board = null;
    private boolean markOnShift;

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("runedoku")) {
            switch (configChanged.getKey()) {
                case "useNumbers": {
                    this.overlay.setShouldDrawNumbers(this.config.useNumbers());
                    break;
                }
                case "showSolution": {
                    this.overlay.setShouldShowSolution(this.config.showSolution());
                    break;
                }
                case "solutionColor": {
                    this.overlay.setSolutionColor(this.config.solutionColor());
                    break;
                }
                case "foregroundColor": {
                    this.overlay.setForegroundColor(this.config.foregroundColor());
                    break;
                }
                case "outlineColor": {
                    this.overlay.setOutlineColor(this.config.outlineColor());
                    break;
                }
                case "errorColor": {
                    this.overlay.setErrorColor(this.config.errorColor());
                    break;
                }
                case "markOnShift": {
                    this.markOnShift = this.config.markOnShift();
                }
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 292) {
            log.debug("Runedoku widget loaded");
            this.selectedRune = RunedokuRune.WATER_RUNE;
            this.clientThread.invokeLater(() -> {
                Widget boardWidget = this.client.getWidget(RunedokuConstants.RUNEDOKU_BOARD_WIDGET_ID);
                if (boardWidget != null) {
                    this.board = new RunedokuBoard(boardWidget, this.config.showSolution());
                    this.board.updateCells();
                    this.overlay.activate(this.board);
                    this.overlay.updateSelectedRune(this.selectedRune);
                }
            });
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed widgetClosed) {
        if (widgetClosed.getGroupId() == 292) {
            this.board = null;
            this.overlay.deactivate();
        }
    }

    @Subscribe
    public void onCanvasSizeChanged(CanvasSizeChanged canvasSizeChanged) {
        if (this.board != null) {
            this.board.updateCells();
            if (this.config.showSolution()) {
                this.board.solveBoard();
            }
        }
    }

    @Subscribe(priority=-1.0f)
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        if (menuOptionClicked.getWidgetId() == RunedokuConstants.RUNEDOKU_RUNE_WIDGET_ID) {
            this.clientThread.invokeLater(() -> {
                Widget w = this.client.getWidget(menuOptionClicked.getWidgetId());
                for (Widget cw : w.getChildren()) {
                    if (cw.getBorderType() != 2) continue;
                    this.selectedRune = RunedokuRune.getByItemId(cw.getItemId());
                    this.overlay.updateSelectedRune(this.selectedRune);
                    String name = cw.getName();
                    if (name.isEmpty()) {
                        name = "<col=ff9040>None</col>";
                    }
                    this.selectedRuneText = name;
                    break;
                }
            });
        } else if (menuOptionClicked.getWidgetId() == RunedokuConstants.RUNEDOKU_BOARD_CLICK_WIDGET_ID) {
            if (menuOptionClicked.getMenuOption().equals("Mark")) {
                menuOptionClicked.consume();
                int cellId = menuOptionClicked.getActionParam();
                int sudokuIndex = this.selectedRune.getSudokuNumber() - 1;
                log.debug(String.format("Marking cell=%d num=%d", cellId, sudokuIndex + 1));
                if (sudokuIndex >= 0) {
                    RunedokuCell c = this.board.getCell(cellId);
                    boolean[] marks = c.getMarks();
                    boolean bl = !marks[sudokuIndex];
                    marks[sudokuIndex] = bl;
                    c.setMarks(marks);
                }
            } else {
                this.clientThread.invokeLater(() -> this.board.updateCells());
            }
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened menuOpened) {
        int widgetId = menuOpened.getFirstEntry().getParam1();
        int widgetIndex = menuOpened.getFirstEntry().getParam0();
        if (widgetId == RunedokuConstants.RUNEDOKU_BOARD_CLICK_WIDGET_ID && this.selectedRune != null) {
            Widget cell = this.client.getWidget(RunedokuConstants.RUNEDOKU_BOARD_WIDGET_ID).getChild(widgetIndex);
            if (cell.getBorderType() == 2) {
                return;
            }
            MenuEntry markEntry = this.makeMarkMenuEntry(widgetId, widgetIndex);
            MenuEntry[] newEntries = this.insertMarkMenuEntry(markEntry);
            this.client.setMenuEntries(newEntries);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded menuEntryAdded) {
        if (menuEntryAdded.getActionParam1() != RunedokuConstants.RUNEDOKU_BOARD_CLICK_WIDGET_ID || this.client.isMenuOpen()) {
            return;
        }
        if (this.markOnShift && this.client.isKeyPressed(81) && menuEntryAdded.getOption().startsWith("Place")) {
            MenuEntry[] menuEntries;
            for (MenuEntry entry : menuEntries = this.client.getMenuEntries()) {
                if (!entry.getOption().equals(menuEntryAdded.getOption())) continue;
                entry.setOption("Mark");
                entry.setTarget(this.selectedRuneText);
            }
            this.client.setMenuEntries(menuEntries);
        }
    }

    private MenuEntry makeMarkMenuEntry(int widgetId, int widgetIndex) {
        return this.client.createMenuEntry(MenuAction.CC_OP.getId()).setOption("Mark").setTarget(this.selectedRuneText).setType(MenuAction.CC_OP).setParam0(widgetIndex).setParam1(widgetId);
    }

    private MenuEntry[] insertMarkMenuEntry(MenuEntry markEntry) {
        MenuEntry[] oldEntries = this.client.getMenuEntries();
        MenuEntry[] newEntries = new MenuEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        if (this.markOnShift && this.client.isKeyPressed(81)) {
            newEntries[newEntries.length - 1] = markEntry;
        } else {
            newEntries[newEntries.length - 2] = markEntry;
            newEntries[newEntries.length - 1] = oldEntries[oldEntries.length - 1];
        }
        return newEntries;
    }

    protected void loadConfig() {
        this.overlay.setShouldDrawNumbers(this.config.useNumbers());
        this.overlay.setShouldShowSolution(this.config.showSolution());
        this.overlay.setSolutionColor(this.config.solutionColor());
        this.overlay.setForegroundColor(this.config.foregroundColor());
        this.overlay.setOutlineColor(this.config.outlineColor());
        this.overlay.setErrorColor(this.config.errorColor());
        this.markOnShift = this.config.markOnShift();
    }

    protected void startUp() throws Exception {
        this.loadConfig();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    RunedokuConfig provideConfig(ConfigManager configManager) {
        return (RunedokuConfig)configManager.getConfig(RunedokuConfig.class);
    }
}

