/*
 * Decompiled with CFR 0.152.
 */
package com.github.adituv.runedokuplugin;

import com.github.adituv.runedokuplugin.OutlineTextComponent;
import com.github.adituv.runedokuplugin.RunedokuBoard;
import com.github.adituv.runedokuplugin.RunedokuCell;
import com.github.adituv.runedokuplugin.RunedokuConstants;
import com.github.adituv.runedokuplugin.RunedokuPlugin;
import com.github.adituv.runedokuplugin.RunedokuRune;
import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunedokuOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(RunedokuOverlay.class);
    private final Client client;
    private boolean isActive;
    private RunedokuBoard board;
    private RunedokuRune selectedRune;
    private boolean shouldDrawNumbers;
    private boolean shouldShowSolution;
    private Color foregroundColor;
    private Color outlineColor;
    private Color errorColor;
    private Color solutionColor;
    private final AsyncBufferedImage[] runeImages;
    private final Font bigFont;
    private final Font markFont;
    private final int BOX_X_OFFSET = -2;
    private final int BOX_Y_OFFSET = 0;
    private final int BOX_WIDTH_OFFSET = -1;
    private final int BOX_HEIGHT_OFFSET = -1;
    private final float BIG_FONT_SIZE = 24.0f;
    private final float BIG_FONT_X_OFFSET = -2.5f;

    public Dimension render(Graphics2D graphics) {
        if (this.isActive) {
            Widget[] children;
            Widget containerWidget = this.client.getWidget(RunedokuConstants.RUNEDOKU_CONTAINER_WIDGET_ID);
            if (containerWidget == null || containerWidget.isHidden()) {
                return null;
            }
            int boardWidth = this.board.getWidth();
            if (boardWidth != 4 && boardWidth != 9) {
                log.error(String.format("render: Invalid board width %d", boardWidth));
            }
            Widget boardWidget = this.client.getWidget(RunedokuConstants.RUNEDOKU_BOARD_WIDGET_ID);
            Widget runeWidget = this.client.getWidget(RunedokuConstants.RUNEDOKU_RUNE_WIDGET_ID);
            FontMetrics bigFontMetrics = graphics.getFontMetrics(this.bigFont);
            FontMetrics markFontMetrics = graphics.getFontMetrics(this.markFont);
            if (boardWidget == null) {
                log.error("render: boardWidget is null");
                return null;
            }
            if (runeWidget == null) {
                log.error("render: runeWidget is null");
                return null;
            }
            OutlineTextComponent bigNumberText = new OutlineTextComponent();
            bigNumberText.setOutline(2, this.outlineColor);
            bigNumberText.setColor(this.foregroundColor);
            bigNumberText.setFont(this.bigFont);
            OutlineTextComponent markNumberText = new OutlineTextComponent();
            markNumberText.setOutline(1, this.outlineColor);
            markNumberText.setColor(this.foregroundColor);
            markNumberText.setFont(this.markFont);
            boolean solved = true;
            for (RunedokuCell c : this.board.getCells()) {
                if (c.getSudokuNumber() > 0) {
                    if (this.board.cellHasClash(c)) {
                        this.drawErrorBox(graphics, c.getWidget());
                    }
                    if (!this.shouldDrawNumbers) continue;
                    Widget w = c.getWidget();
                    String numberAsText = String.format("%d", c.getSudokuNumber());
                    Rectangle2D stringBounds = bigFontMetrics.getStringBounds(numberAsText, graphics);
                    double x = w.getBounds().getCenterX() - stringBounds.getCenterX() + -2.5;
                    double y = w.getBounds().getCenterY() - stringBounds.getCenterY();
                    Point location = new Point((int)x, (int)y);
                    bigNumberText.setText(numberAsText);
                    bigNumberText.setPosition(location);
                    bigNumberText.render(graphics);
                    continue;
                }
                Rectangle cellBounds = c.getWidget().getBounds();
                int xPos = cellBounds.x + -2;
                int yPos = cellBounds.y + 0 + markFontMetrics.getHeight();
                cellBounds.x += -1;
                ++cellBounds.y;
                cellBounds.width += -2;
                cellBounds.height += -2;
                StringBuilder marks = new StringBuilder("");
                for (int i = 0; i < 9; ++i) {
                    if (!c.getMarks()[i]) continue;
                    marks.append(i + 1);
                    if (marks.length() == 5) {
                        markNumberText.setText(marks.toString());
                        markNumberText.setPosition(new Point(xPos, yPos));
                        Dimension textBounds = markNumberText.render(graphics);
                        yPos += textBounds.height;
                        marks = new StringBuilder("");
                    }
                    markNumberText.setText(marks.toString());
                    markNumberText.setPosition(new Point(xPos, yPos));
                    markNumberText.render(graphics);
                }
                if (this.shouldShowSolution) {
                    if (c.getRune() != null) {
                        if (c.getRune().getSudokuNumber() != c.getSolutionNumber()) {
                            solved = false;
                        }
                    } else {
                        solved = false;
                    }
                    Color tintColor = new Color(128, 128, 153, 255);
                    float[] tintChannels = new float[]{(float)tintColor.getRed() / 255.0f, (float)tintColor.getGreen() / 255.0f, (float)tintColor.getBlue() / 255.0f, (float)tintColor.getAlpha() / 255.0f};
                    RescaleOp darkenImageOp = new RescaleOp(tintChannels, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
                    Rectangle bounds = c.getWidget().getBounds();
                    graphics.drawImage((BufferedImage)this.runeImages[c.getSolutionNumber()], darkenImageOp, bounds.x, bounds.y);
                    if (this.selectedRune != null && this.board.cellHasSolution(c) && c.getSolutionNumber() == this.selectedRune.getSudokuNumber()) {
                        this.drawSolutionBox(graphics, c.getWidget());
                    }
                    if (!this.shouldDrawNumbers) continue;
                    Widget w = c.getWidget();
                    String numberAsText = String.format("%d", c.getSolutionNumber());
                    Rectangle2D stringBounds = bigFontMetrics.getStringBounds(numberAsText, graphics);
                    double x = w.getBounds().getCenterX() - stringBounds.getCenterX() + -2.5;
                    double y = w.getBounds().getCenterY() - stringBounds.getCenterY();
                    Point location = new Point((int)x, (int)y);
                    bigNumberText.setText(numberAsText);
                    bigNumberText.setPosition(location);
                    bigNumberText.render(graphics);
                    continue;
                }
                solved = false;
            }
            if (solved) {
                this.drawComplete(graphics, this.client.getWidget(RunedokuConstants.RUNEDOKU_BUTTON_WIDGET_ID));
            }
            if ((children = runeWidget.getChildren()) == null) {
                log.error("render: runeWidget children array is null");
                return null;
            }
            for (Widget w : children) {
                RunedokuRune rune;
                if (!this.shouldDrawNumbers || (rune = RunedokuRune.getByItemId(w.getItemId())) == null) continue;
                String numberAsText = String.format("%d", rune.getSudokuNumber());
                Rectangle2D stringBounds = bigFontMetrics.getStringBounds(numberAsText, graphics);
                double x = w.getBounds().getCenterX() - stringBounds.getCenterX() + -2.5;
                double y = w.getBounds().getCenterY() - stringBounds.getCenterY();
                Point location = new Point((int)x, (int)y);
                bigNumberText.setText(numberAsText);
                bigNumberText.setPosition(location);
                bigNumberText.render(graphics);
            }
        }
        return null;
    }

    private Point getMarkLocation(int i, Graphics2D graphics, Rectangle cellBounds) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.markFont);
        double x = -1.0;
        double y = -1.0;
        int boardWidth = this.board.getWidth();
        Rectangle2D stringBounds = fontMetrics.getStringBounds(String.format("%d", i + 1), graphics);
        if (boardWidth == 4) {
            x = i % 2 == 0 ? (double)cellBounds.x : cellBounds.getMaxX() - stringBounds.getMaxX();
            y = i / 2 == 0 ? (double)cellBounds.y + stringBounds.getHeight() : cellBounds.getMaxY() + (double)fontMetrics.getDescent();
        } else if (boardWidth == 9) {
            x = i % 3 == 0 ? (double)cellBounds.x : (i % 3 == 1 ? cellBounds.getCenterX() - stringBounds.getCenterX() : cellBounds.getMaxX() - stringBounds.getMaxX());
            y = i / 3 == 0 ? (double)cellBounds.y + stringBounds.getHeight() : (i / 3 == 1 ? cellBounds.getCenterY() - stringBounds.getCenterY() + (double)fontMetrics.getDescent() / 2.0 : cellBounds.getMaxY() + (double)fontMetrics.getDescent());
        }
        return new Point((int)x, (int)y);
    }

    public void activate(RunedokuBoard board) {
        this.board = board;
        this.isActive = true;
    }

    public void deactivate() {
        this.board = null;
        this.isActive = false;
    }

    private void drawErrorBox(Graphics2D graphics, Widget w) {
        graphics.setColor(ColorUtil.colorWithAlpha((Color)this.errorColor, (int)255));
        graphics.setStroke(new BasicStroke(2.0f));
        Rectangle bounds = w.getBounds();
        graphics.drawRect(bounds.x + -2, bounds.y + 0, bounds.width + -1, bounds.height + -1);
    }

    private void drawSolutionBox(Graphics2D graphics, Widget w) {
        graphics.setColor(ColorUtil.colorWithAlpha((Color)this.solutionColor, (int)255));
        graphics.setStroke(new BasicStroke(2.0f));
        Rectangle bounds = w.getBounds();
        graphics.drawRect(bounds.x + -2, bounds.y + 0, bounds.width + -1, bounds.height + -1);
    }

    private void drawComplete(Graphics2D graphics, Widget w) {
        graphics.setColor(ColorUtil.colorWithAlpha((Color)this.solutionColor, (int)255));
        graphics.setStroke(new BasicStroke(2.0f));
        Rectangle bounds = w.getBounds();
        graphics.drawRect(bounds.x + -2, bounds.y + 0, bounds.width + -1, bounds.height + -1);
    }

    @Inject
    public RunedokuOverlay(RunedokuPlugin plugin, Client client, ItemManager itemManager) {
        super((Plugin)plugin);
        this.client = client;
        this.bigFont = FontManager.getDefaultBoldFont().deriveFont(24.0f);
        this.markFont = FontManager.getRunescapeSmallFont();
        this.setPosition(OverlayPosition.DETACHED);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.MED);
        this.runeImages = new AsyncBufferedImage[10];
        for (int i = 1; i < 10; ++i) {
            this.runeImages[i] = itemManager.getImage(RunedokuRune.getBySudokuNumber(i).getItemId());
        }
    }

    public void updateSelectedRune(RunedokuRune rune) {
        this.selectedRune = rune;
    }

    public void setShouldDrawNumbers(boolean shouldDrawNumbers) {
        this.shouldDrawNumbers = shouldDrawNumbers;
    }

    public void setShouldShowSolution(boolean shouldShowSolution) {
        this.shouldShowSolution = shouldShowSolution;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public void setErrorColor(Color errorColor) {
        this.errorColor = errorColor;
    }

    public void setSolutionColor(Color solutionColor) {
        this.solutionColor = solutionColor;
    }
}

