/*
 * Decompiled with CFR 0.152.
 */
package com.github.adituv.runedokuplugin;

import com.github.adituv.runedokuplugin.RunedokuRune;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunedokuCell {
    private static final Logger log = LoggerFactory.getLogger(RunedokuCell.class);
    private RunedokuRune rune;
    private int sudokuNumber;
    private int solutionNumber;
    private Widget widget;
    private final int columnNumber;
    private final int rowNumber;
    private final int boxNumber;
    private boolean[] marks = new boolean[9];

    public RunedokuCell(int boardWidth, int cellId) {
        this.columnNumber = cellId % boardWidth;
        this.rowNumber = cellId / boardWidth;
        if (boardWidth == 9) {
            this.boxNumber = 3 * (this.rowNumber / 3) + this.columnNumber / 3;
        } else if (boardWidth == 4) {
            this.boxNumber = 2 * (this.rowNumber / 2) + this.columnNumber / 2;
        } else {
            log.error(String.format("constructor: invalid boardWidth %d", boardWidth));
            this.boxNumber = 0;
        }
    }

    public void updateFromWidget(Widget w) {
        this.widget = w;
        this.rune = RunedokuRune.getByItemId(w.getItemId());
        this.sudokuNumber = this.rune != null ? this.rune.getSudokuNumber() : 0;
    }

    public void updateSolution(int solution) {
        this.solutionNumber = solution;
    }

    public RunedokuRune getRune() {
        return this.rune;
    }

    public int getSudokuNumber() {
        return this.sudokuNumber;
    }

    public int getSolutionNumber() {
        return this.solutionNumber;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getBoxNumber() {
        return this.boxNumber;
    }

    public boolean[] getMarks() {
        return this.marks;
    }

    public void setMarks(boolean[] marks) {
        this.marks = marks;
    }
}

