/*
 * Decompiled with CFR 0.152.
 */
package com.github.adituv.runedokuplugin;

import com.github.adituv.runedokuplugin.RunedokuCell;
import com.github.adituv.runedokuplugin.SudokuSolver;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunedokuBoard {
    private static final Logger log = LoggerFactory.getLogger(RunedokuBoard.class);
    private final Widget containerWidget;
    private final RunedokuCell[] cells;
    private final int width;
    private final int[][] rowNumbers;
    private final int[][] colNumbers;
    private final int[][] boxNumbers;
    private SudokuSolver solver;

    public boolean cellHasClash(RunedokuCell cell) {
        int sudokuIndex = cell.getSudokuNumber() - 1;
        return this.rowNumbers[cell.getRowNumber()][sudokuIndex] > 1 || this.colNumbers[cell.getColumnNumber()][sudokuIndex] > 1 || this.boxNumbers[cell.getBoxNumber()][sudokuIndex] > 1;
    }

    public boolean cellHasSolution(RunedokuCell cell) {
        return cell.getSolutionNumber() != 0;
    }

    public void updateCells() {
        int i;
        Widget[] children = this.containerWidget.getChildren();
        if (children == null) {
            log.error("error: children null");
            return;
        }
        for (i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.rowNumbers[i][j] = 0;
                this.colNumbers[i][j] = 0;
                this.boxNumbers[i][j] = 0;
            }
        }
        for (i = 0; i < children.length; ++i) {
            this.cells[i].updateFromWidget(children[i]);
            int sudokuIndex = this.cells[i].getSudokuNumber() - 1;
            if (sudokuIndex < 0) continue;
            int[] nArray = this.rowNumbers[this.cells[i].getRowNumber()];
            int n = sudokuIndex;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = this.colNumbers[this.cells[i].getColumnNumber()];
            int n2 = sudokuIndex;
            nArray2[n2] = nArray2[n2] + 1;
            int[] nArray3 = this.boxNumbers[this.cells[i].getBoxNumber()];
            int n3 = sudokuIndex;
            nArray3[n3] = nArray3[n3] + 1;
        }
    }

    public void solveBoard() {
        if (this.solver.solve()) {
            int[][] solutionGrid = this.solver.getSolution();
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.cells[i * this.width + j].updateSolution(solutionGrid[i][j]);
                }
            }
        } else {
            log.error("Unsolvable board state");
        }
    }

    public RunedokuCell getCell(int index) {
        if (index >= 0 && index < this.cells.length) {
            return this.cells[index];
        }
        return null;
    }

    public RunedokuBoard(Widget containerWidget, boolean solve) {
        this.containerWidget = containerWidget;
        Widget[] children = containerWidget.getChildren();
        if (children != null) {
            int i;
            if (children.length == 81) {
                this.width = 9;
                this.cells = new RunedokuCell[81];
                for (i = 0; i < children.length; ++i) {
                    this.cells[i] = new RunedokuCell(this.width, i);
                }
                this.rowNumbers = new int[9][9];
                this.colNumbers = new int[9][9];
                this.boxNumbers = new int[9][9];
            } else if (children.length == 16) {
                this.width = 4;
                this.cells = new RunedokuCell[16];
                for (i = 0; i < children.length; ++i) {
                    this.cells[i] = new RunedokuCell(this.width, i);
                }
                this.rowNumbers = new int[4][4];
                this.colNumbers = new int[4][4];
                this.boxNumbers = new int[4][4];
            } else {
                log.error(String.format("constructor: invalid board size %d", children.length));
                this.width = 0;
                this.cells = null;
                this.rowNumbers = null;
                this.colNumbers = null;
                this.boxNumbers = null;
            }
            if (solve && this.cells != null) {
                int[][] solutionBuilder = new int[9][9];
                for (int i2 = 0; i2 < children.length; ++i2) {
                    this.cells[i2].updateFromWidget(children[i2]);
                    int sudokuIndex = this.cells[i2].getSudokuNumber() - 1;
                    solutionBuilder[this.cells[i2].getRowNumber()][this.cells[i2].getColumnNumber()] = sudokuIndex + 1;
                }
                this.solver = new SudokuSolver(solutionBuilder);
                this.solveBoard();
            }
        } else {
            log.error("render: containerWidget children array is null");
            this.width = 0;
            this.cells = null;
            this.rowNumbers = null;
            this.colNumbers = null;
            this.boxNumbers = null;
        }
    }

    public Widget getContainerWidget() {
        return this.containerWidget;
    }

    public RunedokuCell[] getCells() {
        return this.cells;
    }

    public int getWidth() {
        return this.width;
    }

    public int[][] getRowNumbers() {
        return this.rowNumbers;
    }

    public int[][] getColNumbers() {
        return this.colNumbers;
    }

    public int[][] getBoxNumbers() {
        return this.boxNumbers;
    }

    public SudokuSolver getSolver() {
        return this.solver;
    }
}

